/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewVersion;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestViews
extends SparkExtensionsTestBase {
    private static final Namespace NAMESPACE = Namespace.of((String[])new String[]{"default"});
    private final String tableName = "table";

    @Before
    public void before() {
        spark.conf().set("spark.sql.defaultCatalog", this.catalogName);
        this.sql("USE %s", new Object[]{this.catalogName});
        this.sql("CREATE NAMESPACE IF NOT EXISTS %s", new Object[]{NAMESPACE});
        this.sql("CREATE TABLE %s (id INT, data STRING)", new Object[]{"table"});
    }

    @After
    public void removeTable() {
        this.sql("USE %s", new Object[]{this.catalogName});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{"table"});
    }

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.SPARK_WITH_VIEWS.catalogName(), SparkCatalogConfig.SPARK_WITH_VIEWS.implementation(), SparkCatalogConfig.SPARK_WITH_VIEWS.properties()}};
    }

    public TestViews(String catalog, String implementation, Map<String, String> properties) {
        super(catalog, implementation, properties);
    }

    @Test
    public void readFromView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("simpleView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withQuery("trino", String.format("SELECT non_existing FROM %s", "table"))).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        List expected = IntStream.rangeClosed(1, 10).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(10)).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void readFromTrinoView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("trinoView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("trino", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        List expected = IntStream.rangeClosed(1, 10).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(10)).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void readFromMultipleViews() throws NoSuchTableException {
        this.insertRows(6);
        String viewName = this.viewName("firstView");
        String secondView = this.viewName("secondView");
        String viewSQL = String.format("SELECT id FROM %s WHERE id <= 3", "table");
        String secondViewSQL = String.format("SELECT id FROM %s WHERE id > 3", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", viewSQL)).withDefaultNamespace(NAMESPACE)).withSchema(this.schema(viewSQL))).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)secondView)).withQuery("spark", secondViewSQL)).withDefaultNamespace(NAMESPACE)).withSchema(this.schema(secondViewSQL))).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1}), this.row(new Object[]{2}), this.row(new Object[]{3})});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{secondView})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{4}), this.row(new Object[]{5}), this.row(new Object[]{6})});
    }

    @Test
    public void readFromViewUsingNonExistingTable() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewWithNonExistingTable");
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", "SELECT id FROM non_existing")).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("The table or view `%s`.`%s`.`non_existing` cannot be found", this.catalogName, NAMESPACE));
    }

    @Test
    public void readFromViewUsingNonExistingTableColumn() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewWithNonExistingColumn");
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"non_existing", (Type)Types.LongType.get())});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", String.format("SELECT non_existing FROM %s", "table"))).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("A column or function parameter with name `non_existing` cannot be resolved");
    }

    @Test
    public void readFromViewUsingInvalidSQL() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewWithInvalidSQL");
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = this.tableCatalog().loadTable(TableIdentifier.of((Namespace)NAMESPACE, (String)"table")).schema();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", "invalid SQL")).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Invalid view text: invalid SQL. The view %s", viewName));
    }

    @Test
    public void readFromViewWithStaleSchema() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("staleView");
        String sql = String.format("SELECT id, data FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        this.sql("ALTER TABLE %s DROP COLUMN data", new Object[]{"table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("A column or function parameter with name `data` cannot be resolved");
    }

    @Test
    public void readFromViewHiddenByTempView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewHiddenByTempView");
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = this.tableCatalog().loadTable(TableIdentifier.of((Namespace)NAMESPACE, (String)"table")).schema();
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{viewName, "table"});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", String.format("SELECT id FROM %s WHERE id > 5", "table"))).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        List expected = IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(5)).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void readFromViewWithGlobalTempView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewWithGlobalTempView");
        String sql = String.format("SELECT id FROM %s WHERE id > 5", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        this.sql("CREATE GLOBAL TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{viewName, "table"});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM global_temp.%s", new Object[]{viewName})).hasSize(5)).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList()));
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(5)).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.rangeClosed(6, 10).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList()));
    }

    @Test
    public void readFromViewReferencingAnotherView() throws NoSuchTableException {
        this.insertRows(10);
        String firstView = this.viewName("viewBeingReferencedInAnotherView");
        String viewReferencingOtherView = this.viewName("viewReferencingOtherView");
        String firstSQL = String.format("SELECT id FROM %s WHERE id <= 5", "table");
        String secondSQL = String.format("SELECT id FROM %s WHERE id > 4", firstView);
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)firstView)).withQuery("spark", firstSQL)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(firstSQL))).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewReferencingOtherView)).withQuery("spark", secondSQL)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(secondSQL))).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewReferencingOtherView})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{5})});
    }

    @Test
    public void readFromViewReferencingTempView() throws NoSuchTableException {
        this.insertRows(10);
        String tempView = this.viewName("tempViewBeingReferencedInAnotherView");
        String viewReferencingTempView = this.viewName("viewReferencingTempView");
        String sql = String.format("SELECT id FROM %s", tempView);
        ViewCatalog viewCatalog = this.viewCatalog();
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{tempView, "table"});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewReferencingTempView)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        List expected = IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{tempView})).hasSize(5)).containsExactlyInAnyOrderElementsOf(expected);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewReferencingTempView})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The table or view").hasMessageContaining(tempView).hasMessageContaining("cannot be found");
    }

    @Test
    public void readFromViewReferencingAnotherViewHiddenByTempView() throws NoSuchTableException {
        this.insertRows(10);
        String innerViewName = this.viewName("inner_view");
        String outerViewName = this.viewName("outer_view");
        String innerViewSQL = String.format("SELECT * FROM %s WHERE id > 5", "table");
        String outerViewSQL = String.format("SELECT id FROM %s", innerViewName);
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)innerViewName)).withQuery("spark", innerViewSQL)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(innerViewSQL))).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)outerViewName)).withQuery("spark", outerViewSQL)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(outerViewSQL))).create();
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{innerViewName, "table"});
        this.sql("USE spark_catalog", new Object[0]);
        List tempViewRows = IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{innerViewName})).hasSize(5)).containsExactlyInAnyOrderElementsOf(tempViewRows);
        List expectedViewRows = IntStream.rangeClosed(6, 10).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.%s.%s", new Object[]{this.catalogName, NAMESPACE, outerViewName})).hasSize(5)).containsExactlyInAnyOrderElementsOf(expectedViewRows);
    }

    @Test
    public void readFromViewReferencingGlobalTempView() throws NoSuchTableException {
        this.insertRows(10);
        String globalTempView = this.viewName("globalTempViewBeingReferenced");
        String viewReferencingTempView = this.viewName("viewReferencingGlobalTempView");
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = this.tableCatalog().loadTable(TableIdentifier.of((Namespace)NAMESPACE, (String)"table")).schema();
        this.sql("CREATE GLOBAL TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{globalTempView, "table"});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewReferencingTempView)).withQuery("spark", String.format("SELECT id FROM global_temp.%s", globalTempView))).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        List expected = IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM global_temp.%s", new Object[]{globalTempView})).hasSize(5)).containsExactlyInAnyOrderElementsOf(expected);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewReferencingTempView})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The table or view").hasMessageContaining(globalTempView).hasMessageContaining("cannot be found");
    }

    @Test
    public void readFromViewReferencingTempFunction() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewReferencingTempFunction");
        String functionName = this.viewName("test_avg");
        String sql = String.format("SELECT %s(id) FROM %s", functionName, "table");
        this.sql("CREATE TEMPORARY FUNCTION %s AS 'org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage'", new Object[]{functionName});
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = this.tableCatalog().loadTable(TableIdentifier.of((Namespace)NAMESPACE, (String)"table")).schema();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((ListAssert)Assertions.assertThat((List)this.sql(sql, new Object[0])).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{5.5})});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith(String.format("Cannot load function: %s.%s.%s", this.catalogName, NAMESPACE, functionName));
    }

    @Test
    public void readFromViewWithCTE() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewWithCTE");
        String sql = String.format("WITH max_by_data AS (SELECT max(id) as max FROM %s) SELECT max, count(1) AS count FROM max_by_data GROUP BY max", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{10, 1L})});
    }

    @Test
    public void rewriteFunctionIdentifier() {
        String viewName = this.viewName("rewriteFunctionIdentifier");
        String sql = "SELECT iceberg_version() AS version";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql(sql, new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot resolve function").hasMessageContaining("iceberg_version");
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"version", (Type)Types.StringType.get())});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(Namespace.of((String[])new String[]{"system"}))).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{IcebergBuild.version()})});
    }

    @Test
    public void builtinFunctionIdentifierNotRewritten() {
        String viewName = this.viewName("builtinFunctionIdentifierNotRewritten");
        String sql = "SELECT trim('  abc   ') AS result";
        ViewCatalog viewCatalog = this.viewCatalog();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"result", (Type)Types.StringType.get())});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(Namespace.of((String[])new String[]{"system"}))).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{"abc"})});
    }

    @Test
    public void rewriteFunctionIdentifierWithNamespace() {
        String viewName = this.viewName("rewriteFunctionIdentifierWithNamespace");
        String sql = "SELECT system.bucket(100, 'a') AS bucket_result, 'a' AS value";
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(Namespace.of((String[])new String[]{"system"}))).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        this.sql("USE spark_catalog", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql(sql, new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot resolve function").hasMessageContaining("`system`.`bucket`");
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.%s.%s", new Object[]{this.catalogName, NAMESPACE, viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{50, "a"})});
    }

    @Test
    public void fullFunctionIdentifier() {
        String viewName = this.viewName("fullFunctionIdentifier");
        String sql = String.format("SELECT %s.system.bucket(100, 'a') AS bucket_result, 'a' AS value", this.catalogName);
        this.sql("USE spark_catalog", new Object[0]);
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(Namespace.of((String[])new String[]{"system"}))).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.%s.%s", new Object[]{this.catalogName, NAMESPACE, viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{50, "a"})});
    }

    @Test
    public void fullFunctionIdentifierNotRewrittenLoadFailure() {
        String viewName = this.viewName("fullFunctionIdentifierNotRewrittenLoadFailure");
        String sql = "SELECT spark_catalog.system.bucket(100, 'a') AS bucket_result, 'a' AS value";
        this.sql("USE spark_catalog", new Object[0]);
        this.sql("CREATE NAMESPACE IF NOT EXISTS system", new Object[0]);
        this.sql("USE %s", new Object[]{this.catalogName});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"bucket_result", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"value", (Type)Types.StringType.get())});
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(Namespace.of((String[])new String[]{"system"}))).withDefaultCatalog(this.catalogName)).withSchema(schema)).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The function `system`.`bucket` cannot be found");
    }

    private Schema schema(String sql) {
        return SparkSchemaUtil.convert((StructType)spark.sql(sql).schema());
    }

    private ViewCatalog viewCatalog() {
        Catalog icebergCatalog = Spark3Util.loadIcebergCatalog((SparkSession)spark, (String)this.catalogName);
        Assertions.assertThat((Object)icebergCatalog).isInstanceOf(ViewCatalog.class);
        return (ViewCatalog)icebergCatalog;
    }

    private Catalog tableCatalog() {
        return Spark3Util.loadIcebergCatalog((SparkSession)spark, (String)this.catalogName);
    }

    @Test
    public void renameView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("originalView");
        String renamedView = this.viewName("renamedView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        this.sql("ALTER VIEW %s RENAME TO %s", new Object[]{viewName, renamedView});
        List expected = IntStream.rangeClosed(1, 10).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{renamedView})).hasSize(10)).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void renameViewHiddenByTempView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("originalView");
        String renamedView = this.viewName("renamedView");
        String sql = String.format("SELECT id FROM %s WHERE id > 5", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{viewName, "table"});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        this.sql("ALTER VIEW %s RENAME TO %s", new Object[]{viewName, renamedView});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{renamedView})).hasSize(5)).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList()));
        Assertions.assertThat((boolean)viewCatalog.viewExists(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName))).isTrue();
        Assertions.assertThat((boolean)viewCatalog.viewExists(TableIdentifier.of((Namespace)NAMESPACE, (String)renamedView))).isFalse();
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(5)).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.rangeClosed(6, 10).mapToObj(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList()));
        this.sql("ALTER VIEW %s RENAME TO %s", new Object[]{viewName, renamedView});
        Assertions.assertThat((boolean)viewCatalog.viewExists(TableIdentifier.of((Namespace)NAMESPACE, (String)renamedView))).isTrue();
    }

    @Test
    public void renameViewToDifferentTargetCatalog() {
        String viewName = this.viewName("originalView");
        String renamedView = this.viewName("renamedView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s RENAME TO spark_catalog.%s", new Object[]{viewName, renamedView})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot move view between catalogs: from=spark_with_views and to=spark_catalog");
    }

    @Test
    public void renameNonExistingView() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW non_existing RENAME TO target", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("The table or view `non_existing` cannot be found");
    }

    @Test
    public void renameViewTargetAlreadyExistsAsView() {
        String viewName = this.viewName("renameViewSource");
        String target = this.viewName("renameViewTarget");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)target)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s RENAME TO %s", new Object[]{viewName, target})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view default.%s because it already exists", target));
    }

    @Test
    public void renameViewTargetAlreadyExistsAsTable() {
        String viewName = this.viewName("renameViewSource");
        String target = this.viewName("renameViewTarget");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        this.sql("CREATE TABLE %s (id INT, data STRING)", new Object[]{target});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s RENAME TO %s", new Object[]{viewName, target})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view default.%s because it already exists", target));
    }

    @Test
    public void dropView() {
        String viewName = this.viewName("viewToBeDropped");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        TableIdentifier identifier = TableIdentifier.of((Namespace)NAMESPACE, (String)viewName);
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(identifier).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        Assertions.assertThat((boolean)viewCatalog.viewExists(identifier)).isTrue();
        this.sql("DROP VIEW %s", new Object[]{viewName});
        Assertions.assertThat((boolean)viewCatalog.viewExists(identifier)).isFalse();
    }

    @Test
    public void dropNonExistingView() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP VIEW non_existing", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("The view %s.%s cannot be found", new Object[]{NAMESPACE, "non_existing"});
    }

    @Test
    public void dropViewIfExists() {
        String viewName = this.viewName("viewToBeDropped");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        TableIdentifier identifier = TableIdentifier.of((Namespace)NAMESPACE, (String)viewName);
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(identifier).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        Assertions.assertThat((boolean)viewCatalog.viewExists(identifier)).isTrue();
        this.sql("DROP VIEW IF EXISTS %s", new Object[]{viewName});
        Assertions.assertThat((boolean)viewCatalog.viewExists(identifier)).isFalse();
        Assertions.assertThatNoException().isThrownBy(() -> this.sql("DROP VIEW IF EXISTS %s", new Object[]{viewName}));
    }

    @Test
    public void dropGlobalTempView() {
        String globalTempView = this.viewName("globalViewToBeDropped");
        this.sql("CREATE GLOBAL TEMPORARY VIEW %s AS SELECT id FROM %s", new Object[]{globalTempView, "table"});
        Assertions.assertThat((boolean)this.v1SessionCatalog().getGlobalTempView(globalTempView).isDefined()).isTrue();
        this.sql("DROP VIEW global_temp.%s", new Object[]{globalTempView});
        Assertions.assertThat((boolean)this.v1SessionCatalog().getGlobalTempView(globalTempView).isDefined()).isFalse();
    }

    @Test
    public void dropTempView() {
        String tempView = this.viewName("tempViewToBeDropped");
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s", new Object[]{tempView, "table"});
        Assertions.assertThat((boolean)this.v1SessionCatalog().getTempView(tempView).isDefined()).isTrue();
        this.sql("DROP VIEW %s", new Object[]{tempView});
        Assertions.assertThat((boolean)this.v1SessionCatalog().getTempView(tempView).isDefined()).isFalse();
    }

    @Test
    public void dropV1View() {
        String v1View = this.viewName("v1ViewToBeDropped");
        this.sql("USE spark_catalog", new Object[0]);
        this.sql("CREATE NAMESPACE IF NOT EXISTS %s", new Object[]{NAMESPACE});
        this.sql("CREATE TABLE %s (id INT, data STRING)", new Object[]{"table"});
        this.sql("CREATE VIEW %s AS SELECT id FROM %s", new Object[]{v1View, "table"});
        this.sql("USE %s", new Object[]{this.catalogName});
        Assertions.assertThat((boolean)this.v1SessionCatalog().tableExists(new org.apache.spark.sql.catalyst.TableIdentifier(v1View))).isTrue();
        this.sql("DROP VIEW spark_catalog.%s.%s", new Object[]{NAMESPACE, v1View});
        Assertions.assertThat((boolean)this.v1SessionCatalog().tableExists(new org.apache.spark.sql.catalyst.TableIdentifier(v1View))).isFalse();
        this.sql("USE spark_catalog", new Object[0]);
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{"table"});
    }

    private SessionCatalog v1SessionCatalog() {
        return spark.sessionState().catalogManager().v1SessionCatalog();
    }

    private String viewName(String viewName) {
        return viewName + new Random().nextInt(1000000);
    }

    @Test
    public void createViewIfNotExists() {
        String viewName = this.viewName("viewThatAlreadyExists");
        this.sql("CREATE VIEW %s AS SELECT id FROM %s", new Object[]{viewName, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS SELECT id FROM %s", new Object[]{viewName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s because it already exists", NAMESPACE, viewName));
        Assertions.assertThatNoException().isThrownBy(() -> this.sql("CREATE VIEW IF NOT EXISTS %s AS SELECT id FROM %s", new Object[]{viewName, "table"}));
    }

    @Test
    public void createOrReplaceView() throws NoSuchTableException {
        this.insertRows(6);
        String viewName = this.viewName("simpleView");
        this.sql("CREATE OR REPLACE VIEW %s AS SELECT id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT id FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1}), this.row(new Object[]{2}), this.row(new Object[]{3})});
        this.sql("CREATE OR REPLACE VIEW %s AS SELECT id FROM %s WHERE id > 3", new Object[]{viewName, "table"});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT id FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{4}), this.row(new Object[]{5}), this.row(new Object[]{6})});
    }

    @Test
    public void createViewWithInvalidSQL() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW simpleViewWithInvalidSQL AS invalid SQL", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("Syntax error");
    }

    @Test
    public void createViewReferencingTempView() throws NoSuchTableException {
        this.insertRows(10);
        String tempView = this.viewName("temporaryViewBeingReferencedInAnotherView");
        String viewReferencingTempView = this.viewName("viewReferencingTemporaryView");
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{tempView, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS SELECT id FROM %s", new Object[]{viewReferencingTempView, tempView})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewReferencingTempView)).hasMessageContaining("that references temporary view:").hasMessageContaining(tempView);
    }

    @Test
    public void createViewReferencingGlobalTempView() throws NoSuchTableException {
        this.insertRows(10);
        String globalTempView = this.viewName("globalTemporaryViewBeingReferenced");
        String viewReferencingTempView = this.viewName("viewReferencingGlobalTemporaryView");
        this.sql("CREATE GLOBAL TEMPORARY VIEW %s AS SELECT id FROM %s WHERE id <= 5", new Object[]{globalTempView, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS SELECT id FROM global_temp.%s", new Object[]{viewReferencingTempView, globalTempView})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewReferencingTempView)).hasMessageContaining("that references temporary view:").hasMessageContaining(String.format("%s.%s", "global_temp", globalTempView));
    }

    @Test
    public void createViewReferencingTempFunction() {
        String viewName = this.viewName("viewReferencingTemporaryFunction");
        String functionName = this.viewName("test_avg_func");
        this.sql("CREATE TEMPORARY FUNCTION %s AS 'org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage'", new Object[]{functionName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS SELECT %s(id) FROM %s", new Object[]{viewName, functionName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("that references temporary function:").hasMessageContaining(functionName);
    }

    @Test
    public void createViewReferencingQualifiedTempFunction() {
        String viewName = this.viewName("viewReferencingTemporaryFunction");
        String functionName = this.viewName("test_avg_func_qualified");
        this.sql("CREATE TEMPORARY FUNCTION %s AS 'org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage'", new Object[]{functionName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS SELECT %s.%s.%s(id) FROM %s", new Object[]{viewName, this.catalogName, NAMESPACE, functionName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot resolve function").hasMessageContaining(String.format("`%s`.`%s`.`%s`", this.catalogName, NAMESPACE, functionName));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS SELECT %s.%s(id) FROM %s", new Object[]{viewName, NAMESPACE, functionName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot resolve function").hasMessageContaining(String.format("`%s`.`%s`", NAMESPACE, functionName));
    }

    @Test
    public void createViewUsingNonExistingTable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW viewWithNonExistingTable AS SELECT id FROM non_existing", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("The table or view `non_existing` cannot be found");
    }

    @Test
    public void createViewWithMismatchedColumnCounts() {
        String viewName = this.viewName("viewWithMismatchedColumnCounts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s (id, data) AS SELECT id FROM %s", new Object[]{viewName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("not enough data columns").hasMessageContaining("View columns: id, data").hasMessageContaining("Data columns: id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s (id) AS SELECT id, data FROM %s", new Object[]{viewName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("too many data columns").hasMessageContaining("View columns: id").hasMessageContaining("Data columns: id, data");
    }

    @Test
    public void createViewWithColumnAliases() throws NoSuchTableException {
        this.insertRows(6);
        String viewName = this.viewName("viewWithColumnAliases");
        this.sql("CREATE VIEW %s (new_id COMMENT 'ID', new_data COMMENT 'DATA') AS SELECT id, data FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        View view = this.viewCatalog().loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName));
        Assertions.assertThat((Map)view.properties()).containsEntry((Object)"spark.query-column-names", (Object)"id,data");
        Assertions.assertThat((List)view.schema().columns()).hasSize(2);
        Types.NestedField first = (Types.NestedField)view.schema().columns().get(0);
        Assertions.assertThat((String)first.name()).isEqualTo("new_id");
        Assertions.assertThat((String)first.doc()).isEqualTo("ID");
        Types.NestedField second = (Types.NestedField)view.schema().columns().get(1);
        Assertions.assertThat((String)second.name()).isEqualTo("new_data");
        Assertions.assertThat((String)second.doc()).isEqualTo("DATA");
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT new_id FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1}), this.row(new Object[]{2}), this.row(new Object[]{3})});
        this.sql("DROP VIEW %s", new Object[]{viewName});
        this.sql("CREATE VIEW %s (new_data, new_id) AS SELECT data, id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT new_id FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1}), this.row(new Object[]{2}), this.row(new Object[]{3})});
    }

    @Test
    public void createViewWithDuplicateColumnNames() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW viewWithDuplicateColumnNames (new_id, new_id) AS SELECT id, id FROM %s WHERE id <= 3", new Object[]{"table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The column `new_id` already exists");
    }

    @Test
    public void createViewWithDuplicateQueryColumnNames() throws NoSuchTableException {
        this.insertRows(3);
        String viewName = this.viewName("viewWithDuplicateQueryColumnNames");
        String sql = String.format("SELECT id, id FROM %s WHERE id <= 3", "table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The column `id` already exists");
        this.sql("CREATE VIEW %s (id_one, id_two) AS %s", new Object[]{viewName, sql});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1, 1}), this.row(new Object[]{2, 2}), this.row(new Object[]{3, 3})});
    }

    @Test
    public void createViewWithCTE() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("simpleViewWithCTE");
        String sql = String.format("WITH max_by_data AS (SELECT max(id) as max FROM %s) SELECT max, count(1) AS count FROM max_by_data GROUP BY max", "table");
        this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{10, 1L})});
    }

    @Test
    public void createViewWithConflictingNamesForCTEAndTempView() throws NoSuchTableException {
        this.insertRows(10);
        String viewName = this.viewName("viewWithConflictingNamesForCTEAndTempView");
        String cteName = this.viewName("cteName");
        String sql = String.format("WITH %s AS (SELECT max(id) as max FROM %s) (SELECT max, count(1) AS count FROM %s GROUP BY max)", cteName, "table", cteName);
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT * from %s", new Object[]{cteName, "table"});
        this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{10, 1L})});
    }

    @Test
    public void createViewWithCTEReferencingTempView() {
        String viewName = this.viewName("viewWithCTEReferencingTempView");
        String tempViewInCTE = this.viewName("tempViewInCTE");
        String sql = String.format("WITH max_by_data AS (SELECT max(id) as max FROM %s) SELECT max, count(1) AS count FROM max_by_data GROUP BY max", tempViewInCTE);
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id FROM %s WHERE ID <= 5", new Object[]{tempViewInCTE, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("that references temporary view:").hasMessageContaining(tempViewInCTE);
    }

    @Test
    public void createViewWithCTEReferencingTempFunction() {
        String viewName = this.viewName("viewWithCTEReferencingTempFunction");
        String functionName = this.viewName("avg_function_in_cte");
        String sql = String.format("WITH avg_data AS (SELECT %s(id) as avg FROM %s) SELECT avg, count(1) AS count FROM avg_data GROUP BY max", functionName, "table");
        this.sql("CREATE TEMPORARY FUNCTION %s AS 'org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage'", new Object[]{functionName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("that references temporary function:").hasMessageContaining(functionName);
    }

    @Test
    public void createViewWithNonExistingQueryColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW viewWithNonExistingQueryColumn AS SELECT non_existing FROM %s WHERE id <= 3", new Object[]{"table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining("A column or function parameter with name `non_existing` cannot be resolved");
    }

    @Test
    public void createViewWithSubqueryExpressionUsingTempView() {
        String viewName = this.viewName("viewWithSubqueryExpression");
        String tempView = this.viewName("simpleTempView");
        String sql = String.format("SELECT * FROM %s WHERE id = (SELECT id FROM %s)", "table", tempView);
        this.sql("CREATE TEMPORARY VIEW %s AS SELECT id from %s WHERE id = 5", new Object[]{tempView, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("that references temporary view:").hasMessageContaining(tempView);
    }

    @Test
    public void createViewWithSubqueryExpressionUsingGlobalTempView() {
        String viewName = this.viewName("simpleViewWithSubqueryExpression");
        String globalTempView = this.viewName("simpleGlobalTempView");
        String sql = String.format("SELECT * FROM %s WHERE id = (SELECT id FROM global_temp.%s)", "table", globalTempView);
        this.sql("CREATE GLOBAL TEMPORARY VIEW %s AS SELECT id from %s WHERE id = 5", new Object[]{globalTempView, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("that references temporary view:").hasMessageContaining(String.format("%s.%s", "global_temp", globalTempView));
    }

    @Test
    public void createViewWithSubqueryExpressionUsingTempFunction() {
        String viewName = this.viewName("viewWithSubqueryExpression");
        String functionName = this.viewName("avg_function_in_subquery");
        String sql = String.format("SELECT * FROM %s WHERE id < (SELECT %s(id) FROM %s)", "table", functionName, "table");
        this.sql("CREATE TEMPORARY FUNCTION %s AS 'org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage'", new Object[]{functionName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("Cannot create view %s.%s.%s", this.catalogName, NAMESPACE, viewName)).hasMessageContaining("that references temporary function:").hasMessageContaining(functionName);
    }

    @Test
    public void createViewWithSubqueryExpressionInFilterThatIsRewritten() throws NoSuchTableException {
        this.insertRows(5);
        String viewName = this.viewName("viewWithSubqueryExpression");
        String sql = String.format("SELECT id FROM %s WHERE id = (SELECT max(id) FROM %s)", "table", "table");
        this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{5})});
        this.sql("USE spark_catalog", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql(sql, new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("The table or view `%s` cannot be found", "table"));
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.%s.%s", new Object[]{this.catalogName, NAMESPACE, viewName})).hasSize(1)).containsExactly((Object[])new Object[][]{this.row(new Object[]{5})});
    }

    @Test
    public void createViewWithSubqueryExpressionInQueryThatIsRewritten() throws NoSuchTableException {
        this.insertRows(3);
        String viewName = this.viewName("viewWithSubqueryExpression");
        String sql = String.format("SELECT (SELECT max(id) FROM %s) max_id FROM %s", "table", "table");
        this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{viewName})).hasSize(3)).containsExactly((Object[])new Object[][]{this.row(new Object[]{3}), this.row(new Object[]{3}), this.row(new Object[]{3})});
        this.sql("USE spark_catalog", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql(sql, new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining(String.format("The table or view `%s` cannot be found", "table"));
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.%s.%s", new Object[]{this.catalogName, NAMESPACE, viewName})).hasSize(3)).containsExactly((Object[])new Object[][]{this.row(new Object[]{3}), this.row(new Object[]{3}), this.row(new Object[]{3})});
    }

    @Test
    public void describeView() {
        String viewName = this.viewName("describeView");
        this.sql("CREATE VIEW %s AS SELECT id, data FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        Assertions.assertThat((List)this.sql("DESCRIBE %s", new Object[]{viewName})).containsExactly((Object[])new Object[][]{this.row(new Object[]{"id", "int", ""}), this.row(new Object[]{"data", "string", ""})});
    }

    @Test
    public void describeExtendedView() {
        String viewName = this.viewName("describeExtendedView");
        String sql = String.format("SELECT id, data FROM %s WHERE id <= 3", "table");
        this.sql("CREATE VIEW %s (new_id COMMENT 'ID', new_data COMMENT 'DATA') COMMENT 'view comment' AS %s", new Object[]{viewName, sql});
        Assertions.assertThat((List)this.sql("DESCRIBE EXTENDED %s", new Object[]{viewName})).contains((Object[])new Object[][]{this.row(new Object[]{"new_id", "int", "ID"}), this.row(new Object[]{"new_data", "string", "DATA"}), this.row(new Object[]{"", "", ""}), this.row(new Object[]{"# Detailed View Information", "", ""}), this.row(new Object[]{"Comment", "view comment", ""}), this.row(new Object[]{"View Catalog and Namespace", String.format("%s.%s", this.catalogName, NAMESPACE), ""}), this.row(new Object[]{"View Query Output Columns", "[id, data]", ""}), this.row(new Object[]{"View Properties", String.format("['format-version' = '1', 'location' = '/%s/%s', 'provider' = 'iceberg']", NAMESPACE, viewName), ""})});
    }

    @Test
    public void showViewProperties() {
        String viewName = this.viewName("showViewProps");
        this.sql("CREATE VIEW %s TBLPROPERTIES ('key1'='val1', 'key2'='val2') AS SELECT id, data FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        Assertions.assertThat((List)this.sql("SHOW TBLPROPERTIES %s", new Object[]{viewName})).contains((Object[])new Object[][]{this.row(new Object[]{"key1", "val1"}), this.row(new Object[]{"key2", "val2"})});
    }

    @Test
    public void showViewPropertiesByKey() {
        String viewName = this.viewName("showViewPropsByKey");
        this.sql("CREATE VIEW %s AS SELECT id, data FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        Assertions.assertThat((List)this.sql("SHOW TBLPROPERTIES %s", new Object[]{viewName})).contains((Object[])new Object[][]{this.row(new Object[]{"provider", "iceberg"})});
        Assertions.assertThat((List)this.sql("SHOW TBLPROPERTIES %s (provider)", new Object[]{viewName})).contains((Object[])new Object[][]{this.row(new Object[]{"provider", "iceberg"})});
        Assertions.assertThat((List)this.sql("SHOW TBLPROPERTIES %s (non.existing)", new Object[]{viewName})).contains((Object[])new Object[][]{this.row(new Object[]{"non.existing", String.format("View %s.%s.%s does not have property: non.existing", this.catalogName, NAMESPACE, viewName)})});
    }

    @Test
    public void showViews() throws NoSuchTableException {
        this.insertRows(6);
        String sql = String.format("SELECT * from %s", "table");
        String v1 = this.viewName("v1");
        String prefixV2 = this.viewName("prefixV2");
        String prefixV3 = this.viewName("prefixV3");
        String globalViewForListing = this.viewName("globalViewForListing");
        String tempViewForListing = this.viewName("tempViewForListing");
        this.sql("CREATE VIEW %s AS %s", new Object[]{v1, sql});
        this.sql("CREATE VIEW %s AS %s", new Object[]{prefixV2, sql});
        this.sql("CREATE VIEW %s AS %s", new Object[]{prefixV3, sql});
        this.sql("CREATE GLOBAL TEMPORARY VIEW %s AS %s", new Object[]{globalViewForListing, sql});
        this.sql("CREATE TEMPORARY VIEW %s AS %s", new Object[]{tempViewForListing, sql});
        Object[] tempView = this.row(new Object[]{"", tempViewForListing.toLowerCase(Locale.ROOT), true});
        Assertions.assertThat((List)this.sql("SHOW VIEWS", new Object[0])).contains((Object[])new Object[][]{this.row(new Object[]{NAMESPACE.toString(), prefixV2, false}), this.row(new Object[]{NAMESPACE.toString(), prefixV3, false}), this.row(new Object[]{NAMESPACE.toString(), v1, false}), tempView});
        Assertions.assertThat((List)this.sql("SHOW VIEWS IN %s", new Object[]{this.catalogName})).contains((Object[])new Object[][]{this.row(new Object[]{NAMESPACE.toString(), prefixV2, false}), this.row(new Object[]{NAMESPACE.toString(), prefixV3, false}), this.row(new Object[]{NAMESPACE.toString(), v1, false}), tempView});
        Assertions.assertThat((List)this.sql("SHOW VIEWS IN %s.%s", new Object[]{this.catalogName, NAMESPACE})).contains((Object[])new Object[][]{this.row(new Object[]{NAMESPACE.toString(), prefixV2, false}), this.row(new Object[]{NAMESPACE.toString(), prefixV3, false}), this.row(new Object[]{NAMESPACE.toString(), v1, false}), tempView});
        Assertions.assertThat((List)this.sql("SHOW VIEWS LIKE 'pref*'", new Object[0])).contains((Object[])new Object[][]{this.row(new Object[]{NAMESPACE.toString(), prefixV2, false}), this.row(new Object[]{NAMESPACE.toString(), prefixV3, false})});
        Assertions.assertThat((List)this.sql("SHOW VIEWS LIKE 'non-existing'", new Object[0])).isEmpty();
        Assertions.assertThat((List)this.sql("SHOW VIEWS IN spark_catalog.default", new Object[0])).contains((Object[])new Object[][]{tempView});
        Assertions.assertThat((List)this.sql("SHOW VIEWS IN global_temp", new Object[0])).contains((Object[])new Object[][]{this.row(new Object[]{"global_temp", globalViewForListing.toLowerCase(Locale.ROOT), true}), tempView});
        this.sql("USE spark_catalog", new Object[0]);
        Assertions.assertThat((List)this.sql("SHOW VIEWS", new Object[0])).contains((Object[])new Object[][]{tempView});
        Assertions.assertThat((List)this.sql("SHOW VIEWS IN default", new Object[0])).contains((Object[])new Object[][]{tempView});
    }

    @Test
    public void showViewsWithCurrentNamespace() {
        String namespaceOne = "show_views_ns1";
        String namespaceTwo = "show_views_ns2";
        String viewOne = this.viewName("viewOne");
        String viewTwo = this.viewName("viewTwo");
        this.sql("CREATE NAMESPACE IF NOT EXISTS %s", new Object[]{namespaceOne});
        this.sql("CREATE NAMESPACE IF NOT EXISTS %s", new Object[]{namespaceTwo});
        this.sql("CREATE VIEW %s.%s AS SELECT * FROM %s.%s", new Object[]{namespaceOne, viewOne, NAMESPACE, "table"});
        this.sql("CREATE VIEW %s.%s AS SELECT * FROM %s.%s", new Object[]{namespaceTwo, viewTwo, NAMESPACE, "table"});
        Object[] v1 = this.row(new Object[]{namespaceOne, viewOne, false});
        Object[] v2 = this.row(new Object[]{namespaceTwo, viewTwo, false});
        ((ListAssert)Assertions.assertThat((List)this.sql("SHOW VIEWS IN %s.%s", new Object[]{this.catalogName, namespaceOne})).contains((Object[])new Object[][]{v1})).doesNotContain((Object[])new Object[][]{v2});
        this.sql("USE %s", new Object[]{namespaceOne});
        ((ListAssert)Assertions.assertThat((List)this.sql("SHOW VIEWS", new Object[0])).contains((Object[])new Object[][]{v1})).doesNotContain((Object[])new Object[][]{v2});
        ((ListAssert)Assertions.assertThat((List)this.sql("SHOW VIEWS LIKE 'viewOne*'", new Object[0])).contains((Object[])new Object[][]{v1})).doesNotContain((Object[])new Object[][]{v2});
        ((ListAssert)Assertions.assertThat((List)this.sql("SHOW VIEWS IN %s.%s", new Object[]{this.catalogName, namespaceTwo})).contains((Object[])new Object[][]{v2})).doesNotContain((Object[])new Object[][]{v1});
        this.sql("USE %s", new Object[]{namespaceTwo});
        ((ListAssert)Assertions.assertThat((List)this.sql("SHOW VIEWS", new Object[0])).contains((Object[])new Object[][]{v2})).doesNotContain((Object[])new Object[][]{v1});
        ((ListAssert)Assertions.assertThat((List)this.sql("SHOW VIEWS LIKE 'viewTwo*'", new Object[0])).contains((Object[])new Object[][]{v2})).doesNotContain((Object[])new Object[][]{v1});
    }

    @Test
    public void showCreateSimpleView() {
        String viewName = this.viewName("showCreateSimpleView");
        String sql = String.format("SELECT id, data FROM %s WHERE id <= 3", "table");
        this.sql("CREATE VIEW %s AS %s", new Object[]{viewName, sql});
        String expected = String.format("CREATE VIEW %s.%s.%s (\n  id,\n  data)\nTBLPROPERTIES (\n  'format-version' = '1',\n  'location' = '/%s/%s',\n  'provider' = 'iceberg')\nAS\n%s\n", this.catalogName, NAMESPACE, viewName, NAMESPACE, viewName, sql);
        Assertions.assertThat((List)this.sql("SHOW CREATE TABLE %s", new Object[]{viewName})).containsExactly((Object[])new Object[][]{this.row(new Object[]{expected})});
    }

    @Test
    public void showCreateComplexView() {
        String viewName = this.viewName("showCreateComplexView");
        String sql = String.format("SELECT id, data FROM %s WHERE id <= 3", "table");
        this.sql("CREATE VIEW %s (new_id COMMENT 'ID', new_data COMMENT 'DATA')COMMENT 'view comment' TBLPROPERTIES ('key1'='val1', 'key2'='val2') AS %s", new Object[]{viewName, sql});
        String expected = String.format("CREATE VIEW %s.%s.%s (\n  new_id COMMENT 'ID',\n  new_data COMMENT 'DATA')\nCOMMENT 'view comment'\nTBLPROPERTIES (\n  'format-version' = '1',\n  'key1' = 'val1',\n  'key2' = 'val2',\n  'location' = '/%s/%s',\n  'provider' = 'iceberg')\nAS\n%s\n", this.catalogName, NAMESPACE, viewName, NAMESPACE, viewName, sql);
        Assertions.assertThat((List)this.sql("SHOW CREATE TABLE %s", new Object[]{viewName})).containsExactly((Object[])new Object[][]{this.row(new Object[]{expected})});
    }

    @Test
    public void alterViewSetProperties() {
        String viewName = this.viewName("viewWithSetProperties");
        this.sql("CREATE VIEW %s AS SELECT id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ViewCatalog viewCatalog = this.viewCatalog();
        ((MapAssert)Assertions.assertThat((Map)viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).properties()).doesNotContainKey((Object)"key1")).doesNotContainKey((Object)"comment");
        this.sql("ALTER VIEW %s SET TBLPROPERTIES ('key1' = 'val1', 'comment' = 'view comment')", new Object[]{viewName});
        ((MapAssert)Assertions.assertThat((Map)viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).properties()).containsEntry((Object)"key1", (Object)"val1")).containsEntry((Object)"comment", (Object)"view comment");
        this.sql("ALTER VIEW %s SET TBLPROPERTIES ('key1' = 'new_val1')", new Object[]{viewName});
        ((MapAssert)Assertions.assertThat((Map)viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).properties()).containsEntry((Object)"key1", (Object)"new_val1")).containsEntry((Object)"comment", (Object)"view comment");
    }

    @Test
    public void alterViewSetReservedProperties() {
        String viewName = this.viewName("viewWithSetReservedProperties");
        this.sql("CREATE VIEW %s AS SELECT id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s SET TBLPROPERTIES ('provider' = 'val1')", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The feature is not supported: provider is a reserved table property");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s SET TBLPROPERTIES ('location' = 'random_location')", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The feature is not supported: location is a reserved table property");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s SET TBLPROPERTIES ('format-version' = '99')", new Object[]{viewName})).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot set reserved property: 'format-version'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s SET TBLPROPERTIES ('spark.query-column-names' = 'a,b,c')", new Object[]{viewName})).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot set reserved property: 'spark.query-column-names'");
    }

    @Test
    public void alterViewUnsetProperties() {
        String viewName = this.viewName("viewWithUnsetProperties");
        this.sql("CREATE VIEW %s AS SELECT id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ViewCatalog viewCatalog = this.viewCatalog();
        ((MapAssert)Assertions.assertThat((Map)viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).properties()).doesNotContainKey((Object)"key1")).doesNotContainKey((Object)"comment");
        this.sql("ALTER VIEW %s SET TBLPROPERTIES ('key1' = 'val1', 'comment' = 'view comment')", new Object[]{viewName});
        ((MapAssert)Assertions.assertThat((Map)viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).properties()).containsEntry((Object)"key1", (Object)"val1")).containsEntry((Object)"comment", (Object)"view comment");
        this.sql("ALTER VIEW %s UNSET TBLPROPERTIES ('key1')", new Object[]{viewName});
        ((MapAssert)Assertions.assertThat((Map)viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).properties()).doesNotContainKey((Object)"key1")).containsEntry((Object)"comment", (Object)"view comment");
    }

    @Test
    public void alterViewUnsetUnknownProperty() {
        String viewName = this.viewName("viewWithUnsetUnknownProp");
        this.sql("CREATE VIEW %s AS SELECT id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES ('unknown-key')", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot remove property that is not set: 'unknown-key'");
        Assertions.assertThatNoException().isThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES IF EXISTS ('unknown-key')", new Object[]{viewName}));
    }

    @Test
    public void alterViewUnsetReservedProperties() {
        String viewName = this.viewName("viewWithUnsetReservedProperties");
        this.sql("CREATE VIEW %s AS SELECT id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES ('provider')", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The feature is not supported: provider is a reserved table property");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES ('location')", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The feature is not supported: location is a reserved table property");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES ('format-version')", new Object[]{viewName})).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot unset reserved property: 'format-version'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES ('spark.query-column-names')", new Object[]{viewName})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot remove property that is not set: 'spark.query-column-names'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s UNSET TBLPROPERTIES IF EXISTS ('spark.query-column-names')", new Object[]{viewName})).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot unset reserved property: 'spark.query-column-names'");
    }

    @Test
    public void createOrReplaceViewWithColumnAliases() throws NoSuchTableException {
        this.insertRows(6);
        String viewName = this.viewName("viewWithColumnAliases");
        this.sql("CREATE VIEW %s (new_id COMMENT 'ID', new_data COMMENT 'DATA') AS SELECT id, data FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        View view = this.viewCatalog().loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName));
        Assertions.assertThat((Map)view.properties()).containsEntry((Object)"spark.query-column-names", (Object)"id,data");
        Assertions.assertThat((List)view.schema().columns()).hasSize(2);
        Types.NestedField first = (Types.NestedField)view.schema().columns().get(0);
        Assertions.assertThat((String)first.name()).isEqualTo("new_id");
        Assertions.assertThat((String)first.doc()).isEqualTo("ID");
        Types.NestedField second = (Types.NestedField)view.schema().columns().get(1);
        Assertions.assertThat((String)second.name()).isEqualTo("new_data");
        Assertions.assertThat((String)second.doc()).isEqualTo("DATA");
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT new_id FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1}), this.row(new Object[]{2}), this.row(new Object[]{3})});
        this.sql("CREATE OR REPLACE VIEW %s (data2 COMMENT 'new data', id2 COMMENT 'new ID') AS SELECT data, id FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT data2, id2 FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{"2", 1}), this.row(new Object[]{"4", 2}), this.row(new Object[]{"6", 3})});
        view = this.viewCatalog().loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName));
        Assertions.assertThat((Map)view.properties()).containsEntry((Object)"spark.query-column-names", (Object)"data,id");
        Assertions.assertThat((List)view.schema().columns()).hasSize(2);
        first = (Types.NestedField)view.schema().columns().get(0);
        Assertions.assertThat((String)first.name()).isEqualTo("data2");
        Assertions.assertThat((String)first.doc()).isEqualTo("new data");
        second = (Types.NestedField)view.schema().columns().get(1);
        Assertions.assertThat((String)second.name()).isEqualTo("id2");
        Assertions.assertThat((String)second.doc()).isEqualTo("new ID");
    }

    @Test
    public void alterViewIsNotSupported() throws NoSuchTableException {
        this.insertRows(6);
        String viewName = this.viewName("alteredView");
        this.sql("CREATE VIEW %s AS SELECT id, data FROM %s WHERE id <= 3", new Object[]{viewName, "table"});
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT id FROM %s", new Object[]{viewName})).hasSize(3)).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1}), this.row(new Object[]{2}), this.row(new Object[]{3})});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER VIEW %s AS SELECT id FROM %s WHERE id > 3", new Object[]{viewName, "table"})).isInstanceOf(AnalysisException.class)).hasMessageContaining("ALTER VIEW <viewName> AS is not supported. Use CREATE OR REPLACE VIEW instead");
    }

    @Test
    public void createOrReplaceViewKeepsViewHistory() {
        String viewName = this.viewName("viewWithHistoryAfterReplace");
        String sql = String.format("SELECT id, data FROM %s WHERE id <= 3", "table");
        String updatedSql = String.format("SELECT id FROM %s WHERE id > 3", "table");
        this.sql("CREATE VIEW %s (new_id COMMENT 'some ID', new_data COMMENT 'some data') AS %s", new Object[]{viewName, sql});
        View view = this.viewCatalog().loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName));
        Assertions.assertThat((List)view.history()).hasSize(1);
        Assertions.assertThat((String)view.sqlFor("spark").sql()).isEqualTo(sql);
        Assertions.assertThat((int)view.currentVersion().versionId()).isEqualTo(1);
        Assertions.assertThat((int)view.currentVersion().schemaId()).isEqualTo(0);
        Assertions.assertThat((Map)view.schemas()).hasSize(1);
        Assertions.assertThat((Object)view.schema().asStruct()).isEqualTo((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"new_id", (Type)Types.IntegerType.get(), (String)"some ID"), Types.NestedField.optional((int)1, (String)"new_data", (Type)Types.StringType.get(), (String)"some data")}).asStruct());
        this.sql("CREATE OR REPLACE VIEW %s (updated_id COMMENT 'updated ID') AS %s", new Object[]{viewName, updatedSql});
        view = this.viewCatalog().loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName));
        Assertions.assertThat((List)view.history()).hasSize(2);
        Assertions.assertThat((String)view.sqlFor("spark").sql()).isEqualTo(updatedSql);
        Assertions.assertThat((int)view.currentVersion().versionId()).isEqualTo(2);
        Assertions.assertThat((int)view.currentVersion().schemaId()).isEqualTo(1);
        Assertions.assertThat((Map)view.schemas()).hasSize(2);
        Assertions.assertThat((Object)view.schema().asStruct()).isEqualTo((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"updated_id", (Type)Types.IntegerType.get(), (String)"updated ID")}).asStruct());
    }

    @Test
    public void replacingTrinoViewShouldFail() {
        String viewName = this.viewName("trinoView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("trino", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot replace view due to loss of view dialects (replace.drop-dialect.allowed=false):\nPrevious dialects: [trino]\nNew dialects: [spark]");
    }

    @Test
    public void replacingTrinoAndSparkViewShouldFail() {
        String viewName = this.viewName("trinoAndSparkView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("trino", sql)).withQuery("spark", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE VIEW %s AS %s", new Object[]{viewName, sql})).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot replace view due to loss of view dialects (replace.drop-dialect.allowed=false):\nPrevious dialects: [trino, spark]\nNew dialects: [spark]");
    }

    @Test
    public void replacingViewWithDialectDropAllowed() {
        String viewName = this.viewName("trinoView");
        String sql = String.format("SELECT id FROM %s", "table");
        ViewCatalog viewCatalog = this.viewCatalog();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewCatalog.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName)).withQuery("trino", sql)).withDefaultNamespace(NAMESPACE)).withDefaultCatalog(this.catalogName)).withSchema(this.schema(sql))).create();
        this.sql("CREATE OR REPLACE VIEW %s TBLPROPERTIES ('%s'='true') AS SELECT id FROM %s", new Object[]{viewName, "replace.drop-dialect.allowed", "table"});
        View view = viewCatalog.loadView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName));
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((List)view.currentVersion().representations()).hasSize(1)).first()).asInstanceOf(InstanceOfAssertFactories.type(SQLViewRepresentation.class))).isEqualTo((Object)ImmutableSQLViewRepresentation.builder().dialect("spark").sql(sql).build());
        Assertions.assertThat((List)view.history()).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((List)view.history()).element(0)).extracting(ViewHistoryEntry::versionId).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((List)view.history()).element(1)).extracting(ViewHistoryEntry::versionId).isEqualTo((Object)2);
        Assertions.assertThat((Iterable)view.versions()).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((Iterable)view.versions()).element(0)).extracting(ViewVersion::versionId).isEqualTo((Object)1);
        ((ObjectAssert)Assertions.assertThat((Iterable)view.versions()).element(1)).extracting(ViewVersion::versionId).isEqualTo((Object)2);
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((List)((ViewVersion)Lists.newArrayList((Iterable)view.versions()).get(0)).representations()).hasSize(1)).first()).asInstanceOf(InstanceOfAssertFactories.type(SQLViewRepresentation.class))).isEqualTo((Object)ImmutableSQLViewRepresentation.builder().dialect("trino").sql(sql).build());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((List)((ViewVersion)Lists.newArrayList((Iterable)view.versions()).get(1)).representations()).hasSize(1)).first()).asInstanceOf(InstanceOfAssertFactories.type(SQLViewRepresentation.class))).isEqualTo((Object)ImmutableSQLViewRepresentation.builder().dialect("spark").sql(sql).build());
    }

    @Test
    public void createViewWithRecursiveCycle() {
        String viewOne = this.viewName("viewOne");
        String viewTwo = this.viewName("viewTwo");
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewOne, "table"});
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewTwo, viewOne});
        String view1 = String.format("%s.%s.%s", this.catalogName, NAMESPACE, viewOne);
        String view2 = String.format("%s.%s.%s", this.catalogName, NAMESPACE, viewTwo);
        String cycle = String.format("%s -> %s -> %s", view1, view2, view1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE VIEW %s AS SELECT * FROM %s", new Object[]{viewOne, view2})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith(String.format("Recursive cycle in view detected: %s (cycle: %s)", view1, cycle));
    }

    @Test
    public void createViewWithRecursiveCycleToV1View() {
        String viewOne = this.viewName("view_one");
        String viewTwo = this.viewName("view_two");
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewOne, "table"});
        this.sql("USE spark_catalog", new Object[0]);
        this.sql("CREATE VIEW %s AS SELECT * FROM %s.%s.%s", new Object[]{viewTwo, this.catalogName, NAMESPACE, viewOne});
        this.sql("USE %s", new Object[]{this.catalogName});
        String view1 = String.format("%s.%s.%s", this.catalogName, NAMESPACE, viewOne);
        String view2 = String.format("%s.%s.%s", "spark_catalog", NAMESPACE, viewTwo);
        String cycle = String.format("%s -> %s -> %s", view1, view2, view1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE VIEW %s AS SELECT * FROM %s", new Object[]{viewOne, view2})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith(String.format("Recursive cycle in view detected: %s (cycle: %s)", view1, cycle));
    }

    @Test
    public void createViewWithRecursiveCycleInCTE() {
        String viewOne = this.viewName("viewOne");
        String viewTwo = this.viewName("viewTwo");
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewOne, "table"});
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewTwo, viewOne});
        String sql = String.format("WITH max_by_data AS (SELECT max(id) as max FROM %s) SELECT max, count(1) AS count FROM max_by_data GROUP BY max", viewTwo);
        String view1 = String.format("%s.%s.%s", this.catalogName, NAMESPACE, viewOne);
        String cycle = String.format("%s -> %s -> %s", view1, viewTwo, view1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE VIEW %s AS %s", new Object[]{viewOne, sql})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith(String.format("Recursive cycle in view detected: %s (cycle: %s)", view1, cycle));
    }

    @Test
    public void createViewWithRecursiveCycleInSubqueryExpression() {
        String viewOne = this.viewName("viewOne");
        String viewTwo = this.viewName("viewTwo");
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewOne, "table"});
        this.sql("CREATE VIEW %s AS SELECT * FROM %s", new Object[]{viewTwo, viewOne});
        String sql = String.format("SELECT * FROM %s WHERE id = (SELECT id FROM %s)", "table", viewTwo);
        String view1 = String.format("%s.%s.%s", this.catalogName, NAMESPACE, viewOne);
        String cycle = String.format("%s -> %s -> %s", view1, viewTwo, view1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE VIEW %s AS %s", new Object[]{viewOne, sql})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith(String.format("Recursive cycle in view detected: %s (cycle: %s)", view1, cycle));
    }

    private void insertRows(int numRows) throws NoSuchTableException {
        ArrayList records = Lists.newArrayListWithCapacity((int)numRows);
        for (int i = 1; i <= numRows; ++i) {
            records.add(new SimpleRecord(Integer.valueOf(i), Integer.toString(i * 2)));
        }
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo("table").append();
    }
}

