/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class TestWriteAborts
extends SparkExtensionsTestBase {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"io-impl", (Object)CustomFileIO.class.getName(), (Object)"default-namespace", (Object)"default")}, {"testhivebulk", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"io-impl", (Object)CustomBulkFileIO.class.getName(), (Object)"default-namespace", (Object)"default")}};
    }

    public TestWriteAborts(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testBatchAppend() throws Exception {
        String dataLocation = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg PARTITIONED BY (data)TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.data.path", dataLocation});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"), (Object)new SimpleRecord(Integer.valueOf(3), "a"), (Object)new SimpleRecord(Integer.valueOf(4), "b"));
        Dataset inputDF = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> inputDF.coalesce(1).sortWithinPartitions("id", new String[0]).writeTo(this.tableName).option("use-table-distribution-and-ordering", "false").append()).isInstanceOf(SparkException.class)).hasMessageContaining("Encountered records that belong to already closed files");
        this.assertEquals("Should be no records", this.sql("SELECT * FROM %s", new Object[]{this.tableName}), (List)ImmutableList.of());
        this.assertEquals("Should be no orphan data files", (List)ImmutableList.of(), this.sql("CALL %s.system.remove_orphan_files(table => '%s', older_than => %dL, location => '%s')", new Object[]{this.catalogName, this.tableName, System.currentTimeMillis() + 5000L, dataLocation}));
    }

    public static class CustomBulkFileIO
    extends CustomFileIO
    implements SupportsBulkOperations {
        @Override
        public void deleteFile(String path) {
            throw new UnsupportedOperationException("Only bulk deletes are supported");
        }

        public void deleteFiles(Iterable<String> paths) throws BulkDeletionFailureException {
            for (String path : paths) {
                this.delegate().deleteFile(path);
            }
        }
    }

    public static class CustomFileIO
    implements FileIO {
        private final FileIO delegate = new HadoopFileIO(new Configuration());

        protected FileIO delegate() {
            return this.delegate;
        }

        public InputFile newInputFile(String path) {
            return this.delegate.newInputFile(path);
        }

        public OutputFile newOutputFile(String path) {
            return this.delegate.newOutputFile(path);
        }

        public void deleteFile(String path) {
            this.delegate.deleteFile(path);
        }

        public Map<String, String> properties() {
            return this.delegate.properties();
        }

        public void initialize(Map<String, String> properties) {
            this.delegate.initialize(properties);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

