/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.BeforeAll;

public abstract class ExtensionsTestBase
extends CatalogTestBase {
    private static final Random RANDOM = ThreadLocalRandom.current();

    @BeforeAll
    public static void startMetastoreAndSpark() {
        TestBase.metastore = new TestHiveMetastore();
        metastore.start();
        TestBase.hiveConf = metastore.hiveConf();
        TestBase.spark = SparkSession.builder().master("local[2]").config("spark.testing", "true").config(SQLConf.PARTITION_OVERWRITE_MODE().key(), "dynamic").config("spark.sql.extensions", IcebergSparkSessionExtensions.class.getName()).config("spark.hadoop." + HiveConf.ConfVars.METASTOREURIS.varname, hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)).config("spark.sql.shuffle.partitions", "4").config("spark.sql.hive.metastorePartitionPruningFallbackOnException", "true").config("spark.sql.legacy.respectNullabilityInTextDatasetConversion", "true").config(SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), String.valueOf(RANDOM.nextBoolean())).enableHiveSupport().getOrCreate();
        TestBase.catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
    }
}

