/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.execution.CommandResultExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkPlanUtil {
    private static final AdaptiveSparkPlanHelper SPARK_HELPER = new AdaptiveSparkPlanHelper(){};

    private SparkPlanUtil() {
    }

    public static List<SparkPlan> collectLeaves(SparkPlan plan) {
        return SparkPlanUtil.toJavaList(SPARK_HELPER.collectLeaves(SparkPlanUtil.actualPlan(plan)));
    }

    public static List<SparkPlan> collectBatchScans(SparkPlan plan) {
        List<SparkPlan> leaves = SparkPlanUtil.collectLeaves(plan);
        return leaves.stream().filter(scan -> scan instanceof BatchScanExec).collect(Collectors.toList());
    }

    private static SparkPlan actualPlan(SparkPlan plan) {
        if (plan instanceof CommandResultExec) {
            return ((CommandResultExec)plan).commandPhysicalPlan();
        }
        return plan;
    }

    private static <T> List<T> toJavaList(Seq<T> seq) {
        return (List)JavaConverters.seqAsJavaListConverter(seq).asJava();
    }
}

