/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.extensions.SparkPlanUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.execution.SparkPlan;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class SparkRowLevelOperationsTestBase
extends ExtensionsTestBase {
    private static final Random RANDOM = ThreadLocalRandom.current();
    @Parameter(index=3)
    protected FileFormat fileFormat;
    @Parameter(index=4)
    protected boolean vectorized;
    @Parameter(index=5)
    protected String distributionMode;
    @Parameter(index=6)
    protected boolean fanoutEnabled;
    @Parameter(index=7)
    protected String branch;
    @Parameter(index=8)
    protected PlanningMode planningMode;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, format = {3}, vectorized = {4}, distributionMode = {5}, fanout = {6}, branch = {7}, planningMode = {8}")
    public static Object[][] parameters() {
        return new Object[][]{{"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default"), FileFormat.ORC, true, "none", true, "main", PlanningMode.LOCAL}, {"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default"), FileFormat.PARQUET, true, "none", false, "test", PlanningMode.DISTRIBUTED}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop"), FileFormat.PARQUET, RANDOM.nextBoolean(), "hash", true, null, PlanningMode.LOCAL}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"clients", (Object)"1", (Object)"parquet-enabled", (Object)"false", (Object)"cache-enabled", (Object)"false"), FileFormat.AVRO, false, "range", false, "test", PlanningMode.DISTRIBUTED}};
    }

    protected abstract Map<String, String> extraTableProperties();

    protected void initTable() {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s', '%s' '%s', '%s' '%s', '%s' '%s', '%s' '%s')", new Object[]{this.tableName, "write.format.default", this.fileFormat, "write.distribution-mode", this.distributionMode, "write.spark.fanout.enabled", String.valueOf(this.fanoutEnabled), "read.data-planning-mode", this.planningMode.modeName(), "read.delete-planning-mode", this.planningMode.modeName()});
        switch (this.fileFormat) {
            case PARQUET: {
                this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%b')", new Object[]{this.tableName, "read.parquet.vectorization.enabled", this.vectorized});
                break;
            }
            case ORC: {
                this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%b')", new Object[]{this.tableName, "read.orc.vectorization.enabled", this.vectorized});
                break;
            }
            case AVRO: {
                Assertions.assertThat((boolean)this.vectorized).isFalse();
            }
        }
        Map<String, String> props = this.extraTableProperties();
        props.forEach((prop, value) -> this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, prop, value}));
    }

    protected void createAndInitTable(String schema) {
        this.createAndInitTable(schema, null);
    }

    protected void createAndInitTable(String schema, String jsonData) {
        this.createAndInitTable(schema, "", jsonData);
    }

    protected void createAndInitTable(String schema, String partitioning, String jsonData) {
        this.sql("CREATE TABLE %s (%s) USING iceberg %s", new Object[]{this.tableName, schema, partitioning});
        this.initTable();
        if (jsonData != null) {
            try {
                Dataset<Row> ds = this.toDS(schema, jsonData);
                ds.coalesce(1).writeTo(this.tableName).append();
                this.createBranchIfNeeded();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException("Failed to write data", e);
            }
        }
    }

    protected void append(String table, String jsonData) {
        this.append(table, null, jsonData);
    }

    protected void append(String table, String schema, String jsonData) {
        try {
            Dataset<Row> ds = this.toDS(schema, jsonData);
            ds.coalesce(1).writeTo(table).append();
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException("Failed to write data", e);
        }
    }

    protected void createOrReplaceView(String name, String jsonData) {
        this.createOrReplaceView(name, null, jsonData);
    }

    protected void createOrReplaceView(String name, String schema, String jsonData) {
        Dataset<Row> ds = this.toDS(schema, jsonData);
        ds.createOrReplaceTempView(name);
    }

    protected <T> void createOrReplaceView(String name, List<T> data, Encoder<T> encoder) {
        spark.createDataset(data, encoder).createOrReplaceTempView(name);
    }

    private Dataset<Row> toDS(String schema, String jsonData) {
        List jsonRows = Arrays.stream(jsonData.split("\n")).filter(str -> str.trim().length() > 0).collect(Collectors.toList());
        Dataset jsonDS = spark.createDataset(jsonRows, Encoders.STRING());
        if (schema != null) {
            return spark.read().schema(schema).json(jsonDS);
        }
        return spark.read().json(jsonDS);
    }

    protected void validateDelete(Snapshot snapshot, String changedPartitionCount, String deletedDataFiles) {
        this.validateSnapshot(snapshot, "delete", changedPartitionCount, deletedDataFiles, null, null);
    }

    protected void validateCopyOnWrite(Snapshot snapshot, String changedPartitionCount, String deletedDataFiles, String addedDataFiles) {
        this.validateSnapshot(snapshot, "overwrite", changedPartitionCount, deletedDataFiles, null, addedDataFiles);
    }

    protected void validateMergeOnRead(Snapshot snapshot, String changedPartitionCount, String addedDeleteFiles, String addedDataFiles) {
        this.validateSnapshot(snapshot, "overwrite", changedPartitionCount, null, addedDeleteFiles, addedDataFiles);
    }

    protected void validateSnapshot(Snapshot snapshot, String operation, String changedPartitionCount, String deletedDataFiles, String addedDeleteFiles, String addedDataFiles) {
        ((AbstractStringAssert)Assertions.assertThat((String)snapshot.operation()).as("Operation must match", new Object[0])).isEqualTo(operation);
        this.validateProperty(snapshot, "changed-partition-count", changedPartitionCount);
        this.validateProperty(snapshot, "deleted-data-files", deletedDataFiles);
        this.validateProperty(snapshot, "added-delete-files", addedDeleteFiles);
        this.validateProperty(snapshot, "added-data-files", addedDataFiles);
    }

    protected void validateProperty(Snapshot snapshot, String property, Set<String> expectedValues) {
        String actual = (String)snapshot.summary().get(property);
        ((AbstractStringAssert)Assertions.assertThat((String)actual).as("Snapshot property " + property + " has unexpected value, actual = " + actual + ", expected one of : " + String.join((CharSequence)",", expectedValues), new Object[0])).isIn(expectedValues);
    }

    protected void validateProperty(Snapshot snapshot, String property, String expectedValue) {
        String actual = (String)snapshot.summary().get(property);
        ((AbstractStringAssert)Assertions.assertThat((String)actual).as("Snapshot property " + property + " has unexpected value.", new Object[0])).isEqualTo(expectedValue);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataFile writeDataFile(Table table, List<GenericRecord> records) {
        try {
            OutputFile file = Files.localOutput((File)this.temp.resolve(this.fileFormat.addExtension(UUID.randomUUID().toString())).toFile());
            try (DataWriter dataWriter = Parquet.writeData((OutputFile)file).forTable(table).createWriterFunc(GenericParquetWriter::buildWriter).overwrite().build();){
                for (GenericRecord record : records) {
                    dataWriter.write((Object)record);
                }
            }
            return dataWriter.toDataFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String commitTarget() {
        return this.branch == null ? this.tableName : String.format("%s.branch_%s", this.tableName, this.branch);
    }

    protected String selectTarget() {
        return this.branch == null ? this.tableName : String.format("%s VERSION AS OF '%s'", this.tableName, this.branch);
    }

    protected void createBranchIfNeeded() {
        if (this.branch != null && !this.branch.equals("main")) {
            this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, this.branch});
        }
    }

    protected boolean supportsVectorization() {
        return this.vectorized && (this.isParquet() || this.isCopyOnWrite());
    }

    private boolean isParquet() {
        return this.fileFormat.equals((Object)FileFormat.PARQUET);
    }

    private boolean isCopyOnWrite() {
        return this.extraTableProperties().containsValue(RowLevelOperationMode.COPY_ON_WRITE.modeName());
    }

    protected void assertAllBatchScansVectorized(SparkPlan plan) {
        List<SparkPlan> batchScans = SparkPlanUtil.collectBatchScans(plan);
        ((ListAssert)Assertions.assertThat(batchScans).hasSizeGreaterThan(0)).allMatch(SparkPlan::supportsColumnar);
    }
}

