/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.File;
import java.nio.file.Path;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.joda.time.DateTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestAddFilesProcedure
extends ExtensionsTestBase {
    @Parameter(index=3)
    private int formatVersion;
    private final String sourceTableName = "source_table";
    private File fileTableDir;
    @TempDir
    private Path temp;
    private static final List<Object[]> emptyQueryResult = Lists.newArrayList();
    private static final StructField[] struct = new StructField[]{new StructField("id", DataTypes.IntegerType, true, Metadata.empty()), new StructField("name", DataTypes.StringType, true, Metadata.empty()), new StructField("dept", DataTypes.StringType, true, Metadata.empty()), new StructField("subdept", DataTypes.StringType, true, Metadata.empty())};
    private static final StructField[] dateStruct = new StructField[]{new StructField("id", DataTypes.IntegerType, true, Metadata.empty()), new StructField("name", DataTypes.StringType, true, Metadata.empty()), new StructField("ts", DataTypes.DateType, true, Metadata.empty()), new StructField("dept", DataTypes.StringType, true, Metadata.empty())};

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, formatVersion = {3}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties(), 1}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), 2}, {SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties(), 2}};
    }

    @BeforeEach
    public void setupTempDirs() {
        this.fileTableDir = this.temp.toFile();
    }

    @AfterEach
    public void dropTables() {
        this.sql("DROP TABLE IF EXISTS %s PURGE", new Object[]{"source_table"});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void addDataUnpartitioned() {
        this.createUnpartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void deleteAndAddBackUnpartitioned() {
        this.createUnpartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        String deleteData = "DELETE FROM %s";
        this.sql(deleteData, new Object[]{this.tableName});
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Disabled
    public void addDataUnpartitionedOrc() {
        this.createUnpartitionedFileTable("orc");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`orc`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assertions.assertThat((Object)result).isEqualTo((Object)2L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addAvroFile() throws Exception {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualTo((Object)"spark_catalog");
        Schema schema = (Schema)SchemaBuilder.record((String)"record").fields().requiredInt("id").requiredString("data").endRecord();
        GenericData.Record record1 = new GenericData.Record(schema);
        record1.put("id", (Object)1L);
        record1.put("data", (Object)"a");
        GenericData.Record record2 = new GenericData.Record(schema);
        record2.put("id", (Object)2L);
        record2.put("data", (Object)"b");
        File outputFile = this.temp.resolve("test.avro").toFile();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, outputFile);
        dataFileWriter.append((Object)record1);
        dataFileWriter.append((Object)record2);
        dataFileWriter.close();
        this.createIcebergTable("id Long, data String");
        List result = this.sql("CALL %s.system.add_files('%s', '`avro`.`%s`')", new Object[]{this.catalogName, this.tableName, outputFile.getPath()});
        this.assertOutput(result, 1L, 1L);
        ArrayList expected = Lists.newArrayList((Object[])new Object[][]{{1L, "a"}, {2L, "b"}});
        this.assertEquals("Iceberg table contains correct data", expected, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        List actualRecordCount = this.sql("select %s from %s.files", new Object[]{DataFile.RECORD_COUNT.name(), this.tableName});
        ArrayList expectedRecordCount = Lists.newArrayList();
        expectedRecordCount.add(new Object[]{2L});
        this.assertEquals("Iceberg file metadata should have correct metadata count", expectedRecordCount, actualRecordCount);
    }

    @Disabled
    public void addDataUnpartitionedAvro() {
        this.createUnpartitionedFileTable("avro");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`avro`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assertions.assertThat((Object)result).isEqualTo((Object)2L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataUnpartitionedHive() {
        this.createUnpartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        List result = this.sql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataUnpartitionedExtraCol() {
        this.createUnpartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String, foo string");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataUnpartitionedMissingCol() {
        this.createUnpartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataPartitionedMissingCol() {
        this.createPartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String", "PARTITIONED BY (id)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 8L, 4L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataPartitioned() {
        this.createPartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 8L, 4L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Disabled
    public void addDataPartitionedOrc() {
        this.createPartitionedFileTable("orc");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assertions.assertThat((Object)result).isEqualTo((Object)8L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Disabled
    public void addDataPartitionedAvro() {
        this.createPartitionedFileTable("avro");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`avro`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assertions.assertThat((Object)result).isEqualTo((Object)8L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataPartitionedHive() {
        this.createPartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List result = this.sql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result, 8L, 4L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addPartitionToPartitioned() {
        this.createPartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void deleteAndAddBackPartitioned() {
        this.createPartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        String deleteData = "DELETE FROM %s where id = 1";
        this.sql(deleteData, new Object[]{this.tableName});
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addPartitionToPartitionedSnapshotIdInheritanceEnabledInTwoRuns() {
        this.createPartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "compatibility.snapshot-id-inheritance.enabled"});
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 2))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id < 3 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
        String manifestPath = (String)((Object[])this.sql("select path from %s.manifests", new Object[]{this.tableName}).get(0))[0];
        Pattern uuidPattern = Pattern.compile("[a-f0-9]{8}(?:-[a-f0-9]{4}){4}[a-f0-9]{8}");
        Matcher matcher = uuidPattern.matcher(manifestPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)matcher.find()).as("verify manifest path has uuid", new Object[0])).isTrue();
    }

    @TestTemplate
    public void addDataPartitionedByDateToPartitioned() {
        this.createDatePartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, date Date", "PARTITIONED BY (date)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('date', '2021-01-01'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, date FROM %s WHERE date = '2021-01-01' ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, date FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addDataPartitionedVerifyPartitionTypeInferredCorrectly() {
        this.createTableWithTwoPartitions("parquet");
        this.createIcebergTable("id Integer, name String, date Date, dept String", "PARTITIONED BY (date, dept)");
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('date', '2021-01-01'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        String sqlFormat = "SELECT id, name, dept, date FROM %s WHERE date = '2021-01-01' and dept= '01' ORDER BY id";
        this.assertEquals("Iceberg table contains correct data", this.sql(sqlFormat, new Object[]{"source_table"}), this.sql(sqlFormat, new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addFilteredPartitionsToPartitioned() {
        this.createCompositePartitionedTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id, dept)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addFilteredPartitionsToPartitioned2() {
        this.createCompositePartitionedTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id, dept)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('dept', 'hr'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 6L, 3L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE dept = 'hr' ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addFilteredPartitionsToPartitionedWithNullValueFilteringOnId() {
        this.createCompositePartitionedTableWithNullValueInPartitionColumn("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id, dept)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addFilteredPartitionsToPartitionedWithNullValueFilteringOnDept() {
        this.createCompositePartitionedTableWithNullValueInPartitionColumn("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id, dept)");
        List result = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('dept', 'hr'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(result, 6L, 3L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE dept = 'hr' ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addWeirdCaseHiveTable() {
        this.createWeirdCaseTable();
        this.createIcebergTable("id Integer, `naMe` String, dept String, subdept String", "PARTITIONED BY (`naMe`)");
        List result = this.sql("CALL %s.system.add_files('%s', '%s', map('naMe', 'John Doe'))", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result, 2L, 1L);
        List expected = this.sql("SELECT id, `naMe`, dept, subdept from %s ORDER BY id", new Object[]{"source_table"}).stream().filter(r -> r[1].equals("John Doe")).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT id, `naMe`, dept, subdept from %s WHERE `naMe` = 'John Doe' ORDER BY id", new Object[]{"source_table"})).as("If this assert breaks it means that Spark has fixed the pushdown issue", new Object[0])).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)this.sql("SELECT id, `naMe`, dept, subdept FROM %s WHERE `naMe` = 'John Doe' ORDER BY id", new Object[]{this.tableName})).as("We should be able to pushdown mixed case partition keys", new Object[0])).hasSize(2);
        this.assertEquals("Iceberg table contains correct data", expected, this.sql("SELECT id, `naMe`, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void addPartitionToPartitionedHive() {
        this.createPartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List result = this.sql("CALL %s.system.add_files('%s', '%s', map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void invalidDataImport() {
        this.createPartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot use partition filter with an unpartitioned table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot add partitioned files to an unpartitioned table");
    }

    @TestTemplate
    public void invalidDataImportPartitioned() {
        this.createUnpartitionedFileTable("parquet");
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('x', '1', 'y', '2'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot add data files to target table").hasMessageContaining("is greater than the number of partitioned columns");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('dept', '2'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot add files to target table").hasMessageContaining("specified partition filter refers to columns that are not partitioned");
    }

    @TestTemplate
    public void addTwice() {
        this.createPartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List result1 = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result1, 2L, 1L);
        List result2 = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 2))", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result2, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{this.tableName}));
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 2 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 2 ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void duplicateDataPartitioned() {
        this.createPartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"})).isInstanceOf(IllegalStateException.class)).hasMessageStartingWith("Cannot complete import because data files to be imported already exist within the target table");
    }

    @TestTemplate
    public void duplicateDataPartitionedAllowed() {
        this.createPartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List result1 = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result1, 2L, 1L);
        List result2 = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1),check_duplicate_files => false)", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result2, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 UNION ALL SELECT id, name, dept, subdept FROM %s WHERE id = 1", new Object[]{"source_table", "source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s", new Object[]{this.tableName, this.tableName}));
    }

    @TestTemplate
    public void duplicateDataUnpartitioned() {
        this.createUnpartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        this.sql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"})).isInstanceOf(IllegalStateException.class)).hasMessageStartingWith("Cannot complete import because data files to be imported already exist within the target table");
    }

    @TestTemplate
    public void duplicateDataUnpartitionedAllowed() {
        this.createUnpartitionedHiveTable();
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        List result1 = this.sql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result1, 2L, 1L);
        List result2 = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s',check_duplicate_files => false)", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(result2, 2L, 1L);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM (SELECT * FROM %s UNION ALL SELECT * from %s) ORDER BY id", new Object[]{"source_table", "source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testEmptyImportDoesNotThrow() {
        this.createIcebergTable("id Integer, name String, dept String, subdept String");
        List pathResult = this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertOutput(pathResult, 0L, 0L);
        this.assertEquals("Iceberg table contains no added data when importing from an empty path", emptyQueryResult, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        String createHive = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) STORED AS parquet";
        this.sql(createHive, new Object[]{"source_table"});
        List tableResult = this.sql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertOutput(tableResult, 0L, 0L);
        this.assertEquals("Iceberg table contains no added data when importing from an empty table", emptyQueryResult, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testPartitionedImportFromEmptyPartitionDoesNotThrow() {
        this.createPartitionedHiveTable();
        int emptyPartitionId = 999;
        this.sql("ALTER TABLE %s ADD PARTITION (id = '%d') LOCATION '%d'", new Object[]{"source_table", 999, 999});
        this.createIcebergTable("id Integer, name String, dept String, subdept String", "PARTITIONED BY (id)");
        List tableResult = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', %d))", new Object[]{this.catalogName, this.tableName, "source_table", 999});
        this.assertOutput(tableResult, 0L, 0L);
        this.assertEquals("Iceberg table contains no added data when importing from an empty table", emptyQueryResult, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testAddFilesWithParallelism() {
        this.createUnpartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        List result = this.sql("CALL %s.system.add_files(table => '%s', source_table => '%s', parallelism => 2)", new Object[]{this.catalogName, this.tableName, "source_table"});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{2L, 1L})), result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    private Dataset<Row> unpartitionedDF() {
        return spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{1, "John Doe", "hr", "communications"}), (Object)RowFactory.create((Object[])new Object[]{2, "Jane Doe", "hr", "salary"}), (Object)RowFactory.create((Object[])new Object[]{3, "Matt Doe", "hr", "communications"}), (Object)RowFactory.create((Object[])new Object[]{4, "Will Doe", "facilities", "all"})), new StructType(struct)).repartition(1);
    }

    private Dataset<Row> singleNullRecordDF() {
        return spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{null, null, null, null})), new StructType(struct)).repartition(1);
    }

    private Dataset<Row> partitionedDF() {
        return this.unpartitionedDF().select("name", new String[]{"dept", "subdept", "id"});
    }

    private Dataset<Row> compositePartitionedDF() {
        return this.unpartitionedDF().select("name", new String[]{"subdept", "id", "dept"});
    }

    private Dataset<Row> compositePartitionedNullRecordDF() {
        return this.singleNullRecordDF().select("name", new String[]{"subdept", "id", "dept"});
    }

    private Dataset<Row> weirdColumnNamesDF() {
        Dataset<Row> unpartitionedDF = this.unpartitionedDF();
        return unpartitionedDF.select(new Column[]{unpartitionedDF.col("id"), unpartitionedDF.col("subdept"), unpartitionedDF.col("dept"), unpartitionedDF.col("name").as("naMe")});
    }

    private static Date toDate(String value) {
        return new Date(DateTime.parse((String)value).getMillis());
    }

    private Dataset<Row> dateDF() {
        return spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{1, "John Doe", TestAddFilesProcedure.toDate("2021-01-01"), "01"}), (Object)RowFactory.create((Object[])new Object[]{2, "Jane Doe", TestAddFilesProcedure.toDate("2021-01-01"), "01"}), (Object)RowFactory.create((Object[])new Object[]{3, "Matt Doe", TestAddFilesProcedure.toDate("2021-01-02"), "02"}), (Object)RowFactory.create((Object[])new Object[]{4, "Will Doe", TestAddFilesProcedure.toDate("2021-01-02"), "02"})), new StructType(dateStruct)).repartition(2);
    }

    private void createUnpartitionedFileTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        Dataset<Row> df = this.unpartitionedDF();
        df.write().insertInto("source_table");
        df.write().insertInto("source_table");
    }

    private void createPartitionedFileTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s PARTITIONED BY (id) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        Dataset<Row> df = this.partitionedDF();
        df.write().insertInto("source_table");
        df.write().insertInto("source_table");
    }

    private void createCompositePartitionedTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s PARTITIONED BY (id, dept) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        Dataset<Row> df = this.compositePartitionedDF();
        df.write().insertInto("source_table");
        df.write().insertInto("source_table");
    }

    private void createCompositePartitionedTableWithNullValueInPartitionColumn(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s PARTITIONED BY (id, dept) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        Dataset unionedDF = this.compositePartitionedDF().unionAll(this.compositePartitionedNullRecordDF()).select("name", new String[]{"subdept", "id", "dept"}).repartition(1);
        unionedDF.write().insertInto("source_table");
        unionedDF.write().insertInto("source_table");
    }

    private void createWeirdCaseTable() {
        String createParquet = "CREATE TABLE %s (id Integer, subdept String, dept String) PARTITIONED BY (`naMe` String) STORED AS parquet";
        this.sql(createParquet, new Object[]{"source_table"});
        Dataset<Row> df = this.weirdColumnNamesDF();
        df.write().insertInto("source_table");
        df.write().insertInto("source_table");
    }

    private void createUnpartitionedHiveTable() {
        String createHive = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) STORED AS parquet";
        this.sql(createHive, new Object[]{"source_table"});
        Dataset<Row> df = this.unpartitionedDF();
        df.write().insertInto("source_table");
        df.write().insertInto("source_table");
    }

    private void createPartitionedHiveTable() {
        String createHive = "CREATE TABLE %s (name String, dept String, subdept String) PARTITIONED BY (id Integer) STORED AS parquet";
        this.sql(createHive, new Object[]{"source_table"});
        Dataset<Row> df = this.partitionedDF();
        df.write().insertInto("source_table");
        df.write().insertInto("source_table");
    }

    private void createDatePartitionedFileTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, date Date) USING %s PARTITIONED BY (date) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        this.dateDF().select("id", new String[]{"name", "ts"}).write().insertInto("source_table");
    }

    private void createTableWithTwoPartitions(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, date Date, dept String) USING %s PARTITIONED BY (date, dept) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        this.dateDF().write().insertInto("source_table");
    }

    private void createIcebergTable(String schema) {
        this.createIcebergTable(schema, "");
    }

    private void createIcebergTable(String schema, String partitioning) {
        this.sql("CREATE TABLE %s (%s) USING iceberg %s TBLPROPERTIES ('%s' '%d')", new Object[]{this.tableName, schema, partitioning, "format-version", this.formatVersion});
    }

    private void assertOutput(List<Object[]> result, long expectedAddedFilesCount, long expectedChangedPartitionCount) {
        Object[] output = (Object[])Iterables.getOnlyElement(result);
        Assertions.assertThat((Object)output[0]).isEqualTo((Object)expectedAddedFilesCount);
        if (this.formatVersion == 1) {
            Assertions.assertThat((Object)output[1]).isEqualTo((Object)expectedChangedPartitionCount);
        } else {
            Assertions.assertThat((Object)output[1]).isIn(new Object[]{expectedChangedPartitionCount, null});
        }
    }
}

