/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestAlterTablePartitionFields
extends ExtensionsTestBase {
    @Parameter(index=3)
    private int formatVersion;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, formatVersion = {3}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties(), 1}, {SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties(), 2}};
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testAddIdentityPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD category", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).identity("category").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddBucketPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).bucket("id", 16, "id_bucket_16").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddTruncatePartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD truncate(data, 4)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).truncate("data", 4, "data_trunc_4").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddYearsPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD years(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).year("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddMonthsPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD months(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).month("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddDaysPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddHoursPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD hours(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).hour("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddYearPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD year(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).year("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddMonthPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD month(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).month("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddDayPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD day(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddHourPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD hour(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).hour("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAddNamedPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id) AS shard", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).bucket("id", 16, "shard").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testDropIdentityPartition() {
        this.createTable("id bigint NOT NULL, category string, data string", "category");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Table should start with 1 partition field", new Object[0])).hasSize(1);
        this.sql("ALTER TABLE %s DROP PARTITION FIELD category", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).alwaysNull("category", "category").build();
            ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("New spec must be unpartitioned", new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testDropDaysPartition() {
        this.createTable("id bigint NOT NULL, ts timestamp, data string", "days(ts)");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Table should start with 1 partition field", new Object[0])).hasSize(1);
        this.sql("ALTER TABLE %s DROP PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).alwaysNull("ts", "ts_day").build();
            ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("New spec must be unpartitioned", new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testDropBucketPartition() {
        this.createTable("id bigint NOT NULL, data string", "bucket(16, id)");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Table should start with 1 partition field", new Object[0])).hasSize(1);
        this.sql("ALTER TABLE %s DROP PARTITION FIELD bucket(16, id)", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).alwaysNull("id", "id_bucket").build();
            ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("New spec must be unpartitioned", new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testDropPartitionByName() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id) AS shard", new Object[]{this.tableName});
        table.refresh();
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Table should have 1 partition field", new Object[0])).hasSize(1);
        this.sql("ALTER TABLE %s DROP  PARTITION \n FIELD shard", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("id", "shard").build();
            ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("New spec must be unpartitioned", new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testReplacePartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD days(ts) WITH hours(ts)", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "ts_day").hour("ts").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "ts_hour").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should changed from daily to hourly partitioned field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testReplacePartitionAndRename() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD days(ts) WITH hours(ts) AS hour_col", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "ts_day").hour("ts", "hour_col").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "hour_col").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should changed from daily to hourly partitioned field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testReplaceNamedPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts) AS day_col", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts", "day_col").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_col WITH hours(ts)", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "day_col").hour("ts").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "ts_hour").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should changed from daily to hourly partitioned field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testReplaceNamedPartitionAndRenameDifferently() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts) AS day_col", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts", "day_col").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_col WITH hours(ts) AS hour_col", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "day_col").hour("ts", "hour_col").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "hour_col").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should changed from daily to hourly partitioned field", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSparkTableAddDropPartitions() throws Exception {
        this.createTable("id bigint NOT NULL, ts timestamp, data string");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.sparkTable().partitioning()).as("spark table partition should be empty", new Object[0])).hasSize(0);
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id) AS shard", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 1, "bucket(16, id)");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD truncate(data, 4)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 2, "truncate(4, data)");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD years(ts)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 3, "years(ts)");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD years(ts)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 2, "truncate(4, data)");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD truncate(4, data)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 1, "bucket(16, id)");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD shard", new Object[]{this.tableName});
        this.sql("DESCRIBE %s", new Object[]{this.tableName});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.sparkTable().partitioning()).as("spark table partition should be empty", new Object[0])).hasSize(0);
    }

    @TestTemplate
    public void testDropColumnOfOldPartitionFieldV1() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, ts timestamp, day_of_ts date) USING iceberg PARTITIONED BY (day_of_ts) TBLPROPERTIES('format-version' = '1')", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_of_ts WITH days(ts)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s DROP COLUMN day_of_ts", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testDropColumnOfOldPartitionFieldV2() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, ts timestamp, day_of_ts date) USING iceberg PARTITIONED BY (day_of_ts) TBLPROPERTIES('format-version' = '2')", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_of_ts WITH days(ts)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s DROP COLUMN day_of_ts", new Object[]{this.tableName});
    }

    private void assertPartitioningEquals(SparkTable table, int len, String transform) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])table.partitioning()).as("spark table partition should be " + len, new Object[0])).hasSize(len);
        ((AbstractStringAssert)Assertions.assertThat((String)table.partitioning()[len - 1].toString()).as("latest spark table partition transform should match", new Object[0])).isEqualTo(transform);
    }

    private SparkTable sparkTable() throws Exception {
        this.validationCatalog.loadTable(this.tableIdent).refresh();
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        TableCatalog catalog = (TableCatalog)catalogManager.catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        return (SparkTable)catalog.loadTable(identifier);
    }

    private void createTable(String schema) {
        this.createTable(schema, null);
    }

    private void createTable(String schema, String spec) {
        if (spec == null) {
            this.sql("CREATE TABLE %s (%s) USING iceberg TBLPROPERTIES ('%s' '%d')", new Object[]{this.tableName, schema, "format-version", this.formatVersion});
        } else {
            this.sql("CREATE TABLE %s (%s) USING iceberg PARTITIONED BY (%s) TBLPROPERTIES ('%s' '%d')", new Object[]{this.tableName, schema, spec, "format-version", this.formatVersion});
        }
    }
}

