/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Collection;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestAlterTableSchema
extends ExtensionsTestBase {
    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testSetIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, location struct<lon:bigint NOT NULL,lat:bigint NOT NULL> NOT NULL) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Table should start without identifier", new Object[0])).isEmpty();
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have new identifier field", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId()}));
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have new identifier field", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("location.lon").fieldId()}));
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS location.lon", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have new identifier field", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("location.lon").fieldId()}));
    }

    @TestTemplate
    public void testSetInvalidIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, id2 bigint) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Table should start without identifier", new Object[0])).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS unknown", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("not found in current schema or added columns");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id2", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("not a required field");
    }

    @TestTemplate
    public void testDropIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, location struct<lon:bigint NOT NULL,lat:bigint NOT NULL> NOT NULL) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Table should start without identifier", new Object[0])).isEmpty();
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have new identifier fields", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("location.lon").fieldId()}));
        this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS id", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should removed identifier field", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("location.lon").fieldId()}));
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have new identifier fields", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("location.lon").fieldId()}));
        this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have no identifier field", new Object[0])).isEqualTo((Object)Sets.newHashSet());
    }

    @TestTemplate
    public void testDropInvalidIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string NOT NULL, location struct<lon:bigint NOT NULL,lat:bigint NOT NULL> NOT NULL) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Table should start without identifier", new Object[0])).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS unknown", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot complete drop identifier fields operation: field unknown not found");
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS data", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot complete drop identifier fields operation: data is not an identifier field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS location.lon", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot complete drop identifier fields operation: location.lon is not an identifier field");
    }
}

