/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestCherrypickSnapshotProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testCherrypickSnapshotUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.conf().set("spark.wap.id", "1");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        List output = this.sql("CALL %s.system.cherrypick_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, wapSnapshot.snapshotId()});
        table.refresh();
        Snapshot currentSnapshot = table.currentSnapshot();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{wapSnapshot.snapshotId(), currentSnapshot.snapshotId()})), output);
        this.assertEquals("Cherrypick must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testCherrypickSnapshotUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.conf().set("spark.wap.id", "1");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        List output = this.sql("CALL %s.system.cherrypick_snapshot(snapshot_id => %dL, table => '%s')", new Object[]{this.catalogName, wapSnapshot.snapshotId(), this.tableIdent});
        table.refresh();
        Snapshot currentSnapshot = table.currentSnapshot();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{wapSnapshot.snapshotId(), currentSnapshot.snapshotId()})), output);
        this.assertEquals("Cherrypick must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testCherrypickSnapshotRefreshesRelationCache() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should not produce rows", (List)ImmutableList.of(), this.sql("SELECT * FROM tmp", new Object[0]));
        spark.conf().set("spark.wap.id", "1");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        this.sql("CALL %s.system.cherrypick_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, wapSnapshot.snapshotId()});
        this.assertEquals("Cherrypick snapshot should be visible", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("UNCACHE TABLE tmp", new Object[0]);
    }

    @TestTemplate
    public void testCherrypickInvalidSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.cherrypick_snapshot('%s', -1L)", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(ValidationException.class)).hasMessage("Cannot cherry-pick unknown snapshot ID: -1");
    }

    @TestTemplate
    public void testInvalidCherrypickSnapshotCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.cherrypick_snapshot('n', table => 't', 1L)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.cherrypick_snapshot('n', 't', 1L)", new Object[]{this.catalogName})).isInstanceOf(NoSuchProcedureException.class)).hasMessage("Procedure custom.cherrypick_snapshot not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.cherrypick_snapshot('t')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [snapshot_id]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.cherrypick_snapshot('', 1L)", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.cherrypick_snapshot('t', 2.2)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Wrong arg type for snapshot_id: cannot cast");
    }
}

