/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestConflictValidation
extends ExtensionsTestBase {
    @BeforeEach
    public void createTables() {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg PARTITIONED BY (id)TBLPROPERTIES('format-version'='2','write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", new Object[]{this.tableName});
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testOverwriteFilterSerializableIsolation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1))).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found conflicting files that can contain records matching ref(name=\"id\") == 1:");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @TestTemplate
    public void testOverwriteFilterSerializableIsolation2() throws Exception {
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1' and data='b'", new Object[]{this.tableName});
        table.refresh();
        ArrayList conflictingRecords = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        Dataset conflictingDf = spark.createDataFrame((List)conflictingRecords, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1))).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found new conflicting delete files that can apply to records matching ref(name=\"id\") == 1:");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @TestTemplate
    public void testOverwriteFilterSerializableIsolation3() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1'", new Object[]{this.tableName});
        table.refresh();
        ArrayList conflictingRecords = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        Dataset conflictingDf = spark.createDataFrame((List)conflictingRecords, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1))).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found conflicting deleted files that can contain records matching ref(name=\"id\") == 1:");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @TestTemplate
    public void testOverwriteFilterNoSnapshotIdValidation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1))).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found conflicting files that can contain records matching ref(name=\"id\") == 1:");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @TestTemplate
    public void testOverwriteFilterSnapshotIsolation() throws Exception {
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1' and data='b'", new Object[]{this.tableName});
        table.refresh();
        ArrayList conflictingRecords = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        Dataset conflictingDf = spark.createDataFrame((List)conflictingRecords, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1))).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found new conflicting delete files that can apply to records matching ref(name=\"id\") == 1:");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @TestTemplate
    public void testOverwriteFilterSnapshotIsolation2() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @TestTemplate
    public void testOverwritePartitionSerializableIsolation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions()).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found conflicting files that can contain records matching partitions [id=1]");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions();
    }

    @TestTemplate
    public void testOverwritePartitionSnapshotIsolation() throws Exception {
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE data='a'", new Object[]{this.tableName});
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions()).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found new conflicting delete files that can apply to records matching [id=1]");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
    }

    @TestTemplate
    public void testOverwritePartitionSnapshotIsolation2() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1'", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions()).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found conflicting deleted files that can apply to records matching [id=1]");
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
    }

    @TestTemplate
    public void testOverwritePartitionSnapshotIsolation3() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
    }

    @TestTemplate
    public void testOverwritePartitionNoSnapshotIdValidation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> conflictingDf.writeTo(this.tableName).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions()).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Found conflicting files that can contain records matching partitions [id=1]");
        table.refresh();
        long snapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions();
    }
}

