/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.extensions.TestUpdate;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.TestTemplate;

public class TestCopyOnWriteUpdate
extends TestUpdate {
    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"write.update.mode", (Object)RowLevelOperationMode.COPY_ON_WRITE.modeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testUpdateWithConcurrentTableRefresh() throws Exception {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"testhive");
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.update.isolation-level", "snapshot"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> updateFuture = executorService.submit(() -> {
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                while (barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                this.sql("UPDATE %s SET id = -1 WHERE id = 1", new Object[]{this.commitTarget()});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            GenericRecord record = GenericRecord.create((Schema)SnapshotUtil.schemaFor((Table)table, (String)this.branch));
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                while (shouldAppend.get() && barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                    this.sleep(10L);
                }
                barrier.incrementAndGet();
            }
        });
        try {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(updateFuture::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(IllegalStateException.class)).hasMessageContaining("the table has been concurrently modified");
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testRuntimeFilteringWithReportedPartitioning() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hardware\" }\n{ \"id\": 2, \"dep\": \"hardware\" }");
        ImmutableMap sqlConf = ImmutableMap.of((Object)SQLConf.V2_BUCKETING_ENABLED().key(), (Object)"true", (Object)"spark.sql.iceberg.planning.preserve-data-grouping", (Object)"true");
        this.withSQLConf((Map)sqlConf, () -> this.sql("UPDATE %s SET id = -1 WHERE id = 2", new Object[]{this.commitTarget()}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
    }
}

