/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.spark.extensions.SparkRowLevelOperationsTestBase;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.SparkException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;

public abstract class TestMerge
extends SparkRowLevelOperationsTestBase {
    @BeforeAll
    public static void setupSparkConf() {
        spark.conf().set("spark.sql.shuffle.partitions", "4");
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS source", new Object[0]);
    }

    @TestTemplate
    public void testMergeWithAllClauses() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 2, \"dep\": \"emp-id-two\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }\n{ \"id\": 4, \"dep\": \"emp-id-4\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 5, \"dep\": \"emp-id-5\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 2 THEN   DELETE WHEN NOT MATCHED THEN   INSERT * WHEN NOT MATCHED BY SOURCE AND t.id = 3 THEN   UPDATE SET dep = 'invalid' WHEN NOT MATCHED BY SOURCE AND t.id = 4 THEN   DELETE ", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{3, "invalid"}), (Object)this.row(new Object[]{5, "emp-id-5"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOneNotMatchedBySourceClause() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }\n{ \"id\": 4, \"dep\": \"emp-id-4\" }");
        this.createOrReplaceView("source", ImmutableList.of((Object)1, (Object)4), Encoders.INT());
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value WHEN NOT MATCHED BY SOURCE THEN   DELETE ", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{4, "emp-id-4"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeNotMatchedBySourceClausesPartitionedTable() {
        this.createAndInitTable("id INT, dep STRING", "PARTITIONED BY (dep)", "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"support\" }");
        this.createOrReplaceView("source", ImmutableList.of((Object)1, (Object)2), Encoders.INT());
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value AND t.dep = 'hr' WHEN MATCHED THEN  UPDATE SET dep = 'support' WHEN NOT MATCHED BY SOURCE THEN   UPDATE SET dep = 'invalid' ", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "support"}), (Object)this.row(new Object[]{2, "support"}), (Object)this.row(new Object[]{3, "invalid"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithVectorizedReads() {
        Assumptions.assumeThat((boolean)this.supportsVectorization()).isTrue();
        this.createAndInitTable("id INT, value INT, dep STRING", "PARTITIONED BY (dep)", "{ \"id\": 1, \"value\": 100, \"dep\": \"hr\" }\n{ \"id\": 6, \"value\": 600, \"dep\": \"software\" }");
        this.createOrReplaceView("source", "id INT, value INT", "{ \"id\": 2, \"value\": 201 }\n{ \"id\": 1, \"value\": 101 }\n{ \"id\": 6, \"value\": 601 }");
        SparkPlan plan = this.executeAndKeepPlan("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET t.value = s.value WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT (id, value, dep) VALUES (s.id, s.value, 'invalid')", new Object[]{this.commitTarget()});
        this.assertAllBatchScansVectorized(plan);
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, 101, "hr"}), (Object)this.row(new Object[]{2, 201, "invalid"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testCoalesceMerge() {
        this.createAndInitTable("id INT, salary INT, dep STRING");
        String[] records = new String[100];
        for (int index = 0; index < 100; ++index) {
            records[index] = String.format("{ \"id\": %d, \"salary\": 100, \"dep\": \"hr\" }", index);
        }
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        ImmutableMap tableProps = ImmutableMap.of((Object)"read.split.open-file-cost", (Object)String.valueOf(Integer.MAX_VALUE), (Object)"write.merge.distribution-mode", (Object)DistributionMode.NONE.modeName());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)tableProps)});
        this.createBranchIfNeeded();
        spark.range(0L, 100L).createOrReplaceTempView("source");
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"200", (Object)SQLConf.AUTO_BROADCASTJOIN_THRESHOLD().key(), (Object)"-1", (Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"true", (Object)SQLConf.COALESCE_PARTITIONS_ENABLED().key(), (Object)"true", (Object)SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), (Object)"100", (Object)"spark.sql.iceberg.advisory-partition-size", (Object)String.valueOf(0x10000000)), () -> this.sql("MERGE INTO %s t USING source ON t.id = source.id WHEN MATCHED THEN   UPDATE SET salary = -1 ", new Object[]{this.commitTarget()}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateProperty(currentSnapshot, "added-data-files", "1");
        } else {
            this.validateProperty(currentSnapshot, "added-delete-files", "1");
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT COUNT(*) FROM %s WHERE salary = -1", new Object[]{this.commitTarget()})).as("Row count must match", new Object[0])).isEqualTo((Object)400L);
    }

    @TestTemplate
    public void testSkewMerge() {
        this.createAndInitTable("id INT, salary INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        String[] records = new String[100];
        for (int index = 0; index < 100; ++index) {
            records[index] = String.format("{ \"id\": %d, \"salary\": 100, \"dep\": \"hr\" }", index);
        }
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        ImmutableMap tableProps = ImmutableMap.of((Object)"read.split.open-file-cost", (Object)String.valueOf(Integer.MAX_VALUE), (Object)"write.merge.distribution-mode", (Object)DistributionMode.HASH.modeName());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)tableProps)});
        this.createBranchIfNeeded();
        spark.range(0L, 100L).createOrReplaceTempView("source");
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"4", (Object)SQLConf.COALESCE_PARTITIONS_MIN_PARTITION_SIZE().key(), (Object)"100", (Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"true", (Object)SQLConf.ADAPTIVE_OPTIMIZE_SKEWS_IN_REBALANCE_PARTITIONS_ENABLED().key(), (Object)"true", (Object)SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), (Object)"256MB", (Object)"spark.sql.iceberg.advisory-partition-size", (Object)"100"), () -> {
            SparkPlan plan = this.executeAndKeepPlan("MERGE INTO %s t USING source ON t.id = source.id WHEN MATCHED THEN   UPDATE SET salary = -1 ", new Object[]{this.commitTarget()});
            Assertions.assertThat((String)plan.toString()).contains(new CharSequence[]{"REBALANCE_PARTITIONS_BY_COL"});
        });
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateProperty(currentSnapshot, "added-data-files", "4");
        } else {
            this.validateProperty(currentSnapshot, "added-delete-files", "4");
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT COUNT(*) FROM %s WHERE salary = -1", new Object[]{this.commitTarget()})).as("Row count must match", new Object[0])).isEqualTo((Object)400L);
    }

    @TestTemplate
    public void testMergeConditionSplitIntoTargetPredicateAndJoinCondition() {
        this.createAndInitTable("id INT, salary INT, dep STRING, sub_dep STRING", "PARTITIONED BY (dep, sub_dep)", "{ \"id\": 1, \"salary\": 100, \"dep\": \"d1\", \"sub_dep\": \"sd1\" }\n{ \"id\": 6, \"salary\": 600, \"dep\": \"d6\", \"sub_dep\": \"sd6\" }");
        this.createOrReplaceView("source", "id INT, salary INT, dep STRING, sub_dep STRING", "{ \"id\": 1, \"salary\": 101, \"dep\": \"d1\", \"sub_dep\": \"sd1\" }\n{ \"id\": 2, \"salary\": 200, \"dep\": \"d2\", \"sub_dep\": \"sd2\" }\n{ \"id\": 3, \"salary\": 300, \"dep\": \"d3\", \"sub_dep\": \"sd3\"  }");
        String query = String.format("MERGE INTO %s AS t USING source AS s ON t.id == s.id AND ((t.dep = 'd1' AND t.sub_dep IN ('sd1', 'sd3')) OR (t.dep = 'd6' AND t.sub_dep IN ('sd2', 'sd6'))) WHEN MATCHED THEN   UPDATE SET salary = s.salary WHEN NOT MATCHED THEN   INSERT *", this.commitTarget());
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.checkJoinAndFilterConditions(query, "Join [id], [id], FullOuter", "((dep = 'd1' AND sub_dep IN ('sd1', 'sd3')) OR (dep = 'd6' AND sub_dep IN ('sd2', 'sd6')))");
        } else {
            this.checkJoinAndFilterConditions(query, "Join [id], [id], RightOuter", "((dep = 'd1' AND sub_dep IN ('sd1', 'sd3')) OR (dep = 'd6' AND sub_dep IN ('sd2', 'sd6')))");
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, 101, "d1", "sd1"}), (Object)this.row(new Object[]{2, 200, "d2", "sd2"}), (Object)this.row(new Object[]{3, 300, "d3", "sd3"}), (Object)this.row(new Object[]{6, 600, "d6", "sd6"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithStaticPredicatePushDown() {
        this.createAndInitTable("id BIGINT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"software\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hr\" }");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String dataFilesCount = (String)snapshot.summary().get("total-data-files");
        ((AbstractStringAssert)Assertions.assertThat((String)dataFilesCount).as("Must have 2 files before MERGE", new Object[0])).isEqualTo("2");
        this.createOrReplaceView("source", "{ \"id\": 1, \"dep\": \"finance\" }\n{ \"id\": 2, \"dep\": \"hardware\" }");
        this.withUnavailableFiles(snapshot.addedDataFiles(table.io()), () -> this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.DYNAMIC_PARTITION_PRUNING_ENABLED().key(), (Object)"false", (Object)SQLConf.RUNTIME_ROW_LEVEL_OPERATION_GROUP_FILTER_ENABLED().key(), (Object)"false"), () -> this.sql("MERGE INTO %s t USING source ON t.id == source.id AND t.dep IN ('software') AND source.id < 10 WHEN MATCHED AND source.id = 1 THEN   UPDATE SET dep = source.dep WHEN NOT MATCHED THEN   INSERT (dep, id) VALUES (source.dep, source.id)", new Object[]{this.commitTarget()})));
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1L, "finance"}), (Object)this.row(new Object[]{1L, "hr"}), (Object)this.row(new Object[]{2L, "hardware"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeIntoEmptyTargetInsertAllNonMatchingRows() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Custom branch does not exist for empty table", new Object[0])).isNotEqualTo((Object)"test");
        this.createAndInitTable("id INT, dep STRING");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN NOT MATCHED THEN   INSERT *", new Object[]{this.tableName});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}), (Object)this.row(new Object[]{3, "emp-id-3"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeIntoEmptyTargetInsertOnlyMatchingRows() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Custom branch does not exist for empty table", new Object[0])).isNotEqualTo((Object)"test");
        this.createAndInitTable("id INT, dep STRING");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN NOT MATCHED AND (s.id >=2) THEN   INSERT *", new Object[]{this.tableName});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{2, "emp-id-2"}), (Object)this.row(new Object[]{3, "emp-id-3"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOnlyUpdateClause() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-six\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{6, "emp-id-six"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOnlyUpdateNullUnmatchedValues() {
        this.createAndInitTable("id INT, value INT", "{ \"id\": 1, \"value\": 2 }\n{ \"id\": 6, \"value\": null }");
        this.createOrReplaceView("source", "id INT NOT NULL, value INT", "{ \"id\": 1, \"value\": 100 }\n");
        this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN MATCHED THEN   UPDATE SET id=123, value=456", new Object[]{this.commitTarget()});
        this.sql("SELECT * FROM %s", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{6, null}), (Object)this.row(new Object[]{123, 456}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOnlyUpdateSingleFieldNullUnmatchedValues() {
        this.createAndInitTable("id INT, value INT", "{ \"id\": 1, \"value\": 2 }\n{ \"id\": 6, \"value\": null }");
        this.createOrReplaceView("source", "id INT NOT NULL, value INT", "{ \"id\": 1, \"value\": 100 }\n");
        this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN MATCHED THEN   UPDATE SET id=123", new Object[]{this.commitTarget()});
        this.sql("SELECT * FROM %s", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{6, null}), (Object)this.row(new Object[]{123, 2}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOnlyDeleteNullUnmatchedValues() {
        this.createAndInitTable("id INT, value INT", "{ \"id\": 1, \"value\": 2 }\n{ \"id\": 6, \"value\": null }");
        this.createOrReplaceView("source", "id INT NOT NULL, value INT", "{ \"id\": 1, \"value\": 100 }\n");
        this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN MATCHED THEN DELETE", new Object[]{this.commitTarget()});
        this.sql("SELECT * FROM %s", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{6, null}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOnlyUpdateClauseAndNullValues() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": null, \"dep\": \"emp-id-one\" }\n{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-six\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id AND t.id < 3 WHEN MATCHED THEN   UPDATE SET *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{null, "emp-id-one"}), (Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{6, "emp-id-six"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOnlyDeleteClause() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 6 THEN   DELETE", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMatchedAndNotMatchedClauses() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithAllCausesWithExplicitColumnSpecification() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET t.id = s.id, t.dep = s.dep WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT (t.id, t.dep) VALUES (s.id, s.dep)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithSourceCTE() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-two\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-3\" }\n{ \"id\": 1, \"dep\": \"emp-id-2\" }\n{ \"id\": 5, \"dep\": \"emp-id-6\" }");
        this.sql("WITH cte1 AS (SELECT id + 1 AS id, dep FROM source) MERGE INTO %s AS t USING cte1 AS s ON t.id == s.id WHEN MATCHED AND t.id = 2 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 3 THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{2, "emp-id-2"}), (Object)this.row(new Object[]{3, "emp-id-3"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithSourceFromSetOps() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        String derivedSource = "SELECT * FROM source WHERE id = 2 UNION ALL SELECT * FROM source WHERE id = 1 OR id = 6";
        this.sql("MERGE INTO %s AS t USING (%s) AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget(), derivedSource});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithOneMatchingBranchButMultipleSourceRowsForTargetRow() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"state\": \"on\" }\n{ \"id\": 1, \"state\": \"off\" }\n{ \"id\": 10, \"state\": \"on\" }");
        String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED THEN   INSERT (id, dep) VALUES (s.id, 'unknown')", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}), (Object)this.row(new Object[]{6, "emp-id-6"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleUpdatesForTargetRowSmallTargetLargeSource() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        ArrayList sourceIds = Lists.newArrayList();
        for (int i = 0; i < 10000; ++i) {
            sourceIds.add(i);
        }
        Dataset ds = spark.createDataset((List)sourceIds, Encoders.INT());
        ds.union(ds).createOrReplaceTempView("source");
        String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value WHEN MATCHED AND t.id = 1 THEN   UPDATE SET id = 10 WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.value = 2 THEN   INSERT (id, dep) VALUES (s.value, null)", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}), (Object)this.row(new Object[]{6, "emp-id-6"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleUpdatesForTargetRowSmallTargetLargeSourceEnabledHashShuffleJoin() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        ArrayList sourceIds = Lists.newArrayList();
        for (int i = 0; i < 10000; ++i) {
            sourceIds.add(i);
        }
        Dataset ds = spark.createDataset((List)sourceIds, Encoders.INT());
        ds.union(ds).createOrReplaceTempView("source");
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.PREFER_SORTMERGEJOIN().key(), (Object)"false"), () -> {
            String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value WHEN MATCHED AND t.id = 1 THEN   UPDATE SET id = 10 WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.value = 2 THEN   INSERT (id, dep) VALUES (s.value, null)", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        });
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}), (Object)this.row(new Object[]{6, "emp-id-6"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleUpdatesForTargetRowSmallTargetLargeSourceNoEqualityCondition() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }");
        ArrayList sourceIds = Lists.newArrayList();
        for (int i = 0; i < 10000; ++i) {
            sourceIds.add(i);
        }
        Dataset ds = spark.createDataset((List)sourceIds, Encoders.INT());
        ds.union(ds).createOrReplaceTempView("source");
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.PREFER_SORTMERGEJOIN().key(), (Object)"false"), () -> {
            String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id > s.value WHEN MATCHED AND t.id = 1 THEN   UPDATE SET id = 10 WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.value = 2 THEN   INSERT (id, dep) VALUES (s.value, null)", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        });
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleUpdatesForTargetRowSmallTargetLargeSourceNoNotMatchedActions() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        ArrayList sourceIds = Lists.newArrayList();
        for (int i = 0; i < 10000; ++i) {
            sourceIds.add(i);
        }
        Dataset ds = spark.createDataset((List)sourceIds, Encoders.INT());
        ds.union(ds).createOrReplaceTempView("source");
        String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value WHEN MATCHED AND t.id = 1 THEN   UPDATE SET id = 10 WHEN MATCHED AND t.id = 6 THEN   DELETE", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}), (Object)this.row(new Object[]{6, "emp-id-6"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleUpdatesForTargetRowSmallTargetLargeSourceNoNotMatchedActionsNoEqualityCondition() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }");
        ArrayList sourceIds = Lists.newArrayList();
        for (int i = 0; i < 10000; ++i) {
            sourceIds.add(i);
        }
        Dataset ds = spark.createDataset((List)sourceIds, Encoders.INT());
        ds.union(ds).createOrReplaceTempView("source");
        String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id > s.value WHEN MATCHED AND t.id = 1 THEN   UPDATE SET id = 10 WHEN MATCHED AND t.id = 6 THEN   DELETE", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleUpdatesForTargetRow() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}), (Object)this.row(new Object[]{6, "emp-id-6"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithUnconditionalDelete() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{2, "emp-id-2"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithSingleConditionalDelete() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        String errorMsg = "MERGE statement matched a single row from the target table with multiple rows of the source table.";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()})).cause().isInstanceOf(SparkRuntimeException.class)).hasMessageContaining(errorMsg);
        this.assertEquals("Target should be unchanged", (List)ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-one"}), (Object)this.row(new Object[]{6, "emp-id-6"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithIdentityTransform() {
        for (DistributionMode mode : DistributionMode.values()) {
            this.createAndInitTable("id INT, dep STRING");
            this.sql("ALTER TABLE %s ADD PARTITION FIELD identity(dep)", new Object[]{this.tableName});
            this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", mode.modeName()});
            this.append(this.tableName, "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.createBranchIfNeeded();
            this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
            ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
            this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
            this.removeTables();
        }
    }

    @TestTemplate
    public void testMergeWithDaysTransform() {
        for (DistributionMode mode : DistributionMode.values()) {
            this.createAndInitTable("id INT, ts TIMESTAMP");
            this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
            this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", mode.modeName()});
            this.append(this.tableName, "id INT, ts TIMESTAMP", "{ \"id\": 1, \"ts\": \"2000-01-01 00:00:00\" }\n{ \"id\": 6, \"ts\": \"2000-01-06 00:00:00\" }");
            this.createBranchIfNeeded();
            this.createOrReplaceView("source", "id INT, ts TIMESTAMP", "{ \"id\": 2, \"ts\": \"2001-01-02 00:00:00\" }\n{ \"id\": 1, \"ts\": \"2001-01-01 00:00:00\" }\n{ \"id\": 6, \"ts\": \"2001-01-06 00:00:00\" }");
            this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
            ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "2001-01-01 00:00:00"}), (Object)this.row(new Object[]{2, "2001-01-02 00:00:00"}));
            this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT id, CAST(ts AS STRING) FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
            this.removeTables();
        }
    }

    @TestTemplate
    public void testMergeWithBucketTransform() {
        for (DistributionMode mode : DistributionMode.values()) {
            this.createAndInitTable("id INT, dep STRING");
            this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(2, dep)", new Object[]{this.tableName});
            this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", mode.modeName()});
            this.append(this.tableName, "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.createBranchIfNeeded();
            this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
            ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
            this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
            this.removeTables();
        }
    }

    @TestTemplate
    public void testMergeWithTruncateTransform() {
        for (DistributionMode mode : DistributionMode.values()) {
            this.createAndInitTable("id INT, dep STRING");
            this.sql("ALTER TABLE %s ADD PARTITION FIELD truncate(dep, 2)", new Object[]{this.tableName});
            this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", mode.modeName()});
            this.append(this.tableName, "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.createBranchIfNeeded();
            this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
            ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
            this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
            this.removeTables();
        }
    }

    @TestTemplate
    public void testMergeIntoPartitionedAndOrderedTable() {
        for (DistributionMode mode : DistributionMode.values()) {
            this.createAndInitTable("id INT, dep STRING");
            this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
            this.sql("ALTER TABLE %s WRITE ORDERED BY (id)", new Object[]{this.tableName});
            this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", mode.modeName()});
            this.append(this.tableName, "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.createBranchIfNeeded();
            this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
            this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
            ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
            this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
            this.removeTables();
        }
    }

    @TestTemplate
    public void testSelfMerge() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": 1, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.sql("MERGE INTO %s t USING %s s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET v = 'x' WHEN NOT MATCHED THEN   INSERT *", new Object[]{this.commitTarget(), this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "x"}), (Object)this.row(new Object[]{2, "v2"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testSelfMergeWithCaching() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": 1, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.sql("CACHE TABLE %s", new Object[]{this.tableName});
        this.sql("MERGE INTO %s t USING %s s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET v = 'x' WHEN NOT MATCHED THEN   INSERT *", new Object[]{this.commitTarget(), this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "x"}), (Object)this.row(new Object[]{2, "v2"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.commitTarget()}));
    }

    @TestTemplate
    public void testMergeWithSourceAsSelfSubquery() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": 1, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", Arrays.asList(1, null), Encoders.INT());
        this.sql("MERGE INTO %s t USING (SELECT id AS value FROM %s r JOIN source ON r.id = source.value) s ON t.id == s.value WHEN MATCHED AND t.id = 1 THEN   UPDATE SET v = 'x' WHEN NOT MATCHED THEN   INSERT (v, id) VALUES ('invalid', -1) ", new Object[]{this.commitTarget(), this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "x"}), (Object)this.row(new Object[]{2, "v2"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testMergeWithSerializableIsolation() throws InterruptedException {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualToIgnoringCase((CharSequence)"testhadoop");
        Assumptions.assumeThat((boolean)this.cachingCatalogEnabled()).isTrue();
        this.createAndInitTable("id INT, dep STRING");
        this.createOrReplaceView("source", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.merge.isolation-level", "serializable"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> mergeFuture = executorService.submit(() -> {
            int numOperations = 0;
            while (numOperations < Integer.MAX_VALUE) {
                int currentNumOperations = numOperations++;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> barrier.get() >= currentNumOperations * 2);
                this.sql("MERGE INTO %s t USING source s ON t.id == s.value WHEN MATCHED THEN   UPDATE SET dep = 'x'", new Object[]{this.commitTarget()});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)table.schema());
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                int currentNumOperations = numOperations;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> !shouldAppend.get() || barrier.get() >= currentNumOperations * 2);
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                }
                barrier.incrementAndGet();
            }
        });
        try {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(mergeFuture::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(ValidationException.class)).hasMessageContaining("Found conflicting files that can contain");
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testMergeWithSnapshotIsolation() throws InterruptedException, ExecutionException {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualToIgnoringCase((CharSequence)"testhadoop");
        Assumptions.assumeThat((boolean)this.cachingCatalogEnabled()).isTrue();
        this.createAndInitTable("id INT, dep STRING");
        this.createOrReplaceView("source", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.merge.isolation-level", "snapshot"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> mergeFuture = executorService.submit(() -> {
            int numOperations = 0;
            while (numOperations < 20) {
                int currentNumOperations = numOperations++;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> barrier.get() >= currentNumOperations * 2);
                this.sql("MERGE INTO %s t USING source s ON t.id == s.value WHEN MATCHED THEN   UPDATE SET dep = 'x'", new Object[]{this.commitTarget()});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)table.schema());
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < 20; ++numOperations) {
                int currentNumOperations = numOperations;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> !shouldAppend.get() || barrier.get() >= currentNumOperations * 2);
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                }
                barrier.incrementAndGet();
            }
        });
        try {
            mergeFuture.get();
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testMergeWithExtraColumnsInSource() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": 1, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"extra_col\": -1, \"v\": \"v1_1\" }\n{ \"id\": 3, \"extra_col\": -1, \"v\": \"v3\" }\n{ \"id\": 4, \"extra_col\": -1, \"v\": \"v4\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET v = source.v WHEN NOT MATCHED THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "v1_1"}), (Object)this.row(new Object[]{2, "v2"}), (Object)this.row(new Object[]{3, "v3"}), (Object)this.row(new Object[]{4, "v4"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithNullsInTargetAndSource() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": null, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": null, \"v\": \"v1_1\" }\n{ \"id\": 4, \"v\": \"v4\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET v = source.v WHEN NOT MATCHED THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{null, "v1"}), (Object)this.row(new Object[]{null, "v1_1"}), (Object)this.row(new Object[]{2, "v2"}), (Object)this.row(new Object[]{4, "v4"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY v", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithNullSafeEquals() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": null, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": null, \"v\": \"v1_1\" }\n{ \"id\": 4, \"v\": \"v4\" }");
        this.sql("MERGE INTO %s t USING source ON t.id <=> source.id WHEN MATCHED THEN   UPDATE SET v = source.v WHEN NOT MATCHED THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{null, "v1_1"}), (Object)this.row(new Object[]{2, "v2"}), (Object)this.row(new Object[]{4, "v4"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY v", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithNullCondition() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": null, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": null, \"v\": \"v1_1\" }\n{ \"id\": 2, \"v\": \"v2_2\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id AND NULL WHEN MATCHED THEN   UPDATE SET v = source.v WHEN NOT MATCHED THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{null, "v1"}), (Object)this.row(new Object[]{null, "v1_1"}), (Object)this.row(new Object[]{2, "v2"}), (Object)this.row(new Object[]{2, "v2_2"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY v", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithNullActionConditions() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": 1, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"v\": \"v1_1\" }\n{ \"id\": 2, \"v\": \"v2_2\" }\n{ \"id\": 3, \"v\": \"v3_3\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED AND source.id = 1 AND NULL THEN   UPDATE SET v = source.v WHEN MATCHED AND source.v = 'v1_1' AND NULL THEN   DELETE WHEN NOT MATCHED AND source.id = 3 AND NULL THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows1 = ImmutableList.of((Object)this.row(new Object[]{1, "v1"}), (Object)this.row(new Object[]{2, "v2"}));
        this.assertEquals("Output should match", (List)expectedRows1, this.sql("SELECT * FROM %s ORDER BY v", new Object[]{this.selectTarget()}));
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED AND source.id = 1 AND NULL THEN   UPDATE SET v = source.v WHEN MATCHED AND source.v = 'v1_1' THEN   DELETE WHEN NOT MATCHED AND source.id = 3 AND NULL THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows2 = ImmutableList.of((Object)this.row(new Object[]{2, "v2"}));
        this.assertEquals("Output should match", (List)expectedRows2, this.sql("SELECT * FROM %s ORDER BY v", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleMatchingActions() {
        this.createAndInitTable("id INT, v STRING", "{ \"id\": 1, \"v\": \"v1\" }\n{ \"id\": 2, \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"v\": \"v1_1\" }\n{ \"id\": 2, \"v\": \"v2_2\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED AND source.id = 1 THEN   UPDATE SET v = source.v WHEN MATCHED AND source.v = 'v1_1' THEN   DELETE WHEN NOT MATCHED THEN   INSERT (v, id) VALUES (source.v, source.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "v1_1"}), (Object)this.row(new Object[]{2, "v2"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY v", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleRowGroupsParquet() throws NoSuchTableException {
        Assumptions.assumeThat((Comparable)this.fileFormat).isEqualTo((Object)FileFormat.PARQUET);
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "write.parquet.row-group-size-bytes", 100});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "read.split.target-size", 100});
        this.createOrReplaceView("source", Collections.singletonList(1), Encoders.INT());
        ArrayList ids = Lists.newArrayListWithCapacity((int)200);
        for (int id = 1; id <= 200; ++id) {
            ids.add(id);
        }
        Dataset df = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"hr"));
        df.coalesce(1).writeTo(this.tableName).append();
        this.createBranchIfNeeded();
        Assertions.assertThat((long)spark.table(this.commitTarget()).count()).isEqualTo(200L);
        this.sql("MERGE INTO %s t USING source ON t.id == source.value WHEN MATCHED THEN   UPDATE SET dep = 'x'", new Object[]{this.commitTarget()});
        Assertions.assertThat((long)spark.table(this.commitTarget()).count()).isEqualTo(200L);
    }

    @TestTemplate
    public void testMergeInsertOnly() {
        this.createAndInitTable("id STRING, v STRING", "{ \"id\": \"a\", \"v\": \"v1\" }\n{ \"id\": \"b\", \"v\": \"v2\" }");
        this.createOrReplaceView("source", "{ \"id\": \"a\", \"v\": \"v1_1\" }\n{ \"id\": \"a\", \"v\": \"v1_2\" }\n{ \"id\": \"c\", \"v\": \"v3\" }\n{ \"id\": \"d\", \"v\": \"v4_1\" }\n{ \"id\": \"d\", \"v\": \"v4_2\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN NOT MATCHED THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{"a", "v1"}), (Object)this.row(new Object[]{"b", "v2"}), (Object)this.row(new Object[]{"c", "v3"}), (Object)this.row(new Object[]{"d", "v4_1"}), (Object)this.row(new Object[]{"d", "v4_2"}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeInsertOnlyWithCondition() {
        this.createAndInitTable("id INTEGER, v INTEGER", "{ \"id\": 1, \"v\": 1 }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"v\": 11, \"is_new\": true }\n{ \"id\": 2, \"v\": 21, \"is_new\": true }\n{ \"id\": 2, \"v\": 22, \"is_new\": false }");
        this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN NOT MATCHED AND is_new = TRUE THEN   INSERT (v, id) VALUES (s.v + 100, s.id)", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, 1}), (Object)this.row(new Object[]{2, 121}));
        this.assertEquals("Output should match", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeAlignsUpdateAndInsertActions() {
        this.createAndInitTable("id INT, a INT, b STRING", "{ \"id\": 1, \"a\": 2, \"b\": \"str\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"c1\": -2, \"c2\": \"new_str_1\" }\n{ \"id\": 2, \"c1\": -20, \"c2\": \"new_str_2\" }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET b = c2, a = c1, t.id = source.id WHEN NOT MATCHED THEN   INSERT (b, a, id) VALUES (c2, c1, id)", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, -2, "new_str_1"}), (Object)this.row(new Object[]{2, -20, "new_str_2"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeMixedCaseAlignsUpdateAndInsertActions() {
        this.createAndInitTable("id INT, a INT, b STRING", "{ \"id\": 1, \"a\": 2, \"b\": \"str\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"c1\": -2, \"c2\": \"new_str_1\" }\n{ \"id\": 2, \"c1\": -20, \"c2\": \"new_str_2\" }");
        this.sql("MERGE INTO %s t USING source ON t.iD == source.Id WHEN MATCHED THEN   UPDATE SET B = c2, A = c1, t.Id = source.ID WHEN NOT MATCHED THEN   INSERT (b, A, iD) VALUES (c2, c1, id)", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, -2, "new_str_1"}), (Object)this.row(new Object[]{2, -20, "new_str_2"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, -2, "new_str_1"})), this.sql("SELECT * FROM %s WHERE id = 1 ORDER BY id", new Object[]{this.selectTarget()}));
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{2, -20, "new_str_2"})), this.sql("SELECT * FROM %s WHERE b = 'new_str_2'ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeUpdatesNestedStructFields() {
        this.createAndInitTable("id INT, s STRUCT<c1:INT,c2:STRUCT<a:ARRAY<INT>,m:MAP<STRING, STRING>>>", "{ \"id\": 1, \"s\": { \"c1\": 2, \"c2\": { \"a\": [1,2], \"m\": { \"a\": \"b\"} } } } }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"c1\": -2 }");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET t.s.c1 = source.c1, t.s.c2.a = array(-1, -2), t.s.c2.m = map('k', 'v')", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{-2, this.row(new Object[]{ImmutableList.of((Object)-1, (Object)-2), ImmutableMap.of((Object)"k", (Object)"v")})})})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET t.s.c1 = NULL, t.s.c2 = NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{null, null})})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET t.s = named_struct('c1', 100, 'c2', named_struct('a', array(1), 'm', map('x', 'y')))", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{100, this.row(new Object[]{ImmutableList.of((Object)1), ImmutableMap.of((Object)"x", (Object)"y")})})})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithInferredCasts() {
        this.createAndInitTable("id INT, s STRING", "{ \"id\": 1, \"s\": \"value\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"c1\": -2}");
        this.sql("MERGE INTO %s t USING source ON t.id == source.id WHEN MATCHED THEN   UPDATE SET t.s = source.c1", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "-2"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeModifiesNullStruct() {
        this.createAndInitTable("id INT, s STRUCT<n1:INT,n2:INT>", "{ \"id\": 1, \"s\": null }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"n1\": -10 }");
        this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN MATCHED THEN   UPDATE SET t.s.n1 = s.n1", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{-10, null})})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeRefreshesRelationCache() {
        this.createAndInitTable("id INT, name STRING", "{ \"id\": 1, \"name\": \"n1\" }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"name\": \"n2\" }");
        Dataset query = spark.sql("SELECT name FROM " + this.commitTarget());
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have correct data", (List)ImmutableList.of((Object)this.row(new Object[]{"n1"})), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN MATCHED THEN   UPDATE SET t.name = s.name", new Object[]{this.commitTarget()});
        this.assertEquals("View should have correct data", (List)ImmutableList.of((Object)this.row(new Object[]{"n2"})), this.sql("SELECT * FROM tmp", new Object[0]));
        spark.sql("UNCACHE TABLE tmp");
    }

    @TestTemplate
    public void testMergeWithMultipleNotMatchedActions() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 0, \"dep\": \"emp-id-0\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN NOT MATCHED AND s.id = 1 THEN   INSERT (dep, id) VALUES (s.dep, -1)WHEN NOT MATCHED THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{-1, "emp-id-1"}), (Object)this.row(new Object[]{0, "emp-id-0"}), (Object)this.row(new Object[]{2, "emp-id-2"}), (Object)this.row(new Object[]{3, "emp-id-3"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithMultipleConditionalNotMatchedActions() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 0, \"dep\": \"emp-id-0\" }");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN NOT MATCHED AND s.id = 1 THEN   INSERT (dep, id) VALUES (s.dep, -1)WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{-1, "emp-id-1"}), (Object)this.row(new Object[]{0, "emp-id-0"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeResolvesColumnsByName() {
        this.createAndInitTable("id INT, badge INT, dep STRING", "{ \"id\": 1, \"badge\": 1000, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"badge\": 6000, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "badge INT, id INT, dep STRING", "{ \"badge\": 1001, \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"badge\": 6006, \"id\": 6, \"dep\": \"emp-id-6\" }\n{ \"badge\": 7007, \"id\": 7, \"dep\": \"emp-id-7\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED THEN   UPDATE SET * WHEN NOT MATCHED THEN   INSERT * ", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, 1001, "emp-id-1"}), (Object)this.row(new Object[]{6, 6006, "emp-id-6"}), (Object)this.row(new Object[]{7, 7007, "emp-id-7"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT id, badge, dep FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeShouldResolveWhenThereAreNoUnresolvedExpressionsOrColumns() {
        this.createAndInitTable("id INT, dep STRING");
        this.createOrReplaceView("source", "id INT, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 3, \"dep\": \"emp-id-3\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON 1 != 1 WHEN MATCHED THEN   UPDATE SET * WHEN NOT MATCHED THEN   INSERT *", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}), (Object)this.row(new Object[]{3, "emp-id-3"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithTableWithNonNullableColumn() {
        this.createAndInitTable("id INT NOT NULL, dep STRING", "{ \"id\": 1, \"dep\": \"emp-id-one\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.createOrReplaceView("source", "id INT NOT NULL, dep STRING", "{ \"id\": 2, \"dep\": \"emp-id-2\" }\n{ \"id\": 1, \"dep\": \"emp-id-1\" }\n{ \"id\": 6, \"dep\": \"emp-id-6\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.id WHEN MATCHED AND t.id = 1 THEN   UPDATE SET * WHEN MATCHED AND t.id = 6 THEN   DELETE WHEN NOT MATCHED AND s.id = 2 THEN   INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "emp-id-1"}), (Object)this.row(new Object[]{2, "emp-id-2"}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithNonExistingColumns() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>>", "{ \"id\": 1, \"c\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.invalid_col = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("A column or function parameter with name `t`.`invalid_col` cannot be resolved");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.c.n2.invalid_col = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("No such struct field `invalid_col`");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.c.n2.dn1 = s.c2 WHEN NOT MATCHED THEN   INSERT (id, invalid_col) VALUES (s.c1, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("A column or function parameter with name `invalid_col` cannot be resolved");
    }

    @TestTemplate
    public void testMergeWithInvalidColumnsInInsert() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>> NOT NULL", "{ \"id\": 1, \"c\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.c.n2.dn1 = s.c2 WHEN NOT MATCHED THEN   INSERT (id, c.n2) VALUES (s.c1, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("INSERT assignment keys cannot be nested fields");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.c.n2.dn1 = s.c2 WHEN NOT MATCHED THEN   INSERT (id, id) VALUES (s.c1, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Multiple assignments for 'id'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN NOT MATCHED THEN   INSERT (id) VALUES (s.c1)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("No assignment for 'c'");
    }

    @TestTemplate
    public void testMergeWithMissingOptionalColumnsInInsert() {
        this.createAndInitTable("id INT, value LONG", "{ \"id\": 1, \"value\": 100}");
        this.createOrReplaceView("source", "{ \"c1\": 2, \"c2\": 200 }");
        this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN NOT MATCHED THEN   INSERT (id) VALUES (s.c1)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, 100L}), (Object)this.row(new Object[]{2, null})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testMergeWithInvalidUpdates() {
        this.createAndInitTable("id INT, a ARRAY<STRUCT<c1:INT,c2:INT>>, m MAP<STRING,STRING>", "{ \"id\": 1, \"a\": [ { \"c1\": 2, \"c2\": 3 } ], \"m\": { \"k\": \"v\"} }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.a.c1 = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Updating nested fields is only supported for StructType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.m.key = 'new_key'", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Updating nested fields is only supported for StructType");
    }

    @TestTemplate
    public void testMergeWithConflictingUpdates() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>>", "{ \"id\": 1, \"c\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.id = 1, t.c.n1 = 2, t.id = 2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Multiple assignments for 'id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.c.n1 = 1, t.id = 2, t.c.n1 = 2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Multiple assignments for 'c.n1'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET c.n1 = 1, c = named_struct('n1', 1, 'n2', named_struct('dn1', 1, 'dn2', 2))", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Conflicting assignments for 'c'");
    }

    @TestTemplate
    public void testMergeWithInvalidAssignmentsAnsi() {
        this.createAndInitTable("id INT NOT NULL, s STRUCT<n1:INT NOT NULL,n2:STRUCT<dn1:INT,dn2:INT>> NOT NULL", "{ \"id\": 1, \"s\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "c1 INT, c2 STRUCT<n1:INT NOT NULL> NOT NULL, c3 STRING NOT NULL, c4 STRUCT<dn3:INT,dn1:INT>", "{ \"c1\": 1, \"c2\": { \"n1\" : 1 }, \"c3\" : 'str', \"c4\": { \"dn3\": 1, \"dn1\": 2 } }");
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.STORE_ASSIGNMENT_POLICY().key(), (Object)"ansi"), () -> {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.id = cast(NULL as int)", new Object[]{this.commitTarget()})).isInstanceOf(SparkException.class)).hasMessageContaining("Null value appeared in non-nullable field");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s.n1 = NULL", new Object[]{this.commitTarget()})).isInstanceOf(SparkException.class)).hasMessageContaining("Null value appeared in non-nullable field");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column `s`.`n2`");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s.n1 = s.c3", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageEndingWith("Cannot safely cast `s`.`n1` \"STRING\" to \"INT\".");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s.n2 = s.c4", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column `s`.`n2`.`dn2`");
        });
    }

    @TestTemplate
    public void testMergeWithInvalidAssignmentsStrict() {
        this.createAndInitTable("id INT NOT NULL, s STRUCT<n1:INT NOT NULL,n2:STRUCT<dn1:INT,dn2:INT>> NOT NULL", "{ \"id\": 1, \"s\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "c1 INT, c2 STRUCT<n1:INT NOT NULL> NOT NULL, c3 STRING NOT NULL, c4 STRUCT<dn3:INT,dn1:INT>", "{ \"c1\": 1, \"c2\": { \"n1\" : 1 }, \"c3\" : 'str', \"c4\": { \"dn3\": 1, \"dn1\": 2 } }");
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.STORE_ASSIGNMENT_POLICY().key(), (Object)"strict"), () -> {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.id = NULL", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot safely cast `id` \"VOID\" to \"INT\"");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s.n1 = NULL", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot safely cast `s`.`n1` \"VOID\" to \"INT\"");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column `s`.`n2`");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s.n1 = s.c3", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageEndingWith("Cannot safely cast `s`.`n1` \"STRING\" to \"INT\".");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED THEN   UPDATE SET t.s.n2 = s.c4", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column `s`.`n2`.`dn2`");
        });
    }

    @TestTemplate
    public void testMergeWithNonDeterministicConditions() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>>", "{ \"id\": 1, \"c\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 AND rand() > t.id WHEN MATCHED THEN   UPDATE SET t.c.n1 = -1", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported SEARCH condition. Non-deterministic expressions are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED AND rand() > t.id THEN   UPDATE SET t.c.n1 = -1", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported UPDATE condition. Non-deterministic expressions are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED AND rand() > t.id THEN   DELETE", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported DELETE condition. Non-deterministic expressions are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN NOT MATCHED AND rand() > c1 THEN   INSERT (id, c) VALUES (1, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported INSERT condition. Non-deterministic expressions are not allowed");
    }

    @TestTemplate
    public void testMergeWithAggregateExpressions() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>>", "{ \"id\": 1, \"c\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 AND max(t.id) == 1 WHEN MATCHED THEN   UPDATE SET t.c.n1 = -1", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported SEARCH condition. Aggregates are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED AND sum(t.id) < 1 THEN   UPDATE SET t.c.n1 = -1", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported UPDATE condition. Aggregates are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED AND sum(t.id) THEN   DELETE", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported DELETE condition. Aggregates are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN NOT MATCHED AND sum(c1) < 1 THEN   INSERT (id, c) VALUES (1, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported INSERT condition. Aggregates are not allowed");
    }

    @TestTemplate
    public void testMergeWithSubqueriesInConditions() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>>", "{ \"id\": 1, \"c\": { \"n1\": 2, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 AND t.id < (SELECT max(c2) FROM source) WHEN MATCHED THEN   UPDATE SET t.c.n1 = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported SEARCH condition. Subqueries are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED AND t.id < (SELECT max(c2) FROM source) THEN   UPDATE SET t.c.n1 = s.c2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported UPDATE condition. Subqueries are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN MATCHED AND t.id NOT IN (SELECT c2 FROM source) THEN   DELETE", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported DELETE condition. Subqueries are not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.c1 WHEN NOT MATCHED AND s.c1 IN (SELECT c2 FROM source) THEN   INSERT (id, c) VALUES (1, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("MERGE operation contains unsupported INSERT condition. Subqueries are not allowed");
    }

    @TestTemplate
    public void testMergeWithTargetColumnsInInsertConditions() {
        this.createAndInitTable("id INT, c2 INT", "{ \"id\": 1, \"c2\": 2 }");
        this.createOrReplaceView("source", "{ \"id\": 1, \"value\": 11 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id == s.id WHEN NOT MATCHED AND c2 = 1 THEN   INSERT (id, c2) VALUES (s.id, null)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("A column or function parameter with name `c2` cannot be resolved");
    }

    @TestTemplate
    public void testMergeWithNonIcebergTargetTableNotSupported() {
        this.createOrReplaceView("target", "{ \"c1\": -100, \"c2\": -200 }");
        this.createOrReplaceView("source", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO target t USING source s ON t.c1 == s.c1 WHEN MATCHED THEN   UPDATE SET *", new Object[0])).isInstanceOf(UnsupportedOperationException.class)).hasMessage("MERGE INTO TABLE is not supported temporarily.");
    }

    @TestTemplate
    public void testMergeSinglePartitionPartitioning() {
        this.createAndInitTable("id INT", "{\"id\": -1}");
        spark.range(0L, 5L).coalesce(1).createOrReplaceTempView("source");
        this.sql("MERGE INTO %s t USING source s ON t.id = s.id WHEN MATCHED THEN UPDATE SET *WHEN NOT MATCHED THEN INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{-1}), (Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1}), (Object)this.row(new Object[]{2}), (Object)this.row(new Object[]{3}), (Object)this.row(new Object[]{4}));
        List result = this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()});
        this.assertEquals("Should correctly add the non-matching rows", (List)expectedRows, result);
    }

    @TestTemplate
    public void testMergeEmptyTable() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Custom branch does not exist for empty table", new Object[0])).isNotEqualTo((Object)"test");
        this.createAndInitTable("id INT", null);
        spark.range(0L, 5L).coalesce(1).createOrReplaceTempView("source");
        this.sql("MERGE INTO %s t USING source s ON t.id = s.id WHEN MATCHED THEN UPDATE SET *WHEN NOT MATCHED THEN INSERT *", new Object[]{this.commitTarget()});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1}), (Object)this.row(new Object[]{2}), (Object)this.row(new Object[]{3}), (Object)this.row(new Object[]{4}));
        List result = this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()});
        this.assertEquals("Should correctly add the non-matching rows", (List)expectedRows, result);
    }

    @TestTemplate
    public void testMergeNonExistingBranch() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Test only applicable to custom branch", new Object[0])).isEqualTo("test");
        this.createAndInitTable("id INT", null);
        spark.range(0L, 5L).coalesce(1).createOrReplaceTempView("source");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id = s.id WHEN MATCHED THEN UPDATE SET *WHEN NOT MATCHED THEN INSERT *", new Object[]{this.commitTarget()})).isInstanceOf(ValidationException.class)).hasMessage("Cannot use branch (does not exist): test");
    }

    @TestTemplate
    public void testMergeToWapBranch() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("WAP branch only works for table identifier without branch", new Object[0])).isNull();
        this.createAndInitTable("id INT", "{\"id\": -1}");
        ImmutableList originalRows = ImmutableList.of((Object)this.row(new Object[]{-1}));
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.range(0L, 5L).coalesce(1).createOrReplaceTempView("source");
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{-1}), (Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1}), (Object)this.row(new Object[]{2}), (Object)this.row(new Object[]{3}), (Object)this.row(new Object[]{4}));
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> {
            this.sql("MERGE INTO %s t USING source s ON t.id = s.id WHEN MATCHED THEN UPDATE SET *WHEN NOT MATCHED THEN INSERT *", new Object[]{this.tableName});
            this.assertEquals("Should have expected rows when reading table", (List)expectedRows, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
            this.assertEquals("Should have expected rows when reading WAP branch", (List)expectedRows, this.sql("SELECT * FROM %s.branch_wap ORDER BY id", new Object[]{this.tableName}));
            this.assertEquals("Should not modify main branch", (List)originalRows, this.sql("SELECT * FROM %s.branch_main ORDER BY id", new Object[]{this.tableName}));
        });
        spark.range(3L, 6L).coalesce(1).createOrReplaceTempView("source2");
        ImmutableList expectedRows2 = ImmutableList.of((Object)this.row(new Object[]{-1}), (Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1}), (Object)this.row(new Object[]{2}), (Object)this.row(new Object[]{5}));
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> {
            this.sql("MERGE INTO %s t USING source2 s ON t.id = s.id WHEN MATCHED THEN DELETE WHEN NOT MATCHED THEN INSERT *", new Object[]{this.tableName});
            this.assertEquals("Should have expected rows when reading table with multiple writes", (List)expectedRows2, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
            this.assertEquals("Should have expected rows when reading WAP branch with multiple writes", (List)expectedRows2, this.sql("SELECT * FROM %s.branch_wap ORDER BY id", new Object[]{this.tableName}));
            this.assertEquals("Should not modify main branch with multiple writes", (List)originalRows, this.sql("SELECT * FROM %s.branch_main ORDER BY id", new Object[]{this.tableName}));
        });
    }

    @TestTemplate
    public void testMergeToWapBranchWithTableBranchIdentifier() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Test must have branch name part in table identifier", new Object[0])).isNotNull();
        this.createAndInitTable("id INT", "{\"id\": -1}");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.range(0L, 5L).coalesce(1).createOrReplaceTempView("source");
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{-1}), (Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1}), (Object)this.row(new Object[]{2}), (Object)this.row(new Object[]{3}), (Object)this.row(new Object[]{4}));
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("MERGE INTO %s t USING source s ON t.id = s.id WHEN MATCHED THEN UPDATE SET *WHEN NOT MATCHED THEN INSERT *", new Object[]{this.commitTarget()})).isInstanceOf(ValidationException.class)).hasMessage(String.format("Cannot write to both branch and WAP branch, but got branch [%s] and WAP branch [wap]", this.branch)));
    }

    private void checkJoinAndFilterConditions(String query, String join, String icebergFilters) {
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.DYNAMIC_PARTITION_PRUNING_ENABLED().key(), (Object)"false", (Object)SQLConf.RUNTIME_ROW_LEVEL_OPERATION_GROUP_FILTER_ENABLED().key(), (Object)"false"), () -> {
            SparkPlan sparkPlan = this.executeAndKeepPlan(() -> this.sql(query, new Object[0]));
            String planAsString = sparkPlan.toString().replaceAll("#(\\d+L?)", "");
            ((AbstractStringAssert)Assertions.assertThat((String)planAsString).as("Join should match", new Object[0])).contains(new CharSequence[]{join + "\n"});
            ((AbstractStringAssert)Assertions.assertThat((String)planAsString).as("Pushed filters must match", new Object[0])).contains(new CharSequence[]{"[filters=" + icebergFilters + ","});
        });
    }

    private RowLevelOperationMode mode(Table table) {
        String modeName = table.properties().getOrDefault("write.merge.mode", TableProperties.MERGE_MODE_DEFAULT);
        return RowLevelOperationMode.fromName((String)modeName);
    }
}

