/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.extensions.TestMerge;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.Encoders;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;

public class TestMergeOnReadMerge
extends TestMerge {
    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"write.merge.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName());
    }

    @TestTemplate
    public void testMergeDeleteFileGranularity() {
        this.checkMergeDeleteGranularity(DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testMergeDeletePartitionGranularity() {
        this.checkMergeDeleteGranularity(DeleteGranularity.PARTITION);
    }

    private void checkMergeDeleteGranularity(DeleteGranularity deleteGranularity) {
        this.createAndInitTable("id INT, dep STRING", "PARTITIONED BY (dep)", null);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.delete.granularity", deleteGranularity});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"hr\" }\n{ \"id\": 4, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"it\" }\n{ \"id\": 2, \"dep\": \"it\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"it\" }\n{ \"id\": 4, \"dep\": \"it\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("source", ImmutableList.of((Object)1, (Object)3, (Object)5), Encoders.INT());
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value WHEN MATCHED THEN  DELETE WHEN NOT MATCHED THEN  INSERT (id, dep) VALUES (-1, 'other')", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = deleteGranularity == DeleteGranularity.FILE ? "4" : "2";
        this.validateMergeOnRead(currentSnapshot, "3", expectedDeleteFilesCount, "1");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "other"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{4, "hr"}), (Object)this.row(new Object[]{4, "it"})), this.sql("SELECT * FROM %s ORDER BY id ASC, dep ASC", new Object[]{this.selectTarget()}));
    }
}

