/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.extensions.TestUpdate;
import org.apache.iceberg.util.SnapshotUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMergeOnReadUpdate
extends TestUpdate {
    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"write.update.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName());
    }

    @TestTemplate
    public void testUpdateFileGranularity() {
        this.checkUpdateFileGranularity(DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testUpdatePartitionGranularity() {
        this.checkUpdateFileGranularity(DeleteGranularity.PARTITION);
    }

    private void checkUpdateFileGranularity(DeleteGranularity deleteGranularity) {
        this.createAndInitTable("id INT, dep STRING", "PARTITIONED BY (dep)", null);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.delete.granularity", deleteGranularity});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"hr\" }\n{ \"id\": 4, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"it\" }\n{ \"id\": 2, \"dep\": \"it\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"it\" }\n{ \"id\": 4, \"dep\": \"it\" }");
        this.createBranchIfNeeded();
        this.sql("UPDATE %s SET id = id - 1 WHERE id = 1 OR id = 3", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = deleteGranularity == DeleteGranularity.FILE ? "4" : "2";
        this.validateMergeOnRead(currentSnapshot, "2", expectedDeleteFilesCount, "2");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{4, "hr"}), (Object)this.row(new Object[]{0, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{4, "it"})), this.sql("SELECT * FROM %s ORDER BY dep ASC, id ASC", new Object[]{this.selectTarget()}));
    }
}

