/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.commons.collections.ListUtils;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMetadataTables
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testUnpartitionedTable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "b"), new SimpleRecord(Integer.valueOf(3), "c"), new SimpleRecord(Integer.valueOf(4), "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        ((ListAssert)Assertions.assertThat((List)expectedDataManifests).as("Should have 1 data manifest", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)expectedDeleteManifests).as("Should have 1 delete manifest", new Object[0])).hasSize(1);
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".files")).schema();
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".delete_files");
        List actualDeleteFiles = TestHelpers.selectNonDerived((Dataset)actualDeleteFilesDs).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualDeleteFiles).as("Metadata table should return one delete file", new Object[0])).hasSize(1);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        ((ListAssert)Assertions.assertThat(expectedDeleteFiles).as("Should be one delete file manifest entry", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".data_files");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualDataFiles).as("Metadata table should return one data file", new Object[0])).hasSize(1);
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        ((ListAssert)Assertions.assertThat(expectedDataFiles).as("Should be one data file manifest entry", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".files ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualFiles).as("Metadata table should return two files", new Object[0])).hasSize(2);
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(expectedFiles).as("Should have two files manifest entries", new Object[0])).hasSize(2);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(0)), (Row)((Row)actualFiles.get(0)));
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(1)), (Row)((Row)actualFiles.get(1)));
    }

    @TestTemplate
    public void testPartitionedTable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1 AND data='a'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=1 AND data='b'", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        ((ListAssert)Assertions.assertThat((List)expectedDataManifests).as("Should have 2 data manifest", new Object[0])).hasSize(2);
        ((ListAssert)Assertions.assertThat((List)expectedDeleteManifests).as("Should have 2 delete manifest", new Object[0])).hasSize(2);
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".delete_files")).schema();
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        ((ListAssert)Assertions.assertThat(expectedDeleteFiles).as("Should have one delete file manifest entry", new Object[0])).hasSize(1);
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".delete_files WHERE partition.data='a'");
        List actualDeleteFiles = actualDeleteFilesDs.collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualDeleteFiles).as("Metadata table should return one delete file", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        ((ListAssert)Assertions.assertThat(expectedDataFiles).as("Should have one data file manifest entry", new Object[0])).hasSize(1);
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".data_files WHERE partition.data='a'");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualDataFiles).as("Metadata table should return one data file", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        List actualPartitionsWithProjection = spark.sql("SELECT file_count FROM " + this.tableName + ".partitions ").collectAsList();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)actualPartitionsWithProjection).as("Metadata table should return two partitions record", new Object[0])).hasSize(2)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{1}), RowFactory.create((Object[])new Object[]{1})});
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(expectedFiles).as("Should have two file manifest entries", new Object[0])).hasSize(2);
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".files WHERE partition.data='a' ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualFiles).as("Metadata table should return two files", new Object[0])).hasSize(2);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(0)), (Row)((Row)actualFiles.get(0)));
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(1)), (Row)((Row)actualFiles.get(1)));
    }

    @TestTemplate
    public void testAllFilesUnpartitioned() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "b"), new SimpleRecord(Integer.valueOf(3), "c"), new SimpleRecord(Integer.valueOf(4), "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        ((ListAssert)Assertions.assertThat((List)expectedDataManifests).as("Should have 1 data manifest", new Object[0])).hasSize(1);
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        ((ListAssert)Assertions.assertThat((List)expectedDeleteManifests).as("Should have 1 delete manifest", new Object[0])).hasSize(1);
        List results = this.sql("DELETE FROM %s", new Object[]{this.tableName});
        ((ListAssert)Assertions.assertThat((List)results).as("Table should be cleared", new Object[0])).isEmpty();
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".all_data_files")).schema();
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_data_files");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        ((ListAssert)Assertions.assertThat(expectedDataFiles).as("Should be one data file manifest entry", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)actualDataFiles).as("Metadata table should return one data file", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_delete_files");
        List actualDeleteFiles = TestHelpers.selectNonDerived((Dataset)actualDeleteFilesDs).collectAsList();
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        ((ListAssert)Assertions.assertThat(expectedDeleteFiles).as("Should be one delete file manifest entry", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)actualDeleteFiles).as("Metadata table should return one delete file", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_files ORDER BY content");
        List actualFiles = actualFilesDs.collectAsList();
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        ((ListAssert)Assertions.assertThat((List)actualFiles).as("Metadata table should return two files", new Object[0])).hasSize(2);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (List)expectedFiles, (List)actualFiles);
    }

    @TestTemplate
    public void testAllFilesPartitioned() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        ((ListAssert)Assertions.assertThat((List)expectedDataManifests).as("Should have 2 data manifests", new Object[0])).hasSize(2);
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        ((ListAssert)Assertions.assertThat((List)expectedDeleteManifests).as("Should have 1 delete manifest", new Object[0])).hasSize(1);
        List results = this.sql("DELETE FROM %s", new Object[]{this.tableName});
        ((ListAssert)Assertions.assertThat((List)results).as("Table should be cleared", new Object[0])).isEmpty();
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".all_data_files")).schema();
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_data_files WHERE partition.data='a'");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        ((ListAssert)Assertions.assertThat(expectedDataFiles).as("Should be one data file manifest entry", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)actualDataFiles).as("Metadata table should return one data file", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)SparkSchemaUtil.convert((StructType)TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).schema()).asStruct(), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_delete_files WHERE partition.data='a'");
        List actualDeleteFiles = TestHelpers.selectNonDerived((Dataset)actualDeleteFilesDs).collectAsList();
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        ((ListAssert)Assertions.assertThat(expectedDeleteFiles).as("Should be one data file manifest entry", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)actualDeleteFiles).as("Metadata table should return one data file", new Object[0])).hasSize(1);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_files WHERE partition.data='a' ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        ((ListAssert)Assertions.assertThat((List)actualFiles).as("Metadata table should return two files", new Object[0])).hasSize(2);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (List)expectedFiles, (List)actualFiles);
    }

    @TestTemplate
    public void testMetadataLogEntries() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES ('format-version'='2')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        TableMetadata tableMetadata = ((HasTableOperations)table).operations().current();
        Snapshot currentSnapshot = tableMetadata.currentSnapshot();
        Snapshot parentSnapshot = table.snapshot(currentSnapshot.parentId().longValue());
        ArrayList metadataLogEntries = Lists.newArrayList((Iterable)tableMetadata.previousFiles());
        List metadataLogs = this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName});
        this.assertEquals("MetadataLogEntriesTable result should match the metadataLog entries", (List)ImmutableList.of((Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).timestampMillis() * 1000L)), ((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).file(), null, null, null}), (Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).timestampMillis() * 1000L)), ((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).file(), parentSnapshot.snapshotId(), parentSnapshot.schemaId(), parentSnapshot.sequenceNumber()}), (Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(currentSnapshot.timestampMillis() * 1000L)), tableMetadata.metadataFileLocation(), currentSnapshot.snapshotId(), currentSnapshot.schemaId(), currentSnapshot.sequenceNumber()})), metadataLogs);
        List metadataLogWithFilters = this.sql("SELECT * FROM %s.metadata_log_entries WHERE latest_snapshot_id = %s", new Object[]{this.tableName, currentSnapshotId});
        ((ListAssert)Assertions.assertThat((List)metadataLogWithFilters).as("metadataLogEntries table should return 1 row", new Object[0])).hasSize(1);
        this.assertEquals("Result should match the latest snapshot entry", (List)ImmutableList.of((Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.currentSnapshot().timestampMillis() * 1000L)), tableMetadata.metadataFileLocation(), tableMetadata.currentSnapshot().snapshotId(), tableMetadata.currentSnapshot().schemaId(), tableMetadata.currentSnapshot().sequenceNumber()})), metadataLogWithFilters);
        List metadataFiles = metadataLogEntries.stream().map(TableMetadata.MetadataLogEntry::file).collect(Collectors.toList());
        metadataFiles.add(tableMetadata.metadataFileLocation());
        List metadataLogWithProjection = this.sql("SELECT file FROM %s.metadata_log_entries", new Object[]{this.tableName});
        ((ListAssert)Assertions.assertThat((List)metadataLogWithProjection).as("metadataLogEntries table should return 3 rows", new Object[0])).hasSize(3);
        this.assertEquals("metadataLog entry should be of same file", metadataFiles.stream().map(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList()), metadataLogWithProjection);
    }

    @TestTemplate
    public void testFilesTableTimeTravelWithSchemaEvolution() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        table.updateSchema().addColumn("category", (Type)Types.StringType.get()).commit();
        ArrayList newRecords = Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{3, "b", "c"}), RowFactory.create((Object[])new Object[]{4, "b", "c"})});
        StructType newSparkSchema = SparkSchemaUtil.convert((Schema)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"category", (Type)Types.StringType.get())}));
        spark.createDataFrame((List)newRecords, newSparkSchema).coalesce(1).writeTo(this.tableName).append();
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".files VERSION AS OF " + currentSnapshotId + " ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        List<GenericData.Record> expectedFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        ((ListAssert)Assertions.assertThat((List)actualFiles).as("actualFiles size should be 2", new Object[0])).hasSize(2);
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)expectedFiles.get(0), (Row)((Row)actualFiles.get(0)));
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)expectedFiles.get(1), (Row)((Row)actualFiles.get(1)));
        ((ListAssert)Assertions.assertThat((List)actualFiles).as("expectedFiles and actualFiles size should be the same", new Object[0])).hasSameSizeAs(expectedFiles);
    }

    @TestTemplate
    public void testSnapshotReferencesMetatable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch("testBranch", currentSnapshotId.longValue()).setMaxRefAgeMs("testBranch", 10L).setMinSnapshotsToKeep("testBranch", 20).setMaxSnapshotAgeMs("testBranch", 30L).commit();
        table.manageSnapshots().createTag("testTag", currentSnapshotId.longValue()).setMaxRefAgeMs("testTag", 50L).commit();
        List references = spark.sql("SELECT * FROM " + this.tableName + ".refs").collectAsList();
        ((ListAssert)Assertions.assertThat((List)references).as("Refs table should return 3 rows", new Object[0])).hasSize(3);
        List branches = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE type='BRANCH'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)branches).as("Refs table should return 2 branches", new Object[0])).hasSize(2);
        List tags = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE type='TAG'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)tags).as("Refs table should return 1 tag", new Object[0])).hasSize(1);
        List mainBranch = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE name = 'main' AND type='BRANCH'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)mainBranch).hasSize(1)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{"main", "BRANCH", currentSnapshotId, null, null, null})});
        Assertions.assertThat((Object[])((Row)mainBranch.get(0)).schema().fieldNames()).containsExactly((Object[])new String[]{"name", "type", "snapshot_id", "max_reference_age_in_ms", "min_snapshots_to_keep", "max_snapshot_age_in_ms"});
        List testBranch = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE name = 'testBranch' AND type='BRANCH'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)testBranch).hasSize(1)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{"testBranch", "BRANCH", currentSnapshotId, 10L, 20L, 30L})});
        Assertions.assertThat((Object[])((Row)testBranch.get(0)).schema().fieldNames()).containsExactly((Object[])new String[]{"name", "type", "snapshot_id", "max_reference_age_in_ms", "min_snapshots_to_keep", "max_snapshot_age_in_ms"});
        List testTag = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE name = 'testTag' AND type='TAG'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)testTag).hasSize(1)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{"testTag", "TAG", currentSnapshotId, 50L, null, null})});
        Assertions.assertThat((Object[])((Row)testTag.get(0)).schema().fieldNames()).containsExactly((Object[])new String[]{"name", "type", "snapshot_id", "max_reference_age_in_ms", "min_snapshots_to_keep", "max_snapshot_age_in_ms"});
        List testTagProjection = spark.sql("SELECT name,type,snapshot_id,max_reference_age_in_ms,min_snapshots_to_keep FROM " + this.tableName + ".refs where type='TAG'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)testTagProjection).hasSize(1)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{"testTag", "TAG", currentSnapshotId, 50L, null})});
        Assertions.assertThat((Object[])((Row)testTagProjection.get(0)).schema().fieldNames()).containsExactly((Object[])new String[]{"name", "type", "snapshot_id", "max_reference_age_in_ms", "min_snapshots_to_keep"});
        List mainBranchProjection = spark.sql("SELECT name, type FROM " + this.tableName + ".refs WHERE name = 'main' AND type = 'BRANCH'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)mainBranchProjection).hasSize(1)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{"main", "BRANCH"})});
        Assertions.assertThat((Object[])((Row)mainBranchProjection.get(0)).schema().fieldNames()).containsExactly((Object[])new String[]{"name", "type"});
        List testBranchProjection = spark.sql("SELECT name, type, snapshot_id, max_reference_age_in_ms FROM " + this.tableName + ".refs WHERE name = 'testBranch' AND type = 'BRANCH'").collectAsList();
        ((ListAssert)Assertions.assertThat((List)testBranchProjection).hasSize(1)).containsExactly((Object[])new Row[]{RowFactory.create((Object[])new Object[]{"testBranch", "BRANCH", currentSnapshotId, 10L})});
        Assertions.assertThat((Object[])((Row)testBranchProjection.get(0)).schema().fieldNames()).containsExactly((Object[])new String[]{"name", "type", "snapshot_id", "max_reference_age_in_ms"});
    }

    private List<GenericData.Record> expectedEntries(Table table, FileContent expectedContent, Schema entriesTableSchema, List<ManifestFile> manifestsToExplore, String partValue) throws IOException {
        ArrayList expected = Lists.newArrayList();
        for (ManifestFile manifest : manifestsToExplore) {
            InputFile in = table.io().newInputFile(manifest.path());
            AvroIterable rows = Avro.read((InputFile)in).project(entriesTableSchema).build();
            Throwable throwable = null;
            try {
                for (GenericData.Record record : rows) {
                    GenericData.Record file;
                    if ((Integer)record.get("status") >= 2 || !this.partitionMatch(file = (GenericData.Record)record.get("data_file"), partValue)) continue;
                    TestHelpers.asMetadataRecord((GenericData.Record)file, (FileContent)expectedContent);
                    expected.add(file);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rows == null) continue;
                if (throwable != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rows.close();
            }
        }
        return expected;
    }

    private boolean partitionMatch(GenericData.Record file, String partValue) {
        if (partValue == null) {
            return true;
        }
        GenericData.Record partition = (GenericData.Record)file.get(4);
        return partValue.equals(partition.get(0).toString());
    }

    @TestTemplate
    public void metadataLogEntriesAfterReplacingTable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES ('format-version'='2')", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        TableMetadata tableMetadata = ((HasTableOperations)table).operations().current();
        Assertions.assertThat((List)tableMetadata.snapshots()).isEmpty();
        Assertions.assertThat((List)tableMetadata.snapshotLog()).isEmpty();
        Assertions.assertThat((Object)tableMetadata.currentSnapshot()).isNull();
        Object[] firstEntry = this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.lastUpdatedMillis() * 1000L)), tableMetadata.metadataFileLocation(), null, null, null});
        Assertions.assertThat((List)this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName})).containsExactly((Object[])new Object[][]{firstEntry});
        this.sql("INSERT INTO %s (id, data) VALUES (1, 'a')", new Object[]{this.tableName});
        tableMetadata = ((HasTableOperations)table).operations().refresh();
        Assertions.assertThat((List)tableMetadata.snapshots()).hasSize(1);
        Assertions.assertThat((List)tableMetadata.snapshotLog()).hasSize(1);
        Snapshot currentSnapshot = tableMetadata.currentSnapshot();
        Object[] secondEntry = this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.lastUpdatedMillis() * 1000L)), tableMetadata.metadataFileLocation(), currentSnapshot.snapshotId(), currentSnapshot.schemaId(), currentSnapshot.sequenceNumber()});
        Assertions.assertThat((List)this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName})).containsExactly((Object[])new Object[][]{firstEntry, secondEntry});
        this.sql("INSERT INTO %s (id, data) VALUES (1, 'a')", new Object[]{this.tableName});
        tableMetadata = ((HasTableOperations)table).operations().refresh();
        Assertions.assertThat((List)tableMetadata.snapshots()).hasSize(2);
        Assertions.assertThat((List)tableMetadata.snapshotLog()).hasSize(2);
        currentSnapshot = tableMetadata.currentSnapshot();
        Object[] thirdEntry = this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.lastUpdatedMillis() * 1000L)), tableMetadata.metadataFileLocation(), currentSnapshot.snapshotId(), currentSnapshot.schemaId(), currentSnapshot.sequenceNumber()});
        Assertions.assertThat((List)this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName})).containsExactly((Object[])new Object[][]{firstEntry, secondEntry, thirdEntry});
        this.sql("CREATE OR REPLACE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES ('format-version'='2')", new Object[]{this.tableName});
        tableMetadata = ((HasTableOperations)table).operations().refresh();
        Assertions.assertThat((List)tableMetadata.snapshots()).hasSize(2);
        Assertions.assertThat((List)tableMetadata.snapshotLog()).hasSize(2);
        Assertions.assertThat((Object)tableMetadata.currentSnapshot()).isNull();
        HistoryEntry historyEntry = (HistoryEntry)tableMetadata.snapshotLog().get(1);
        Snapshot lastSnapshot = tableMetadata.snapshot(historyEntry.snapshotId());
        Object[] fourthEntry = this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.lastUpdatedMillis() * 1000L)), tableMetadata.metadataFileLocation(), lastSnapshot.snapshotId(), lastSnapshot.schemaId(), lastSnapshot.sequenceNumber()});
        Assertions.assertThat((List)this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName})).containsExactly((Object[])new Object[][]{firstEntry, secondEntry, thirdEntry, fourthEntry});
        this.sql("INSERT INTO %s (id, data) VALUES (1, 'a')", new Object[]{this.tableName});
        tableMetadata = ((HasTableOperations)table).operations().refresh();
        Assertions.assertThat((List)tableMetadata.snapshots()).hasSize(3);
        Assertions.assertThat((List)tableMetadata.snapshotLog()).hasSize(3);
        currentSnapshot = tableMetadata.currentSnapshot();
        Object[] fifthEntry = this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.lastUpdatedMillis() * 1000L)), tableMetadata.metadataFileLocation(), currentSnapshot.snapshotId(), currentSnapshot.schemaId(), currentSnapshot.sequenceNumber()});
        Assertions.assertThat((List)this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName})).containsExactly((Object[])new Object[][]{firstEntry, secondEntry, thirdEntry, fourthEntry, fifthEntry});
    }
}

