/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMigrateTableProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s_BACKUP_", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testMigrate() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        String tableLocation = createdTable.location().replace("file:", "");
        ((AbstractStringAssert)Assertions.assertThat((String)tableLocation).as("Table should have original location", new Object[0])).isEqualTo(location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName + "_BACKUP_"});
    }

    @TestTemplate
    public void testMigrateWithOptions() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s', map('foo', 'bar'))", new Object[]{this.catalogName, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        Map props = createdTable.properties();
        Assertions.assertThat((Map)props).containsEntry((Object)"foo", (Object)"bar");
        String tableLocation = createdTable.location().replace("file:", "");
        ((AbstractStringAssert)Assertions.assertThat((String)tableLocation).as("Table should have original location", new Object[0])).isEqualTo(location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName + "_BACKUP_"});
    }

    @TestTemplate
    public void testMigrateWithDropBackup() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate(table => '%s', drop_backup => true)", new Object[]{this.catalogName, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)spark.catalog().tableExists(this.tableName + "_BACKUP_")).isFalse();
    }

    @TestTemplate
    public void testMigrateWithBackupTableName() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        String backupTableName = "backup_table";
        Object result = this.scalarSql("CALL %s.system.migrate(table => '%s', backup_table_name => '%s')", new Object[]{this.catalogName, this.tableName, backupTableName});
        Assertions.assertThat((Object)result).isEqualTo((Object)1L);
        String dbName = this.tableName.split("\\.")[0];
        Assertions.assertThat((boolean)spark.catalog().tableExists(dbName + "." + backupTableName)).isTrue();
    }

    @TestTemplate
    public void testMigrateWithInvalidMetricsConfig() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            String props = "map('write.metadata.metrics.column.x', 'X')";
            this.sql("CALL %s.system.migrate('%s', %s)", new Object[]{this.catalogName, this.tableName, props});
        }).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Invalid metrics config");
    }

    @TestTemplate
    public void testMigrateWithConflictingProps() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s', map('migrated', 'false'))", new Object[]{this.catalogName, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Map)table.properties()).containsEntry((Object)"migrated", (Object)"true");
    }

    @TestTemplate
    public void testInvalidMigrateCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.migrate()", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.migrate(map('foo','bar'))", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Wrong arg type for table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.migrate('')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
    }

    @TestTemplate
    public void testMigratePartitionWithSpecialCharacter() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string, dt date) USING parquet PARTITIONED BY (data, dt) LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, '2023/05/30', date '2023-05-30')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "2023/05/30", Date.valueOf("2023-05-30")})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testMigrateEmptyPartitionedTable() throws Exception {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet PARTITIONED BY (id) LOCATION '%s'", new Object[]{this.tableName, location});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        Assertions.assertThat((Object)result).isEqualTo((Object)0L);
    }

    @TestTemplate
    public void testMigrateEmptyTable() throws Exception {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        Assertions.assertThat((Object)result).isEqualTo((Object)0L);
    }
}

