/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Zorder;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.ExtendedParser;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.spark.SystemFunctionPushDownHelper;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestRewriteDataFilesProcedure
extends ExtensionsTestBase {
    private static final String QUOTED_SPECIAL_CHARS_TABLE_NAME = "`table:with.special:chars`";

    @BeforeAll
    public static void setupSpark() {
        spark.conf().set(SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), "false");
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
    }

    @TestTemplate
    public void testZOrderSortExpression() {
        List order = ExtendedParser.parseSortOrder((SparkSession)spark, (String)"c1, zorder(c2, c3)");
        ((ListAssert)Assertions.assertThat((List)order).as("Should parse 2 order fields", new Object[0])).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((NamedReference)((ExtendedParser.RawOrderField)order.get(0)).term()).name()).as("First field should be a ref", new Object[0])).isEqualTo("c1");
        ((ObjectAssert)Assertions.assertThat((Object)((ExtendedParser.RawOrderField)order.get(1)).term()).as("Second field should be zorder", new Object[0])).isInstanceOf(Zorder.class);
    }

    @TestTemplate
    public void testRewriteDataFilesInEmptyTable() {
        this.createTable();
        List output = this.sql("CALL %s.system.rewrite_data_files('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0, 0L, 0})), output);
    }

    @TestTemplate
    public void testRewriteDataFilesOnPartitionTable() {
        this.createPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 2 data files (one per partition) ", this.row(new Object[]{10, 2}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesOnNonPartitionTable() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithOptions() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', options => map('min-input-files','12'))", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 0 data files and add 0 data files", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0, 0L, 0})), output);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithSortStrategy() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1 DESC NULLS LAST')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithSortStrategyAndMultipleShufflePartitionsPerFile() {
        this.createTable();
        this.insertData(10);
        List output = this.sql("CALL %s.system.rewrite_data_files( table => '%s',  strategy => 'sort',  sort_order => 'c1',  options => map('shuffle-partitions-per-file', '2'))", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRewriteDataFilesWithZOrder() {
        this.createTable();
        this.insertData(10);
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'zorder(c1,c2)')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRewriteDataFilesWithZOrderAndMultipleShufflePartitionsPerFile() {
        this.createTable();
        this.insertData(10);
        List output = this.sql("CALL %s.system.rewrite_data_files( table => '%s', strategy => 'sort',  sort_order => 'zorder(c1, c2)',  options => map('shuffle-partitions-per-file', '2'))", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRewriteDataFilesWithFilter() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 1 and c2 is not null')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 5 data files (containing c1 = 1) and add 1 data files", this.row(new Object[]{5, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithDeterministicTrueFilter() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '1=1')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithDeterministicFalseFilter() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '0=1')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 0 data files and add 0 data files", this.row(new Object[]{0, 0}), Arrays.copyOf((Object[])output.get(0), 2));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithFilterOnPartitionTable() {
        this.createPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 = \"bar\"')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 5 data files from single matching partition(containing c2 = bar) and add 1 data files", this.row(new Object[]{5, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithFilterOnOnBucketExpression() {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualTo((Object)SparkCatalogConfig.SPARK.catalogName());
        this.createBucketPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.bucket(2, c2) = 0')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
        this.assertEquals("Action should rewrite 5 data files from single matching partition(containing bucket(c2) = 0) and add 1 data files", this.row(new Object[]{5, 1}), this.row(new Object[]{((Object[])output.get(0))[0], ((Object[])output.get(0))[1]}));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithInFilterOnPartitionTable() {
        this.createPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 in (\"bar\")')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 5 data files from single matching partition(containing c2 = bar) and add 1 data files", this.row(new Object[]{5, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteDataFilesWithAllPossibleFilters() {
        this.createPartitionTable();
        this.insertData(10);
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 3')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 > 3')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 >= 3')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 < 0')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 <= 0')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 in (3,4,5)')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 is null')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c3 is not null')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 3 and c2 = \"bar\"')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 3 or c1 = 5')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 not in (1,2)')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 like \"%s\"')", new Object[]{this.catalogName, this.tableIdent, "car%"});
    }

    @TestTemplate
    public void testRewriteDataFilesWithPossibleV2Filters() {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualTo((Object)SparkCatalogConfig.SPARK.catalogName());
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"id");
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.bucket(2, data) >= 0')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.truncate(4, id) >= 1')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.years(ts) >= 1')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.months(ts) >= 1')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.days(ts) >= date(\"2023-01-01\")')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '%s.system.hours(ts) >= 1')", new Object[]{this.catalogName, this.tableIdent, this.catalogName});
    }

    @TestTemplate
    public void testRewriteDataFilesWithInvalidInputs() {
        this.createTable();
        this.insertData(2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', options => map('min-input-files','2'), strategy => 'temp')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("unsupported strategy: temp. Only binpack or sort is supported");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'binpack', sort_order => 'c1 ASC NULLS FIRST')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must use only one rewriter type (bin-pack, sort, zorder)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot sort data without a valid sort order");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1 ASC none')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unable to parse sortOrder: c1 ASC none");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1 none NULLS FIRST')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unable to parse sortOrder: c1 none NULLS FIRST");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'col1 DESC NULLS FIRST')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Cannot find field 'col1' in struct:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'col1 = 3')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse predicates in where option: col1 = 3");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'zorder(col1)')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find column 'col1' in table schema (case sensitive = false): struct<1: c1: optional int, 2: c2: optional string, 3: c3: optional string>");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1,zorder(c2,c3)')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot mix identity sort columns and a Zorder sort expression: c1,zorder(c2,c3)");
    }

    @TestTemplate
    public void testInvalidCasesForRewriteDataFiles() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files('n', table => 't')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.rewrite_data_files('n', 't')", new Object[]{this.catalogName})).isInstanceOf(NoSuchProcedureException.class)).hasMessage("Procedure custom.rewrite_data_files not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files()", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => 't', table => 't')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessageEndingWith("Duplicate procedure argument: table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files('')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for parameter 'table'");
    }

    @TestTemplate
    public void testBinPackTableWithSpecialChars() {
        Assumptions.assumeThat((String)this.catalogName).isEqualTo(SparkCatalogConfig.HADOOP.catalogName());
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", QUOTED_SPECIAL_CHARS_TABLE_NAME.replaceAll("`", "")});
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.insertData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME), 10);
        List<Object[]> expectedRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 is not null')", new Object[]{this.catalogName, this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.assertEquals("Action should rewrite 10 data files and add 1 data file", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        Assertions.assertThat((Object)((Object[])output.get(0))[2]).isEqualTo((Object)Long.valueOf(this.snapshotSummary(identifier).get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
        ((AbstractIntegerAssert)Assertions.assertThat((int)SparkTableCache.get().size()).as("Table cache must be empty", new Object[0])).isEqualTo(0);
    }

    @TestTemplate
    public void testSortTableWithSpecialChars() {
        Assumptions.assumeThat((String)this.catalogName).isEqualTo(SparkCatalogConfig.HADOOP.catalogName());
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", QUOTED_SPECIAL_CHARS_TABLE_NAME.replaceAll("`", "")});
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.insertData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME), 10);
        List<Object[]> expectedRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        List output = this.sql("CALL %s.system.rewrite_data_files(  table => '%s',  strategy => 'sort',  sort_order => 'c1',  where => 'c2 is not null')", new Object[]{this.catalogName, this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.assertEquals("Action should rewrite 10 data files and add 1 data file", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary(identifier).get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
        ((AbstractIntegerAssert)Assertions.assertThat((int)SparkTableCache.get().size()).as("Table cache must be empty", new Object[0])).isEqualTo(0);
    }

    @TestTemplate
    public void testZOrderTableWithSpecialChars() {
        Assumptions.assumeThat((String)this.catalogName).isEqualTo(SparkCatalogConfig.HADOOP.catalogName());
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", QUOTED_SPECIAL_CHARS_TABLE_NAME.replaceAll("`", "")});
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.insertData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME), 10);
        List<Object[]> expectedRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        List output = this.sql("CALL %s.system.rewrite_data_files(  table => '%s',  strategy => 'sort',  sort_order => 'zorder(c1, c2)',  where => 'c2 is not null')", new Object[]{this.catalogName, this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.assertEquals("Action should rewrite 10 data files and add 1 data file", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary(identifier).get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
        ((AbstractIntegerAssert)Assertions.assertThat((int)SparkTableCache.get().size()).as("Table cache must be empty", new Object[0])).isEqualTo(0);
    }

    @TestTemplate
    public void testDefaultSortOrder() {
        this.createTable();
        this.sql("ALTER TABLE %s WRITE ORDERED BY c2", new Object[]{this.tableName});
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', options => map('min-input-files','2'))", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 2 data files and add 1 data files", this.row(new Object[]{2, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(4);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testRewriteWithUntranslatedOrUnconvertedFilter() {
        this.createTable();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'substr(encode(c2, \"utf-8\"), 2) = \"fo\"')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot translate Spark expression");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'substr(c2, 2) = \"fo\"')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot convert Spark filter");
    }

    private void createTable() {
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName});
    }

    private void createPartitionTable() {
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg PARTITIONED BY (c2) TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", "none"});
    }

    private void createBucketPartitionTable() {
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg PARTITIONED BY (bucket(2, c2)) TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", "none"});
    }

    private void insertData(int filesCount) {
        this.insertData(this.tableName, filesCount);
    }

    private void insertData(String table, int filesCount) {
        ThreeColumnRecord record1 = new ThreeColumnRecord(Integer.valueOf(1), "foo", null);
        ThreeColumnRecord record2 = new ThreeColumnRecord(Integer.valueOf(2), "bar", null);
        ArrayList records = Lists.newArrayList();
        IntStream.range(0, filesCount / 2).forEach(i -> {
            records.add(record1);
            records.add(record2);
        });
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).repartition(filesCount);
        try {
            df.writeTo(table).append();
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> snapshotSummary() {
        return this.snapshotSummary(this.tableIdent);
    }

    private Map<String, String> snapshotSummary(TableIdentifier tableIdentifier) {
        return this.validationCatalog.loadTable(tableIdentifier).currentSnapshot().summary();
    }

    private List<Object[]> currentData() {
        return this.currentData(this.tableName);
    }

    private List<Object[]> currentData(String table) {
        return this.rowsToJava(spark.sql("SELECT * FROM " + table + " order by c1, c2, c3").collectAsList());
    }
}

