/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestRollbackToSnapshotProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testRollbackToSnapshotUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.rollback_to_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToSnapshotUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.rollback_to_snapshot(snapshot_id => %dL, table => '%s')", new Object[]{this.catalogName, firstSnapshot.snapshotId(), this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToSnapshotRefreshesRelationCache() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        List output = this.sql("CALL %s.system.rollback_to_snapshot(table => '%s', snapshot_id => %dL)", new Object[]{this.catalogName, this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("View cache must be invalidated", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("UNCACHE TABLE tmp", new Object[0]);
    }

    @TestTemplate
    public void testRollbackToSnapshotWithQuotedIdentifiers() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        StringBuilder quotedNamespaceBuilder = new StringBuilder();
        for (String level : this.tableIdent.namespace().levels()) {
            quotedNamespaceBuilder.append("`");
            quotedNamespaceBuilder.append(level);
            quotedNamespaceBuilder.append("`");
        }
        String quotedNamespace = quotedNamespaceBuilder.toString();
        List output = this.sql("CALL %s.system.rollback_to_snapshot('%s', %d)", new Object[]{this.catalogName, quotedNamespace + ".`" + this.tableIdent.name() + "`", firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToSnapshotWithoutExplicitCatalog() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Working only with the session catalog", new Object[0])).isEqualTo("spark_catalog");
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL SyStEm.rOLlBaCk_to_SnApShOt('%s', %dL)", new Object[]{this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToInvalidSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot('%s', -1L)", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(ValidationException.class)).hasMessage("Cannot roll back to unknown snapshot id: -1");
    }

    @TestTemplate
    public void testInvalidRollbackToSnapshotCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot(namespace => 'n1', table => 't', 1L)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.rollback_to_snapshot('n', 't', 1L)", new Object[]{this.catalogName})).isInstanceOf(NoSuchProcedureException.class)).hasMessage("Procedure custom.rollback_to_snapshot not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot('t')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [snapshot_id]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot(1L)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [snapshot_id]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot(table => 't')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [snapshot_id]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot('t', 2.2)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Wrong arg type for snapshot_id: cannot cast DecimalType(2,1) to LongType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_snapshot('', 1L)", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
    }
}

