/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.time.LocalDateTime;
import java.util.List;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestRollbackToTimestampProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testRollbackToTimestampUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        String firstSnapshotTimestamp = LocalDateTime.now().toString();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.rollback_to_timestamp('%s',TIMESTAMP '%s')", new Object[]{this.catalogName, this.tableIdent, firstSnapshotTimestamp});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToTimestampUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        String firstSnapshotTimestamp = LocalDateTime.now().toString();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.rollback_to_timestamp(timestamp => TIMESTAMP '%s', table => '%s')", new Object[]{this.catalogName, firstSnapshotTimestamp, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToTimestampRefreshesRelationCache() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        String firstSnapshotTimestamp = LocalDateTime.now().toString();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        List output = this.sql("CALL %s.system.rollback_to_timestamp(table => '%s', timestamp => TIMESTAMP '%s')", new Object[]{this.catalogName, this.tableIdent, firstSnapshotTimestamp});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("View cache must be invalidated", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("UNCACHE TABLE tmp", new Object[0]);
    }

    @TestTemplate
    public void testRollbackToTimestampWithQuotedIdentifiers() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        String firstSnapshotTimestamp = LocalDateTime.now().toString();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        StringBuilder quotedNamespaceBuilder = new StringBuilder();
        for (String level : this.tableIdent.namespace().levels()) {
            quotedNamespaceBuilder.append("`");
            quotedNamespaceBuilder.append(level);
            quotedNamespaceBuilder.append("`");
        }
        String quotedNamespace = quotedNamespaceBuilder.toString();
        List output = this.sql("CALL %s.system.rollback_to_timestamp('%s', TIMESTAMP '%s')", new Object[]{this.catalogName, quotedNamespace + ".`" + this.tableIdent.name() + "`", firstSnapshotTimestamp});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testRollbackToTimestampWithoutExplicitCatalog() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Working only with the session catalog", new Object[0])).isEqualTo("spark_catalog");
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        String firstSnapshotTimestamp = LocalDateTime.now().toString();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL SyStEm.rOLlBaCk_to_TiMeStaMp('%s', TIMESTAMP '%s')", new Object[]{this.tableIdent, firstSnapshotTimestamp});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testInvalidRollbackToTimestampCases() {
        String timestamp = "TIMESTAMP '2007-12-03T10:15:30'";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_timestamp(namespace => 'n1', 't', %s)", new Object[]{this.catalogName, timestamp})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.rollback_to_timestamp('n', 't', %s)", new Object[]{this.catalogName, timestamp})).isInstanceOf(NoSuchProcedureException.class)).hasMessage("Procedure custom.rollback_to_timestamp not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_timestamp('t')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [timestamp]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_timestamp(timestamp => %s)", new Object[]{this.catalogName, timestamp})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_timestamp(table => 't')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [timestamp]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_timestamp('n', 't', %s, 1L)", new Object[]{this.catalogName, timestamp})).isInstanceOf(AnalysisException.class)).hasMessage("Too many arguments for procedure");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rollback_to_timestamp('t', 2.2)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Wrong arg type for timestamp: cannot cast DecimalType(2,1) to TimestampType");
    }
}

