/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSetCurrentSnapshotProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testSetCurrentSnapshotUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.set_current_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testSetCurrentSnapshotUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.set_current_snapshot(snapshot_id => %dL, table => '%s')", new Object[]{this.catalogName, firstSnapshot.snapshotId(), this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testSetCurrentSnapshotWap() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.conf().set("spark.wap.id", "1");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        List output = this.sql("CALL %s.system.set_current_snapshot(table => '%s', snapshot_id => %dL)", new Object[]{this.catalogName, this.tableIdent, wapSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{null, wapSnapshot.snapshotId()})), output);
        this.assertEquals("Current snapshot must be set correctly", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void tesSetCurrentSnapshotWithoutExplicitCatalog() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Working only with the session catalog", new Object[0])).isEqualTo("spark_catalog");
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL SyStEm.sEt_cuRrEnT_sNaPsHot('%s', %dL)", new Object[]{this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testSetCurrentSnapshotToInvalidSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot('%s', -1L)", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(ValidationException.class)).hasMessage("Cannot roll back to unknown snapshot id: -1");
    }

    @TestTemplate
    public void testInvalidRollbackToSnapshotCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot(namespace => 'n1', table => 't', 1L)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.set_current_snapshot('n', 't', 1L)", new Object[]{this.catalogName})).isInstanceOf(NoSuchProcedureException.class)).hasMessage("Procedure custom.set_current_snapshot not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot('t')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Either snapshot_id or ref must be provided, not both");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot(1L)", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse identifier for arg table: 1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot(snapshot_id => 1L)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot(table => 't')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Either snapshot_id or ref must be provided, not both");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot('t', 2.2)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Wrong arg type for snapshot_id: cannot cast DecimalType(2,1) to LongType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot('', 1L)", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot(table => 't', snapshot_id => 1L, ref => 's1')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Either snapshot_id or ref must be provided, not both");
    }

    @TestTemplate
    public void testSetCurrentSnapshotToRef() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        String ref = "s1";
        this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, ref});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.set_current_snapshot(table => '%s', ref => '%s')", new Object[]{this.catalogName, this.tableIdent, ref});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        String notExistRef = "s2";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.set_current_snapshot(table => '%s', ref => '%s')", new Object[]{this.catalogName, this.tableIdent, notExistRef})).isInstanceOf(ValidationException.class)).hasMessage("Cannot find matching snapshot ID for ref " + notExistRef);
    }
}

