/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import org.apache.iceberg.NullOrder;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSetWriteDistributionAndOrdering
extends ExtensionsTestBase {
    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testSetWriteOrderByColumn() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE ORDERED BY category, id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("range");
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category", NullOrder.NULLS_FIRST)).asc("id", NullOrder.NULLS_FIRST)).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Should have expected order", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteOrderWithCaseSensitiveColumnNames() {
        this.sql("CREATE TABLE %s (Id bigint NOT NULL, Category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("SET %s=true", new Object[]{SQLConf.CASE_SENSITIVE().key()});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s WRITE ORDERED BY category, id", new Object[]{this.tableName})).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'category' in struct");
        this.sql("SET %s=false", new Object[]{SQLConf.CASE_SENSITIVE().key()});
        this.sql("ALTER TABLE %s WRITE ORDERED BY category, id", new Object[]{this.tableName});
        table = this.validationCatalog.loadTable(this.tableIdent);
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("Category")).asc("Id")).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Should have expected order", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteOrderByColumnWithDirection() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE ORDERED BY category ASC, id DESC", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("range");
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category", NullOrder.NULLS_FIRST)).desc("id", NullOrder.NULLS_LAST)).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Should have expected order", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteOrderByColumnWithDirectionAndNullOrder() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE ORDERED BY category ASC NULLS LAST, id DESC NULLS FIRST", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("range");
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category", NullOrder.NULLS_LAST)).desc("id", NullOrder.NULLS_FIRST)).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Should have expected order", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteOrderByTransform() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).isTrue();
        this.sql("ALTER TABLE %s WRITE ORDERED BY category DESC, bucket(16, id), id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("range");
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).desc("category")).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Should have expected order", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteUnordered() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE ORDERED BY category DESC, bucket(16, id), id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("range");
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Table must be sorted", new Object[0])).isNotEqualTo((Object)SortOrder.unsorted());
        this.sql("ALTER TABLE %s WRITE UNORDERED", new Object[]{this.tableName});
        table.refresh();
        String newDistributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)newDistributionMode).as("New distribution mode must match", new Object[0])).isEqualTo("none");
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("New sort order must match", new Object[0])).isEqualTo((Object)SortOrder.unsorted());
    }

    @TestTemplate
    public void testSetWriteLocallyOrdered() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE LOCALLY ORDERED BY category DESC, bucket(16, id), id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("none");
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).desc("category")).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteDistributedByWithSort() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION ORDERED BY id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("hash");
        SortOrder expected = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("id")).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteDistributedByWithLocalSort() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION LOCALLY ORDERED BY id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("hash");
        SortOrder expected = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("id")).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testSetWriteDistributedByAndUnordered() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION UNORDERED", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("hash");
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)SortOrder.unsorted());
    }

    @TestTemplate
    public void testSetWriteDistributedByOnly() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION UNORDERED", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("hash");
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)SortOrder.unsorted());
    }

    @TestTemplate
    public void testSetWriteDistributedAndUnorderedInverted() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE UNORDERED DISTRIBUTED BY PARTITION", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("hash");
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)SortOrder.unsorted());
    }

    @TestTemplate
    public void testSetWriteDistributedAndLocallyOrderedInverted() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Table should start unsorted", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s WRITE ORDERED BY id DISTRIBUTED BY PARTITION", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        ((AbstractStringAssert)Assertions.assertThat((String)distributionMode).as("Distribution mode must match", new Object[0])).isEqualTo("hash");
        SortOrder expected = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("id")).build();
        ((ObjectAssert)Assertions.assertThat((Object)table.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)expected);
    }
}

