/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.extensions.IcebergParseException;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestTagDDL
extends ExtensionsTestBase {
    private static final String[] TIME_UNITS = new String[]{"DAYS", "HOURS", "MINUTES"};

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties()}};
    }

    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testCreateTagWithRetain() throws NoSuchTableException {
        Table table = this.insertRows();
        long firstSnapshotId = table.currentSnapshot().snapshotId();
        long maxRefAge = 10L;
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        for (String timeUnit : TIME_UNITS) {
            String tagName = "t1" + timeUnit;
            this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d RETAIN %d %s", new Object[]{this.tableName, tagName, firstSnapshotId, maxRefAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
            ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(firstSnapshotId);
            ((AbstractLongAssert)Assertions.assertThat((long)ref.maxRefAgeMs()).as("The tag needs to have the correct max ref age.", new Object[0])).isEqualTo(TimeUnit.valueOf(timeUnit.toUpperCase(Locale.ENGLISH)).toMillis(maxRefAge));
        }
        String tagName = "t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d RETAIN", new Object[]{this.tableName, tagName, firstSnapshotId, maxRefAge})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s RETAIN %s DAYS", new Object[]{this.tableName, tagName, "abc"})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d RETAIN %d SECONDS", new Object[]{this.tableName, tagName, firstSnapshotId, maxRefAge})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input 'SECONDS' expecting {'DAYS', 'HOURS', 'MINUTES'}");
    }

    @TestTemplate
    public void testCreateTagOnEmptyTable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, "abc"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot complete create or replace tag operation on %s, main has no snapshot", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testCreateTagUseDefaultConfig() throws NoSuchTableException {
        Table table = this.insertRows();
        long snapshotId = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, -1})).isInstanceOf(ValidationException.class)).hasMessage("Cannot set " + tagName + " to unknown snapshot: -1");
        this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, tagName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(snapshotId);
        ((AbstractLongAssert)Assertions.assertThat((Long)ref.maxRefAgeMs()).as("The tag needs to have the default max ref age, which is null.", new Object[0])).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, tagName})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("already exists");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, "123"})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input '123'");
        table.manageSnapshots().removeTag(tagName).commit();
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        snapshotId = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, snapshotId});
        table.refresh();
        ref = (SnapshotRef)table.refs().get(tagName);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(snapshotId);
        ((AbstractLongAssert)Assertions.assertThat((Long)ref.maxRefAgeMs()).as("The tag needs to have the default max ref age, which is null.", new Object[0])).isNull();
    }

    @TestTemplate
    public void testCreateTagIfNotExists() throws NoSuchTableException {
        long maxSnapshotAge = 2L;
        Table table = this.insertRows();
        String tagName = "t1";
        this.sql("ALTER TABLE %s CREATE TAG %s RETAIN %d days", new Object[]{this.tableName, tagName, maxSnapshotAge});
        this.sql("ALTER TABLE %s CREATE TAG IF NOT EXISTS %s", new Object[]{this.tableName, tagName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(table.currentSnapshot().snapshotId());
        ((AbstractLongAssert)Assertions.assertThat((long)ref.maxRefAgeMs()).as("The tag needs to have the correct max ref age.", new Object[0])).isEqualTo(TimeUnit.DAYS.toMillis(maxSnapshotAge));
    }

    @TestTemplate
    public void testReplaceTagFailsForBranch() throws NoSuchTableException {
        String branchName = "branch1";
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, first).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s REPLACE Tag %s", new Object[]{this.tableName, branchName, second})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Ref branch1 is a branch not a tag");
    }

    @TestTemplate
    public void testReplaceTag() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        long expectedMaxRefAgeMs = 1000L;
        table.manageSnapshots().createTag(tagName, first).setMaxRefAgeMs(tagName, expectedMaxRefAgeMs).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s REPLACE Tag %s AS OF VERSION %d", new Object[]{this.tableName, tagName, second});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(second);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.maxRefAgeMs()).as("The tag needs to have the correct max ref age.", new Object[0])).isEqualTo(expectedMaxRefAgeMs);
    }

    @TestTemplate
    public void testReplaceTagDoesNotExist() throws NoSuchTableException {
        Table table = this.insertRows();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s REPLACE Tag %s AS OF VERSION %d", new Object[]{this.tableName, "someTag", table.currentSnapshot().snapshotId()})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Tag does not exist");
    }

    @TestTemplate
    public void testReplaceTagWithRetain() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        table.manageSnapshots().createTag(tagName, first).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        long maxRefAge = 10L;
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE Tag %s AS OF VERSION %d RETAIN %d %s", new Object[]{this.tableName, tagName, second, maxRefAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
            ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(second);
            ((AbstractLongAssert)Assertions.assertThat((long)ref.maxRefAgeMs()).as("The tag needs to have the correct max ref age.", new Object[0])).isEqualTo(TimeUnit.valueOf(timeUnit).toMillis(maxRefAge));
        }
    }

    @TestTemplate
    public void testCreateOrReplace() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag(tagName, second).commit();
        this.sql("ALTER TABLE %s CREATE OR REPLACE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, first});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("The tag needs to point to a specific snapshot id.", new Object[0])).isEqualTo(first);
    }

    @TestTemplate
    public void testDropTag() throws NoSuchTableException {
        this.insertRows();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String tagName = "t1";
        table.manageSnapshots().createTag(tagName, table.currentSnapshot().snapshotId()).commit();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        ((AbstractLongAssert)Assertions.assertThat((long)ref.snapshotId()).as("", new Object[0])).isEqualTo(table.currentSnapshot().snapshotId());
        this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, tagName});
        table.refresh();
        ref = (SnapshotRef)table.refs().get(tagName);
        ((ObjectAssert)Assertions.assertThat((Object)ref).as("The tag needs to be dropped.", new Object[0])).isNull();
    }

    @TestTemplate
    public void testDropTagNonConformingName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, "123"})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input '123'");
    }

    @TestTemplate
    public void testDropTagDoesNotExist() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, "nonExistingTag"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Tag does not exist: nonExistingTag");
    }

    @TestTemplate
    public void testDropTagFailesForBranch() throws NoSuchTableException {
        String branchName = "b1";
        Table table = this.insertRows();
        table.manageSnapshots().createBranch(branchName, table.currentSnapshot().snapshotId()).commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, branchName})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Ref b1 is a branch not a tag");
    }

    @TestTemplate
    public void testDropTagIfExists() throws NoSuchTableException {
        String tagName = "nonExistingTag";
        Table table = this.insertRows();
        ((ObjectAssert)Assertions.assertThat((Object)((SnapshotRef)table.refs().get(tagName))).as("The tag does not exists.", new Object[0])).isNull();
        this.sql("ALTER TABLE %s DROP TAG IF EXISTS %s", new Object[]{this.tableName, tagName});
        table.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)((SnapshotRef)table.refs().get(tagName))).as("The tag still does not exist.", new Object[0])).isNull();
        table.manageSnapshots().createTag(tagName, table.currentSnapshot().snapshotId()).commit();
        ((AbstractLongAssert)Assertions.assertThat((long)((SnapshotRef)table.refs().get(tagName)).snapshotId()).as("The tag has been created successfully.", new Object[0])).isEqualTo(table.currentSnapshot().snapshotId());
        this.sql("ALTER TABLE %s DROP TAG IF EXISTS %s", new Object[]{this.tableName, tagName});
        table.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)((SnapshotRef)table.refs().get(tagName))).as("The tag needs to be dropped.", new Object[0])).isNull();
    }

    @TestTemplate
    public void createOrReplaceWithNonExistingTag() throws NoSuchTableException {
        Table table = this.insertRows();
        String tagName = "t1";
        this.insertRows();
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s CREATE OR REPLACE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, snapshotId});
        table.refresh();
        Assertions.assertThat((long)((SnapshotRef)table.refs().get(tagName)).snapshotId()).isEqualTo(snapshotId);
    }

    private Table insertRows() throws NoSuchTableException {
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        return this.validationCatalog.loadTable(this.tableIdent);
    }
}

