/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.spark.extensions.Employee;
import org.apache.iceberg.spark.extensions.SparkRowLevelOperationsTestBase;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestUpdate
extends SparkRowLevelOperationsTestBase {
    @BeforeAll
    public static void setupSparkConf() {
        spark.conf().set("spark.sql.shuffle.partitions", "4");
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS updated_id", new Object[0]);
        this.sql("DROP TABLE IF EXISTS updated_dep", new Object[0]);
        this.sql("DROP TABLE IF EXISTS deleted_employee", new Object[0]);
    }

    @TestTemplate
    public void testUpdateWithVectorizedReads() {
        Assumptions.assumeThat((boolean)this.supportsVectorization()).isTrue();
        this.createAndInitTable("id INT, value INT, dep STRING", "PARTITIONED BY (dep)", "{ \"id\": 1, \"value\": 100, \"dep\": \"hr\" }");
        SparkPlan plan = this.executeAndKeepPlan("UPDATE %s SET value = -1 WHERE id = 1", new Object[]{this.commitTarget()});
        this.assertAllBatchScansVectorized(plan);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, -1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testCoalesceUpdate() {
        this.createAndInitTable("id INT, dep STRING");
        String[] records = new String[100];
        for (int index = 0; index < 100; ++index) {
            records[index] = String.format("{ \"id\": %d, \"dep\": \"hr\" }", index);
        }
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        ImmutableMap tableProps = ImmutableMap.of((Object)"read.split.open-file-cost", (Object)String.valueOf(Integer.MAX_VALUE), (Object)"write.update.distribution-mode", (Object)DistributionMode.RANGE.modeName());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)tableProps)});
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"200", (Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"true", (Object)SQLConf.COALESCE_PARTITIONS_ENABLED().key(), (Object)"true", (Object)SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), (Object)"100", (Object)"spark.sql.iceberg.advisory-partition-size", (Object)String.valueOf(0x10000000)), () -> {
            SparkPlan plan = this.executeAndKeepPlan("UPDATE %s SET id = -1 WHERE mod(id, 2) = 0", new Object[]{this.commitTarget()});
            Assertions.assertThat((String)plan.toString()).contains(new CharSequence[]{"REBALANCE_PARTITIONS_BY_COL"});
        });
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateProperty(snapshot, "added-data-files", "1");
        } else {
            this.validateProperty(snapshot, "added-delete-files", "1");
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT COUNT(*) FROM %s WHERE id = -1", new Object[]{this.commitTarget()})).as("Row count must match", new Object[0])).isEqualTo((Object)200L);
    }

    @TestTemplate
    public void testSkewUpdate() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        String[] records = new String[100];
        for (int index = 0; index < 100; ++index) {
            records[index] = String.format("{ \"id\": %d, \"dep\": \"hr\" }", index);
        }
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        this.append(this.tableName, records);
        ImmutableMap tableProps = ImmutableMap.of((Object)"read.split.open-file-cost", (Object)String.valueOf(Integer.MAX_VALUE), (Object)"write.update.distribution-mode", (Object)DistributionMode.HASH.modeName());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)tableProps)});
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"2", (Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"true", (Object)SQLConf.ADAPTIVE_OPTIMIZE_SKEWS_IN_REBALANCE_PARTITIONS_ENABLED().key(), (Object)"true", (Object)SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), (Object)"256MB", (Object)"spark.sql.iceberg.advisory-partition-size", (Object)"100"), () -> {
            SparkPlan plan = this.executeAndKeepPlan("UPDATE %s SET id = -1 WHERE mod(id, 2) = 0", new Object[]{this.commitTarget()});
            Assertions.assertThat((String)plan.toString()).contains(new CharSequence[]{"REBALANCE_PARTITIONS_BY_COL"});
        });
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateProperty(snapshot, "added-data-files", "4");
        } else {
            this.validateProperty(snapshot, "added-delete-files", "4");
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT COUNT(*) FROM %s WHERE id = -1", new Object[]{this.commitTarget()})).as("Row count must match", new Object[0])).isEqualTo((Object)200L);
    }

    @TestTemplate
    public void testExplain() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("EXPLAIN UPDATE %s SET dep = 'invalid' WHERE id <=> 1", new Object[]{this.commitTarget()});
        this.sql("EXPLAIN UPDATE %s SET dep = 'invalid' WHERE true", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 1 snapshot", new Object[0])).hasSize(1);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateEmptyTable() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Custom branch does not exist for empty table", new Object[0])).isNotEqualTo((Object)"test");
        this.createAndInitTable("id INT, dep STRING");
        this.sql("UPDATE %s SET dep = 'invalid' WHERE id IN (1)", new Object[]{this.commitTarget()});
        this.sql("UPDATE %s SET id = -1 WHERE dep = 'hr'", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateNonExistingCustomBranch() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Test only applicable to custom branch", new Object[0])).isEqualTo("test");
        this.createAndInitTable("id INT, dep STRING");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET dep = 'invalid' WHERE id IN (1)", new Object[]{this.commitTarget()})).isInstanceOf(ValidationException.class)).hasMessage("Cannot use branch (does not exist): test");
    }

    @TestTemplate
    public void testUpdateWithAlias() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"a\" }");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("UPDATE %s AS t SET t.dep = 'invalid'", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "invalid"})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateAlignsAssignments() {
        this.createAndInitTable("id INT, c1 INT, c2 INT");
        this.sql("INSERT INTO TABLE %s VALUES (1, 11, 111), (2, 22, 222)", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("UPDATE %s SET `c2` = c2 - 2, c1 = `c1` - 1 WHERE id <=> 1", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, 10, 109}), (Object)this.row(new Object[]{2, 22, 222})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithUnsupportedPartitionPredicate() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'software'), (2, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("UPDATE %s t SET `t`.`id` = -1 WHERE t.dep LIKE '%%r' ", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "software"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithDynamicFileFiltering() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hardware\" }\n{ \"id\": 2, \"dep\": \"hardware\" }");
        this.sql("UPDATE %s SET id = cast('-1' AS INT) WHERE id = 2", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", "1");
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.commitTarget()}));
    }

    @TestTemplate
    public void testUpdateNonExistingRecords() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("UPDATE %s SET id = -1 WHERE id > 10", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "0", null, null);
        } else {
            this.validateMergeOnRead(currentSnapshot, "0", null, null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithoutCondition() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("INSERT INTO TABLE %s VALUES (2, 'hardware')", new Object[]{this.commitTarget()});
        this.sql("INSERT INTO TABLE %s VALUES (null, 'hr')", new Object[]{this.commitTarget()});
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"200"), () -> this.sql("UPDATE %s SET id = -1", new Object[]{this.commitTarget()}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 4 snapshots", new Object[0])).hasSize(4);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        ((AbstractStringAssert)Assertions.assertThat((String)currentSnapshot.operation()).as("Operation must match", new Object[0])).isEqualTo("overwrite");
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            ((AbstractStringAssert)Assertions.assertThat((String)currentSnapshot.operation()).as("Operation must match", new Object[0])).isEqualTo("overwrite");
            this.validateProperty(currentSnapshot, "changed-partition-count", "2");
            this.validateProperty(currentSnapshot, "deleted-data-files", "3");
            this.validateProperty(currentSnapshot, "added-data-files", (Set<String>)ImmutableSet.of((Object)"2", (Object)"3"));
        } else {
            this.validateMergeOnRead(currentSnapshot, "2", "2", "2");
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{-1, "hr"})), this.sql("SELECT * FROM %s ORDER BY dep ASC", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithNullConditions() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 0, \"dep\": null }\n{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }");
        this.createBranchIfNeeded();
        this.sql("UPDATE %s SET id = -1 WHERE dep = NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, null}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = -1 WHERE dep = 'software'", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, null}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET dep = 'invalid', id = -1 WHERE dep <=> NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "invalid"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithInAndNotInConditions() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.sql("UPDATE %s SET id = -1 WHERE id IN (1, null)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = 100 WHERE id NOT IN (null, 1)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = 100 WHERE id NOT IN (1, 10)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{100, "hardware"}), (Object)this.row(new Object[]{100, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithMultipleRowGroupsParquet() throws NoSuchTableException {
        Assumptions.assumeThat((Comparable)this.fileFormat).isEqualTo((Object)FileFormat.PARQUET);
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "write.parquet.row-group-size-bytes", 100});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "read.split.target-size", 100});
        ArrayList ids = Lists.newArrayListWithCapacity((int)200);
        for (int id = 1; id <= 200; ++id) {
            ids.add(id);
        }
        Dataset df = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"hr"));
        df.coalesce(1).writeTo(this.tableName).append();
        this.createBranchIfNeeded();
        Assertions.assertThat((long)spark.table(this.commitTarget()).count()).isEqualTo(200L);
        this.sql("UPDATE %s SET id = -1 WHERE id IN (200, 201)", new Object[]{this.commitTarget()});
        Assertions.assertThat((long)spark.table(this.commitTarget()).count()).isEqualTo(200L);
    }

    @TestTemplate
    public void testUpdateNestedStructFields() {
        this.createAndInitTable("id INT, s STRUCT<c1:INT,c2:STRUCT<a:ARRAY<INT>,m:MAP<STRING, STRING>>>", "{ \"id\": 1, \"s\": { \"c1\": 2, \"c2\": { \"a\": [1,2], \"m\": { \"a\": \"b\"} } } } }");
        this.sql("UPDATE %s SET s.c1 = -1, s.c2.m = map('k', 'v'), s.c2.a = array(-1)", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{-1, this.row(new Object[]{ImmutableList.of((Object)-1), ImmutableMap.of((Object)"k", (Object)"v")})})})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET s.c1 = NULL, s.c2 = NULL WHERE id IN (1)", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{null, null})})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET s = named_struct('c1', 1, 'c2', named_struct('a', array(1), 'm', null))", new Object[]{this.commitTarget()});
        this.assertEquals("Output should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{1, this.row(new Object[]{ImmutableList.of((Object)1), null})})})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithUserDefinedDistribution() {
        this.createAndInitTable("id INT, c2 INT, c3 INT");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(8, c3)", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"c2\": 11, \"c3\": 1 }\n{ \"id\": 2, \"c2\": 22, \"c3\": 1 }\n{ \"id\": 3, \"c2\": 33, \"c3\": 1 }");
        this.createBranchIfNeeded();
        this.sql("ALTER TABLE %s WRITE ORDERED BY c2", new Object[]{this.tableName});
        this.sql("UPDATE %s SET c2 = -22 WHERE id NOT IN (1, 3)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, 11, 1}), (Object)this.row(new Object[]{2, -22, 1}), (Object)this.row(new Object[]{3, 33, 1})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("ALTER TABLE %s WRITE LOCALLY ORDERED BY id", new Object[]{this.tableName});
        this.sql("UPDATE %s SET c2 = -33 WHERE id = 3", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, 11, 1}), (Object)this.row(new Object[]{2, -22, 1}), (Object)this.row(new Object[]{3, -33, 1})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION ORDERED BY id", new Object[]{this.tableName});
        this.sql("UPDATE %s SET c2 = -11 WHERE id = 1", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, -11, 1}), (Object)this.row(new Object[]{2, -22, 1}), (Object)this.row(new Object[]{3, -33, 1})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testUpdateWithSerializableIsolation() throws InterruptedException {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualToIgnoringCase((CharSequence)"testhadoop");
        Assumptions.assumeThat((boolean)this.cachingCatalogEnabled()).isTrue();
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.update.isolation-level", "serializable"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> updateFuture = executorService.submit(() -> {
            int numOperations = 0;
            while (numOperations < Integer.MAX_VALUE) {
                int currentNumOperations = numOperations++;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> barrier.get() >= currentNumOperations * 2);
                this.sql("UPDATE %s SET id = -1 WHERE id = 1", new Object[]{this.commitTarget()});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)SnapshotUtil.schemaFor((Table)table, (String)this.branch));
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                int currentNumOperations = numOperations;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> !shouldAppend.get() || barrier.get() >= currentNumOperations * 2);
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                }
                barrier.incrementAndGet();
            }
        });
        try {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(updateFuture::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(ValidationException.class)).hasMessageContaining("Found conflicting files that can contain");
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testUpdateWithSnapshotIsolation() throws InterruptedException, ExecutionException {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualToIgnoringCase((CharSequence)"testhadoop");
        Assumptions.assumeThat((boolean)this.cachingCatalogEnabled()).isTrue();
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.update.isolation-level", "snapshot"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> updateFuture = executorService.submit(() -> {
            int numOperations = 0;
            while (numOperations < 20) {
                int currentNumOperations = numOperations++;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> barrier.get() >= currentNumOperations * 2);
                this.sql("UPDATE %s SET id = -1 WHERE id = 1", new Object[]{this.tableName});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)SnapshotUtil.schemaFor((Table)table, (String)this.branch));
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < 20; ++numOperations) {
                int currentNumOperations = numOperations;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> !shouldAppend.get() || barrier.get() >= currentNumOperations * 2);
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                }
                barrier.incrementAndGet();
            }
        });
        try {
            updateFuture.get();
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testUpdateWithInferredCasts() {
        this.createAndInitTable("id INT, s STRING", "{ \"id\": 1, \"s\": \"value\" }");
        this.sql("UPDATE %s SET s = -1 WHERE id = 1", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "-1"})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateModifiesNullStruct() {
        this.createAndInitTable("id INT, s STRUCT<n1:INT,n2:INT>", "{ \"id\": 1, \"s\": null }");
        this.sql("UPDATE %s SET s.n1 = -1 WHERE id = 1", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, this.row(new Object[]{-1, null})})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateRefreshesRelationCache() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hardware\" }\n{ \"id\": 2, \"dep\": \"hardware\" }");
        Dataset query = spark.sql("SELECT * FROM " + this.commitTarget() + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have correct data", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM tmp ORDER BY id, dep", new Object[0]));
        this.sql("UPDATE %s SET id = -1 WHERE id = 1", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "2", "2", "2");
        } else {
            this.validateMergeOnRead(currentSnapshot, "2", "2", "2");
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.commitTarget()}));
        this.assertEquals("Should refresh the relation cache", (List)ImmutableList.of(), this.sql("SELECT * FROM tmp ORDER BY id, dep", new Object[0]));
        spark.sql("UNCACHE TABLE tmp");
    }

    @TestTemplate
    public void testUpdateWithInSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("updated_id", Arrays.asList(0, 1, null), Encoders.INT());
        this.createOrReplaceView("updated_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("UPDATE %s SET id = -1 WHERE id IN (SELECT * FROM updated_id) AND dep IN (SELECT * from updated_dep)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = 5 WHERE id IS NULL OR id IN (SELECT value + 1 FROM updated_id)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{5, "hardware"}), (Object)this.row(new Object[]{5, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
        this.append(this.commitTarget(), "{ \"id\": null, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{5, "hardware"}), (Object)this.row(new Object[]{5, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST, dep", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = 10 WHERE id IN (SELECT value + 2 FROM updated_id) AND dep = 'hr'", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{5, "hardware"}), (Object)this.row(new Object[]{5, "hr"}), (Object)this.row(new Object[]{10, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithInSubqueryAndDynamicFileFiltering() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hardware\" }\n{ \"id\": 2, \"dep\": \"hardware\" }");
        this.createOrReplaceView("updated_id", Arrays.asList(-1, 2), Encoders.INT());
        this.sql("UPDATE %s SET id = -1 WHERE id IN (SELECT * FROM updated_id)", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", "1");
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.commitTarget()}));
    }

    @TestTemplate
    public void testUpdateWithSelfSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.sql("UPDATE %s SET dep = 'x' WHERE id IN (SELECT id + 1 FROM %s)", new Object[]{this.commitTarget(), this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "x"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"false"), () -> {
            this.sql("UPDATE %s SET dep = 'y' WHERE id = (SELECT count(*) FROM (SELECT DISTINCT id FROM %s) AS t)", new Object[]{this.commitTarget(), this.commitTarget()});
            this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "y"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        });
        this.sql("UPDATE %s SET id = (SELECT id - 2 FROM %s WHERE id = 1)", new Object[]{this.commitTarget(), this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{-1, "y"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithMultiColumnInSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        List<Employee> deletedEmployees = Arrays.asList(new Employee(null, "hr"), new Employee(1, "hr"));
        this.createOrReplaceView("deleted_employee", deletedEmployees, Encoders.bean(Employee.class));
        this.sql("UPDATE %s SET dep = 'x', id = -1 WHERE (id, dep) IN (SELECT id, dep FROM deleted_employee)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "x"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithNotInSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("updated_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("updated_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("UPDATE %s SET id = -1 WHERE id NOT IN (SELECT * FROM updated_id)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = -1 WHERE id NOT IN (SELECT * FROM updated_id WHERE value IS NOT NULL)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST, dep", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = 5 WHERE id NOT IN (SELECT * FROM updated_id) OR dep IN ('software', 'hr')", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{5, "hr"}), (Object)this.row(new Object[]{5, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithExistSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("updated_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("updated_dep", Arrays.asList("hr", null), Encoders.STRING());
        this.sql("UPDATE %s t SET id = -1 WHERE EXISTS (SELECT 1 FROM updated_id u WHERE t.id = u.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s t SET dep = 'x', id = -1 WHERE EXISTS (SELECT 1 FROM updated_id u WHERE t.id = u.value + 2)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "x"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s t SET id = -2 WHERE EXISTS (SELECT 1 FROM updated_id u WHERE t.id = u.value) OR t.id IS NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-2, "hr"}), (Object)this.row(new Object[]{-2, "x"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s t SET id = 1 WHERE EXISTS (SELECT 1 FROM updated_id ui WHERE t.id = ui.value) AND EXISTS (SELECT 1 FROM updated_dep ud WHERE t.dep = ud.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-2, "x"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithNotExistsSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("updated_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("updated_dep", Arrays.asList("hr", "software"), Encoders.STRING());
        this.sql("UPDATE %s t SET id = -1 WHERE NOT EXISTS (SELECT 1 FROM updated_id u WHERE t.id = u.value + 2)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s t SET id = 5 WHERE NOT EXISTS (SELECT 1 FROM updated_id u WHERE t.id = u.value) OR t.id = 1", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{5, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s t SET id = 10 WHERE NOT EXISTS (SELECT 1 FROM updated_id ui WHERE t.id = ui.value) AND EXISTS (SELECT 1 FROM updated_dep ud WHERE t.dep = ud.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hardware"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{10, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithScalarSubquery() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hardware\" }\n{ \"id\": null, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("updated_id", Arrays.asList(1, 100, null), Encoders.INT());
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"false"), () -> {
            this.sql("UPDATE %s SET id = -1 WHERE id <= (SELECT min(value) FROM updated_id)", new Object[]{this.commitTarget()});
            this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        });
    }

    @TestTemplate
    public void testUpdateThatRequiresGroupingBeforeWrite() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 0, \"dep\": \"hr\" }\n{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 0, \"dep\": \"ops\" }\n{ \"id\": 1, \"dep\": \"ops\" }\n{ \"id\": 2, \"dep\": \"ops\" }");
        this.append(this.commitTarget(), "{ \"id\": 0, \"dep\": \"hr\" }\n{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.append(this.commitTarget(), "{ \"id\": 0, \"dep\": \"ops\" }\n{ \"id\": 1, \"dep\": \"ops\" }\n{ \"id\": 2, \"dep\": \"ops\" }");
        this.createOrReplaceView("updated_id", Arrays.asList(1, 100), Encoders.INT());
        String originalNumOfShufflePartitions = spark.conf().get("spark.sql.shuffle.partitions");
        try {
            spark.conf().set("spark.sql.shuffle.partitions", "1");
            this.sql("UPDATE %s t SET id = -1 WHERE id IN (SELECT * FROM updated_id)", new Object[]{this.commitTarget()});
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.commitTarget()).count()).as("Should have expected num of rows", new Object[0])).isEqualTo(12L);
        }
        finally {
            spark.conf().set("spark.sql.shuffle.partitions", originalNumOfShufflePartitions);
        }
    }

    @TestTemplate
    public void testUpdateWithVectorization() {
        this.createAndInitTable("id INT, dep STRING");
        this.append(this.tableName, "{ \"id\": 0, \"dep\": \"hr\" }\n{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.sql.iceberg.vectorization.enabled", (Object)"true"), () -> {
            this.sql("UPDATE %s t SET id = -1", new Object[]{this.commitTarget()});
            this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{-1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
        });
    }

    @TestTemplate
    public void testUpdateModifyPartitionSourceField() throws NoSuchTableException {
        this.createAndInitTable("id INT, dep STRING, country STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(4, id)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        ArrayList ids = Lists.newArrayListWithCapacity((int)100);
        for (int id = 1; id <= 100; ++id) {
            ids.add(id);
        }
        Dataset df1 = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"hr")).withColumn("country", functions.lit((Object)"usa"));
        df1.coalesce(1).writeTo(this.tableName).append();
        this.createBranchIfNeeded();
        Dataset df2 = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"software")).withColumn("country", functions.lit((Object)"usa"));
        df2.coalesce(1).writeTo(this.commitTarget()).append();
        Dataset df3 = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"hardware")).withColumn("country", functions.lit((Object)"usa"));
        df3.coalesce(1).writeTo(this.commitTarget()).append();
        this.sql("UPDATE %s SET id = -1 WHERE id IN (10, 11, 12, 13, 14, 15, 16, 17, 18, 19)", new Object[]{this.commitTarget()});
        Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s WHERE id = -1", new Object[]{this.selectTarget()})).isEqualTo((Object)30L);
    }

    @TestTemplate
    public void testUpdateWithStaticPredicatePushdown() {
        this.createAndInitTable("id INT, dep STRING");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"software\" }");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hr\" }");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String dataFilesCount = (String)snapshot.summary().get("total-data-files");
        ((AbstractStringAssert)Assertions.assertThat((String)dataFilesCount).as("Must have 2 files before UPDATE", new Object[0])).isEqualTo("2");
        DataFile dataFile = (DataFile)Iterables.getOnlyElement((Iterable)snapshot.addedDataFiles(table.io()));
        table.io().deleteFile(dataFile.path().toString());
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.DYNAMIC_PARTITION_PRUNING_ENABLED().key(), (Object)"false", (Object)SQLConf.RUNTIME_ROW_LEVEL_OPERATION_GROUP_FILTER_ENABLED().key(), (Object)"false"), () -> this.sql("UPDATE %s SET id = -1 WHERE dep IN ('software') AND id == 1", new Object[]{this.commitTarget()}));
    }

    @TestTemplate
    public void testUpdateWithInvalidUpdates() {
        this.createAndInitTable("id INT, a ARRAY<STRUCT<c1:INT,c2:INT>>, m MAP<STRING,STRING>", "{ \"id\": 0, \"a\": null, \"m\": null }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET a.c1 = 1", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Updating nested fields is only supported for StructType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET m.key = 'new_key'", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Updating nested fields is only supported for StructType");
    }

    @TestTemplate
    public void testUpdateWithConflictingAssignments() {
        this.createAndInitTable("id INT, c STRUCT<n1:INT,n2:STRUCT<dn1:INT,dn2:INT>>", "{ \"id\": 0, \"s\": null }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.id = 1, t.c.n1 = 2, t.id = 2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Multiple assignments for 'id'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.c.n1 = 1, t.id = 2, t.c.n1 = 2", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Multiple assignments for 'c.n1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET c.n1 = 1, c = named_struct('n1', 1, 'n2', named_struct('dn1', 1, 'dn2', 2))", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Conflicting assignments for 'c'");
    }

    @TestTemplate
    public void testUpdateWithInvalidAssignmentsAnsi() {
        this.createAndInitTable("id INT NOT NULL, s STRUCT<n1:INT NOT NULL,n2:STRUCT<dn1:INT,dn2:INT>> NOT NULL", "{ \"id\": 0, \"s\": { \"n1\": 1, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.sql.storeAssignmentPolicy", (Object)"ansi"), () -> {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.id = NULL", new Object[]{this.commitTarget()})).isInstanceOf(SparkException.class)).hasMessageContaining("Null value appeared in non-nullable field");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s.n1 = NULL", new Object[]{this.commitTarget()})).isInstanceOf(SparkException.class)).hasMessageContaining("Null value appeared in non-nullable field");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s = named_struct('n1', 1)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column `s`.`n2`");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s.n1 = 'str'", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot safely cast");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s.n2 = named_struct('dn3', 1, 'dn1', 2)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column `s`.`n2`.`dn2`");
        });
    }

    @TestTemplate
    public void testUpdateWithInvalidAssignmentsStrict() {
        this.createAndInitTable("id INT NOT NULL, s STRUCT<n1:INT NOT NULL,n2:STRUCT<dn1:INT,dn2:INT>> NOT NULL", "{ \"id\": 0, \"s\": { \"n1\": 1, \"n2\": { \"dn1\": 3, \"dn2\": 4 } } }");
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.sql.storeAssignmentPolicy", (Object)"strict"), () -> {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.id = NULL", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot safely cast `id` \"VOID\" to \"INT\"");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s.n1 = NULL", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot safely cast `s`.`n1` \"VOID\" to \"INT\"");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s = named_struct('n1', 1)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s.n1 = 'str'", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot safely cast");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s t SET t.s.n2 = named_struct('dn3', 1, 'dn1', 2)", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot find data for the output column");
        });
    }

    @TestTemplate
    public void testUpdateWithNonDeterministicCondition() {
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"hr\" }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET id = -1 WHERE id = 1 AND rand() > 0.5", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The operator expects a deterministic expression");
    }

    @TestTemplate
    public void testUpdateOnNonIcebergTableNotSupported() {
        this.createOrReplaceView("testtable", "{ \"c1\": -100, \"c2\": -200 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET c1 = -1 WHERE c2 = 1", new Object[]{"testtable"})).isInstanceOf(UnsupportedOperationException.class)).hasMessage("UPDATE TABLE is not supported temporarily.");
    }

    @TestTemplate
    public void testUpdateToWAPBranch() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("WAP branch only works for table identifier without branch", new Object[0])).isNull();
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"a\" }");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> {
            this.sql("UPDATE %s SET dep='hr' WHERE dep='a'", new Object[]{this.tableName});
            ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s WHERE dep='hr'", new Object[]{this.tableName})).as("Should have expected num of rows when reading table", new Object[0])).hasSize(2);
            ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.branch_wap WHERE dep='hr'", new Object[]{this.tableName})).as("Should have expected num of rows when reading WAP branch", new Object[0])).hasSize(2);
            ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.branch_main WHERE dep='hr'", new Object[]{this.tableName})).as("Should not modify main branch", new Object[0])).hasSize(1);
        });
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> {
            this.sql("UPDATE %s SET dep='b' WHERE dep='hr'", new Object[]{this.tableName});
            ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s WHERE dep='b'", new Object[]{this.tableName})).as("Should have expected num of rows when reading table with multiple writes", new Object[0])).hasSize(2);
            ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.branch_wap WHERE dep='b'", new Object[]{this.tableName})).as("Should have expected num of rows when reading WAP branch with multiple writes", new Object[0])).hasSize(2);
            ((ListAssert)Assertions.assertThat((List)this.sql("SELECT * FROM %s.branch_main WHERE dep='b'", new Object[]{this.tableName})).as("Should not modify main branch with multiple writes", new Object[0])).hasSize(0);
        });
    }

    @TestTemplate
    public void testUpdateToWapBranchWithTableBranchIdentifier() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Test must have branch name part in table identifier", new Object[0])).isNotNull();
        this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"hr\" }");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("UPDATE %s SET dep='hr' WHERE dep='a'", new Object[]{this.commitTarget()})).isInstanceOf(ValidationException.class)).hasMessage(String.format("Cannot write to both branch and WAP branch, but got branch [%s] and WAP branch [wap]", this.branch)));
    }

    private RowLevelOperationMode mode(Table table) {
        String modeName = table.properties().getOrDefault("write.update.mode", TableProperties.UPDATE_MODE_DEFAULT);
        return RowLevelOperationMode.fromName((String)modeName);
    }
}

