/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.ResolvedIdentifier;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.AlterViewAs;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.views.CreateIcebergView;
import org.apache.spark.sql.catalyst.plans.logical.views.ResolvedV2View;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.ViewCatalog;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class CheckViews$
implements Function1<LogicalPlan, BoxedUnit> {
    public static CheckViews$ MODULE$;

    static {
        new CheckViews$();
    }

    public boolean apply$mcZD$sp(double v1) {
        return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
    }

    public double apply$mcDD$sp(double v1) {
        return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
    }

    public float apply$mcFD$sp(double v1) {
        return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
    }

    public int apply$mcID$sp(double v1) {
        return Function1.apply$mcID$sp$((Function1)this, (double)v1);
    }

    public long apply$mcJD$sp(double v1) {
        return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
    }

    public void apply$mcVD$sp(double v1) {
        Function1.apply$mcVD$sp$((Function1)this, (double)v1);
    }

    public boolean apply$mcZF$sp(float v1) {
        return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
    }

    public double apply$mcDF$sp(float v1) {
        return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
    }

    public float apply$mcFF$sp(float v1) {
        return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
    }

    public int apply$mcIF$sp(float v1) {
        return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
    }

    public long apply$mcJF$sp(float v1) {
        return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
    }

    public void apply$mcVF$sp(float v1) {
        Function1.apply$mcVF$sp$((Function1)this, (float)v1);
    }

    public boolean apply$mcZI$sp(int v1) {
        return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
    }

    public double apply$mcDI$sp(int v1) {
        return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
    }

    public float apply$mcFI$sp(int v1) {
        return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
    }

    public int apply$mcII$sp(int v1) {
        return Function1.apply$mcII$sp$((Function1)this, (int)v1);
    }

    public long apply$mcJI$sp(int v1) {
        return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
    }

    public void apply$mcVI$sp(int v1) {
        Function1.apply$mcVI$sp$((Function1)this, (int)v1);
    }

    public boolean apply$mcZJ$sp(long v1) {
        return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
    }

    public double apply$mcDJ$sp(long v1) {
        return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
    }

    public float apply$mcFJ$sp(long v1) {
        return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
    }

    public int apply$mcIJ$sp(long v1) {
        return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
    }

    public long apply$mcJJ$sp(long v1) {
        return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
    }

    public void apply$mcVJ$sp(long v1) {
        Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
    }

    public <A> Function1<A, BoxedUnit> compose(Function1<A, LogicalPlan> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<LogicalPlan, A> andThen(Function1<BoxedUnit, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    public String toString() {
        return Function1.toString$((Function1)this);
    }

    public void apply(LogicalPlan plan) {
        plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CheckViews$.$anonfun$apply$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyColumnCount(ResolvedIdentifier ident, Seq<String> columns, LogicalPlan query) {
        if (columns.nonEmpty()) {
            if (columns.length() > query.output().length()) {
                throw new AnalysisException("CREATE_VIEW_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)String.format("%s.%s", ident.catalog().name(), ident.identifier())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewColumns"), (Object)columns.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)((TraversableOnce)query.output().map((Function1 & Serializable & scala.Serializable)c -> c.name(), Seq$.MODULE$.canBuildFrom())).mkString(", "))})));
            }
            if (columns.length() < query.output().length()) {
                throw new AnalysisException("CREATE_VIEW_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)String.format("%s.%s", ident.catalog().name(), ident.identifier())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewColumns"), (Object)columns.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)((TraversableOnce)query.output().map((Function1 & Serializable & scala.Serializable)c -> c.name(), Seq$.MODULE$.canBuildFrom())).mkString(", "))})));
            }
            return;
        }
    }

    private void checkCyclicViewReference(Seq<String> viewIdent, LogicalPlan plan, Seq<Seq<String>> cyclePath) {
        SubqueryAlias subqueryAlias;
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof SubqueryAlias && (logicalPlan = (subqueryAlias = (SubqueryAlias)logicalPlan2).child()) instanceof Project) {
            Seq currentViewIdent = (Seq)subqueryAlias.identifier().qualifier().$colon$plus((Object)subqueryAlias.identifier().name(), Seq$.MODULE$.canBuildFrom());
            this.checkIfRecursiveView(viewIdent, (Seq<String>)currentViewIdent, cyclePath, (Seq<LogicalPlan>)subqueryAlias.children());
        } else if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            Seq currentViewIdent = view.desc().identifier().nameParts();
            this.checkIfRecursiveView(viewIdent, (Seq<String>)currentViewIdent, cyclePath, (Seq<LogicalPlan>)view.children());
        } else {
            plan.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                CheckViews$.MODULE$.checkCyclicViewReference((Seq<String>)viewIdent, child, (Seq<Seq<String>>)cyclePath);
                return BoxedUnit.UNIT;
            });
        }
        plan.expressions().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof SubqueryExpression) {
                SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                MODULE$.checkCyclicViewReference(viewIdent, (LogicalPlan)subqueryExpression.plan(), cyclePath);
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }), Seq$.MODULE$.canBuildFrom());
    }

    private void checkIfRecursiveView(Seq<String> viewIdent, Seq<String> currentViewIdent, Seq<Seq<String>> cyclePath, Seq<LogicalPlan> children) {
        Seq newCyclePath = (Seq)cyclePath.$colon$plus(currentViewIdent, Seq$.MODULE$.canBuildFrom());
        Seq<String> seq = currentViewIdent;
        Seq<String> seq2 = viewIdent;
        if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
            throw new AnalysisException(String.format("Recursive cycle in view detected: %s (cycle: %s)", CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(viewIdent).asIdentifier(), ((TraversableOnce)newCyclePath.map((Function1 & Serializable & scala.Serializable)p -> p.mkString("."), Seq$.MODULE$.canBuildFrom())).mkString(" -> ")), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        children.foreach((Function1 & Serializable & scala.Serializable)c -> {
            CheckViews$.MODULE$.checkCyclicViewReference((Seq<String>)viewIdent, c, (Seq<Seq<String>>)newCyclePath);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(LogicalPlan x0$1) {
        AlterViewAs alterViewAs;
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof CreateIcebergView) {
            ResolvedIdentifier resolvedIdentifier;
            CreateIcebergView createIcebergView = (CreateIcebergView)logicalPlan2;
            LogicalPlan resolvedIdent = createIcebergView.child();
            LogicalPlan query = createIcebergView.query();
            Seq<String> columnAliases = createIcebergView.columnAliases();
            boolean replace = createIcebergView.replace();
            if (resolvedIdent instanceof ResolvedIdentifier && (resolvedIdentifier = (ResolvedIdentifier)resolvedIdent).catalog() instanceof ViewCatalog) {
                MODULE$.verifyColumnCount(resolvedIdentifier, columnAliases, query);
                SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])query.schema().fieldNames()), SQLConf$.MODULE$.get().resolver());
                if (replace) {
                    String string = resolvedIdentifier.catalog().name();
                    Seq viewIdent = (Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(resolvedIdentifier.identifier()).asMultipartIdentifier().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
                    MODULE$.checkCyclicViewReference((Seq<String>)viewIdent, query, (Seq<Seq<String>>)((Seq)new .colon.colon((Object)viewIdent, (List)Nil$.MODULE$)));
                    return;
                }
                return;
            }
        }
        if (logicalPlan2 instanceof AlterViewAs && (logicalPlan = (alterViewAs = (AlterViewAs)logicalPlan2).child()) instanceof ResolvedV2View) {
            throw new AnalysisException("ALTER VIEW <viewName> AS is not supported. Use CREATE OR REPLACE VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
    }

    private CheckViews$() {
        MODULE$ = this;
        Function1.$init$((Function1)this);
    }
}

