/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SystemFunctionPushDownHelper;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.PlanUtils;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.ApplyFunctionExpression;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSystemFunctionPushDownDQL
extends ExtensionsTestBase {
    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties()}};
    }

    @BeforeEach
    public void before() {
        super.before();
        this.sql("USE %s", new Object[]{this.catalogName});
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testYearsFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testYearsFunction(false);
    }

    @TestTemplate
    public void testYearsFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"years(ts)");
        this.testYearsFunction(true);
    }

    private void testYearsFunction(boolean partitioned) {
        int targetYears = SystemFunctionPushDownHelper.timestampStrToYearOrdinal((String)"2017-11-22T00:00:00.000000+00:00");
        String query = String.format("SELECT * FROM %s WHERE system.years(ts) = %s ORDER BY id", this.tableName, targetYears);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "years");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.equal((UnboundTerm)Expressions.year((String)"ts"), (Object)targetYears));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(5);
    }

    @TestTemplate
    public void testMonthsFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testMonthsFunction(false);
    }

    @TestTemplate
    public void testMonthsFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"months(ts)");
        this.testMonthsFunction(true);
    }

    private void testMonthsFunction(boolean partitioned) {
        int targetMonths = SystemFunctionPushDownHelper.timestampStrToMonthOrdinal((String)"2017-11-22T00:00:00.000000+00:00");
        String query = String.format("SELECT * FROM %s WHERE system.months(ts) > %s ORDER BY id", this.tableName, targetMonths);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "months");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.greaterThan((UnboundTerm)Expressions.month((String)"ts"), (Object)targetMonths));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(5);
    }

    @TestTemplate
    public void testDaysFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testDaysFunction(false);
    }

    @TestTemplate
    public void testDaysFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"days(ts)");
        this.testDaysFunction(true);
    }

    private void testDaysFunction(boolean partitioned) {
        String timestamp = "2018-11-20T00:00:00.000000+00:00";
        int targetDays = SystemFunctionPushDownHelper.timestampStrToDayOrdinal((String)timestamp);
        String query = String.format("SELECT * FROM %s WHERE system.days(ts) < date('%s') ORDER BY id", this.tableName, timestamp);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "days");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.lessThan((UnboundTerm)Expressions.day((String)"ts"), (Object)targetDays));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(5);
    }

    @TestTemplate
    public void testHoursFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testHoursFunction(false);
    }

    @TestTemplate
    public void testHoursFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"hours(ts)");
        this.testHoursFunction(true);
    }

    private void testHoursFunction(boolean partitioned) {
        int targetHours = SystemFunctionPushDownHelper.timestampStrToHourOrdinal((String)"2017-11-22T06:02:09.243857+00:00");
        String query = String.format("SELECT * FROM %s WHERE system.hours(ts) >= %s ORDER BY id", this.tableName, targetHours);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "hours");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.greaterThanOrEqual((UnboundTerm)Expressions.hour((String)"ts"), (Object)targetHours));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(8);
    }

    @TestTemplate
    public void testBucketLongFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testBucketLongFunction(false);
    }

    @TestTemplate
    public void testBucketLongFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"bucket(5, id)");
        this.testBucketLongFunction(true);
    }

    private void testBucketLongFunction(boolean partitioned) {
        int target = 2;
        String query = String.format("SELECT * FROM %s WHERE system.bucket(5, id) <= %s ORDER BY id", this.tableName, target);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "bucket");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.lessThanOrEqual((UnboundTerm)Expressions.bucket((String)"id", (int)5), (Object)target));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(5);
    }

    @TestTemplate
    public void testBucketStringFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testBucketStringFunction(false);
    }

    @TestTemplate
    public void testBucketStringFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"bucket(5, data)");
        this.testBucketStringFunction(true);
    }

    private void testBucketStringFunction(boolean partitioned) {
        int target = 2;
        String query = String.format("SELECT * FROM %s WHERE system.bucket(5, data) != %s ORDER BY id", this.tableName, target);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "bucket");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.notEqual((UnboundTerm)Expressions.bucket((String)"data", (int)5), (Object)target));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(8);
    }

    @TestTemplate
    public void testTruncateFunctionOnUnpartitionedTable() {
        SystemFunctionPushDownHelper.createUnpartitionedTable((SparkSession)spark, (String)this.tableName);
        this.testTruncateFunction(false);
    }

    @TestTemplate
    public void testTruncateFunctionOnPartitionedTable() {
        SystemFunctionPushDownHelper.createPartitionedTable((SparkSession)spark, (String)this.tableName, (String)"truncate(4, data)");
        this.testTruncateFunction(true);
    }

    private void testTruncateFunction(boolean partitioned) {
        String target = "data";
        String query = String.format("SELECT * FROM %s WHERE system.truncate(4, data) = '%s' ORDER BY id", this.tableName, target);
        Dataset df = spark.sql(query);
        LogicalPlan optimizedPlan = df.queryExecution().optimizedPlan();
        this.checkExpressions(optimizedPlan, partitioned, "truncate");
        this.checkPushedFilters(optimizedPlan, (Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"data", (int)4), (Object)target));
        List actual = this.rowsToJava(df.collectAsList());
        Assertions.assertThat((List)actual).hasSize(5);
    }

    private void checkExpressions(LogicalPlan optimizedPlan, boolean partitioned, String expectedFunctionName) {
        List<org.apache.spark.sql.catalyst.expressions.Expression> staticInvokes = PlanUtils.collectSparkExpressions(optimizedPlan, expression -> expression instanceof StaticInvoke);
        Assertions.assertThat(staticInvokes).isEmpty();
        List<org.apache.spark.sql.catalyst.expressions.Expression> applyExpressions = PlanUtils.collectSparkExpressions(optimizedPlan, expression -> expression instanceof ApplyFunctionExpression);
        if (partitioned) {
            Assertions.assertThat(applyExpressions).isEmpty();
        } else {
            Assertions.assertThat(applyExpressions).hasSize(1);
            ApplyFunctionExpression expression2 = (ApplyFunctionExpression)applyExpressions.get(0);
            Assertions.assertThat((String)expression2.name()).isEqualTo(expectedFunctionName);
        }
    }

    private void checkPushedFilters(LogicalPlan optimizedPlan, Expression expected) {
        List<Expression> pushedFilters = PlanUtils.collectPushDownFilters(optimizedPlan);
        Assertions.assertThat(pushedFilters).hasSize(1);
        Expression actual = pushedFilters.get(0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ExpressionUtil.equivalent((Expression)expected, (Expression)actual, (Types.StructType)SystemFunctionPushDownHelper.STRUCT, (boolean)true)).as("Pushed filter should match", new Object[0])).isTrue();
    }
}

