/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class PlanUtils {
    private PlanUtils() {
    }

    public static List<Expression> collectPushDownFilters(LogicalPlan logicalPlan) {
        return JavaConverters.asJavaCollection((Iterable)logicalPlan.collectLeaves()).stream().flatMap(plan -> {
            if (!(plan instanceof DataSourceV2ScanRelation)) {
                return Stream.empty();
            }
            DataSourceV2ScanRelation scanRelation = (DataSourceV2ScanRelation)plan;
            if (!(scanRelation.scan() instanceof SparkBatchQueryScan)) {
                return Stream.empty();
            }
            SparkBatchQueryScan batchQueryScan = (SparkBatchQueryScan)scanRelation.scan();
            return batchQueryScan.filterExpressions().stream();
        }).collect(Collectors.toList());
    }

    public static List<org.apache.spark.sql.catalyst.expressions.Expression> collectSparkExpressions(LogicalPlan logicalPlan, final Predicate<org.apache.spark.sql.catalyst.expressions.Expression> predicate) {
        Seq list = logicalPlan.collect((PartialFunction)new PartialFunction<LogicalPlan, List<org.apache.spark.sql.catalyst.expressions.Expression>>(){

            public List<org.apache.spark.sql.catalyst.expressions.Expression> apply(LogicalPlan plan) {
                return JavaConverters.asJavaCollection((Iterable)plan.expressions()).stream().flatMap(expr -> PlanUtils.collectSparkExpressions(expr, (Predicate<org.apache.spark.sql.catalyst.expressions.Expression>)predicate).stream()).collect(Collectors.toList());
            }

            public boolean isDefinedAt(LogicalPlan plan) {
                return true;
            }
        });
        return JavaConverters.asJavaCollection((Iterable)list).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<org.apache.spark.sql.catalyst.expressions.Expression> collectSparkExpressions(org.apache.spark.sql.catalyst.expressions.Expression expression, final Predicate<org.apache.spark.sql.catalyst.expressions.Expression> predicate) {
        Seq list = expression.collect((PartialFunction)new PartialFunction<org.apache.spark.sql.catalyst.expressions.Expression, org.apache.spark.sql.catalyst.expressions.Expression>(){

            public org.apache.spark.sql.catalyst.expressions.Expression apply(org.apache.spark.sql.catalyst.expressions.Expression expr) {
                return expr;
            }

            public boolean isDefinedAt(org.apache.spark.sql.catalyst.expressions.Expression expr) {
                return predicate.test(expr);
            }
        });
        return Lists.newArrayList((java.lang.Iterable)JavaConverters.asJavaCollection((Iterable)list));
    }
}

