/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.TagOptions;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.CreateOrReplaceTagExec$;
import org.apache.spark.sql.execution.datasources.v2.LeafV2CommandExec;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple7;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001\u0002\u0015*\u0001bB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t%\u0002\u0011\t\u0012)A\u0005\u0017\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011B.\t\u0011\u001d\u0004!Q3A\u0005\u0002!D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\ti\u0002\u0011)\u001a!C\u0001k\"A\u0011\u0010\u0001B\tB\u0003%a\u000f\u0003\u0005{\u0001\tU\r\u0011\"\u0001v\u0011!Y\bA!E!\u0002\u00131\b\u0002\u0003?\u0001\u0005+\u0007I\u0011A;\t\u0011u\u0004!\u0011#Q\u0001\nYDQA \u0001\u0005\u0002}D!\"!\u0005\u0001\u0011\u000b\u0007I\u0011IA\n\u0011\u001d\t\u0019\u0004\u0001C)\u0003kAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011\u0011\r\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"a \u0001#\u0003%\t!!!\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005\"CAF\u0001E\u0005I\u0011AAG\u0011%\t\t\nAI\u0001\n\u0003\ti\tC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0001\u0002\u000e\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003SC\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005e\u0006!!A\u0005B\u0005m\u0006\"CAe\u0001\u0005\u0005I\u0011AAf\u0011%\ty\rAA\u0001\n\u0003\n\tnB\u0005\u0002V&\n\t\u0011#\u0001\u0002X\u001aA\u0001&KA\u0001\u0012\u0003\tI\u000e\u0003\u0004\u007fE\u0011\u0005\u0011q\u001d\u0005\n\u0003S\u0014\u0013\u0011!C#\u0003WD\u0011\"!<#\u0003\u0003%\t)a<\t\u0013\u0005}(%!A\u0005\u0002\n\u0005\u0001\"\u0003B\nE\u0005\u0005I\u0011\u0002B\u000b\u0005Y\u0019%/Z1uK>\u0013(+\u001a9mC\u000e,G+Y4Fq\u0016\u001c'B\u0001\u0016,\u0003\t1(G\u0003\u0002-[\u0005YA-\u0019;bg>,(oY3t\u0015\tqs&A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M)\u0001!O\u001fA\rB\u0011!hO\u0007\u0002S%\u0011A(\u000b\u0002\u000e-J\u001au.\\7b]\u0012,\u00050Z2\u0011\u0005ir\u0014BA *\u0005EaU-\u00194We\r{W.\\1oI\u0016CXm\u0019\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\b!J|G-^2u!\t\tu)\u0003\u0002I\u0005\na1+\u001a:jC2L'0\u00192mK\u000691-\u0019;bY><W#A&\u0011\u00051\u0003V\"A'\u000b\u0005%s%BA(0\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002R\u001b\naA+\u00192mK\u000e\u000bG/\u00197pO\u0006A1-\u0019;bY><\u0007%A\u0003jI\u0016tG/F\u0001V!\tae+\u0003\u0002X\u001b\nQ\u0011\nZ3oi&4\u0017.\u001a:\u0002\r%$WM\u001c;!\u0003\r!\u0018mZ\u000b\u00027B\u0011Al\u0019\b\u0003;\u0006\u0004\"A\u0018\"\u000e\u0003}S!\u0001Y\u001c\u0002\rq\u0012xn\u001c;?\u0013\t\u0011')\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012C\u0003\u0011!\u0018m\u001a\u0011\u0002\u0015Q\fwm\u00149uS>t7/F\u0001j!\tQ\u0017/D\u0001l\u0015\taW.A\u0004m_\u001eL7-\u00197\u000b\u00059|\u0017!\u00029mC:\u001c(B\u000190\u0003!\u0019\u0017\r^1msN$\u0018B\u0001:l\u0005)!\u0016mZ(qi&|gn]\u0001\fi\u0006<w\n\u001d;j_:\u001c\b%\u0001\u0004de\u0016\fG/Z\u000b\u0002mB\u0011\u0011i^\u0005\u0003q\n\u0013qAQ8pY\u0016\fg.A\u0004de\u0016\fG/\u001a\u0011\u0002\u000fI,\u0007\u000f\\1dK\u0006A!/\u001a9mC\u000e,\u0007%A\u0006jM:{G/\u0012=jgR\u001c\u0018\u0001D5g\u001d>$X\t_5tiN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\t\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010A\u0011!\b\u0001\u0005\u0006\u0013>\u0001\ra\u0013\u0005\u0006'>\u0001\r!\u0016\u0005\u00063>\u0001\ra\u0017\u0005\u0006O>\u0001\r!\u001b\u0005\u0006i>\u0001\rA\u001e\u0005\u0006u>\u0001\rA\u001e\u0005\u0006y>\u0001\rA^\u0001\u0007_V$\b/\u001e;\u0016\u0005\u0005U\u0001CBA\f\u0003C\t9C\u0004\u0003\u0002\u001a\u0005uab\u00010\u0002\u001c%\t1)C\u0002\u0002 \t\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"aA*fc*\u0019\u0011q\u0004\"\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fp\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005E\u00121\u0006\u0002\n\u0003R$(/\u001b2vi\u0016\f1A];o)\t\t9\u0004\u0005\u0004\u0002\u0018\u0005\u0005\u0012\u0011\b\t\u0005\u0003w\ti$D\u0001p\u0013\r\tyd\u001c\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007tS6\u0004H.Z*ue&tw\rF\u0002\\\u0003\u000bBq!a\u0012\u0013\u0001\u0004\tI%A\u0005nCb4\u0015.\u001a7egB\u0019\u0011)a\u0013\n\u0007\u00055#IA\u0002J]R\fAaY8qsR\u0001\u0012\u0011AA*\u0003+\n9&!\u0017\u0002\\\u0005u\u0013q\f\u0005\b\u0013N\u0001\n\u00111\u0001L\u0011\u001d\u00196\u0003%AA\u0002UCq!W\n\u0011\u0002\u0003\u00071\fC\u0004h'A\u0005\t\u0019A5\t\u000fQ\u001c\u0002\u0013!a\u0001m\"9!p\u0005I\u0001\u0002\u00041\bb\u0002?\u0014!\u0003\u0005\rA^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)GK\u0002L\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\u0012\u0015AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiHK\u0002V\u0003O\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0004*\u001a1,a\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0012\u0016\u0004S\u0006\u001d\u0014AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003\u001fS3A^A4\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0003mC:<'BAAR\u0003\u0011Q\u0017M^1\n\u0007\u0011\fi*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002J\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAX\u0003k\u00032!QAY\u0013\r\t\u0019L\u0011\u0002\u0004\u0003:L\b\"CA\\;\u0005\u0005\t\u0019AA%\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0018\t\u0007\u0003\u007f\u000b)-a,\u000e\u0005\u0005\u0005'bAAb\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0017\u0011\u0019\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002w\u0003\u001bD\u0011\"a. \u0003\u0003\u0005\r!a,\u0002\r\u0015\fX/\u00197t)\r1\u00181\u001b\u0005\n\u0003o\u0003\u0013\u0011!a\u0001\u0003_\u000bac\u0011:fCR,wJ\u001d*fa2\f7-\u001a+bO\u0016CXm\u0019\t\u0003u\t\u001aBAIAn\rBi\u0011Q\\Ar\u0017V[\u0016N\u001e<w\u0003\u0003i!!a8\u000b\u0007\u0005\u0005()A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0018q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:<DCAAl\u0003!!xn\u0015;sS:<GCAAM\u0003\u0015\t\u0007\u000f\u001d7z)A\t\t!!=\u0002t\u0006U\u0018q_A}\u0003w\fi\u0010C\u0003JK\u0001\u00071\nC\u0003TK\u0001\u0007Q\u000bC\u0003ZK\u0001\u00071\fC\u0003hK\u0001\u0007\u0011\u000eC\u0003uK\u0001\u0007a\u000fC\u0003{K\u0001\u0007a\u000fC\u0003}K\u0001\u0007a/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r!q\u0002\t\u0006\u0003\n\u0015!\u0011B\u0005\u0004\u0005\u000f\u0011%AB(qi&|g\u000e\u0005\u0006B\u0005\u0017YUkW5wmZL1A!\u0004C\u0005\u0019!V\u000f\u001d7fo!I!\u0011\u0003\u0014\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0006\u0011\t\u0005m%\u0011D\u0005\u0005\u00057\tiJ\u0001\u0004PE*,7\r\u001e")
public class CreateOrReplaceTagExec
extends V2CommandExec
implements LeafV2CommandExec {
    private Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier ident;
    private final String tag;
    private final TagOptions tagOptions;
    private final boolean create;
    private final boolean replace;
    private final boolean ifNotExists;
    private volatile boolean bitmap$0;

    public static Option<Tuple7<TableCatalog, Identifier, String, TagOptions, Object, Object, Object>> unapply(CreateOrReplaceTagExec createOrReplaceTagExec) {
        return CreateOrReplaceTagExec$.MODULE$.unapply(createOrReplaceTagExec);
    }

    public static Function1<Tuple7<TableCatalog, Identifier, String, TagOptions, Object, Object, Object>, CreateOrReplaceTagExec> tupled() {
        return CreateOrReplaceTagExec$.MODULE$.tupled();
    }

    public static Function1<TableCatalog, Function1<Identifier, Function1<String, Function1<TagOptions, Function1<Object, Function1<Object, Function1<Object, CreateOrReplaceTagExec>>>>>>> curried() {
        return CreateOrReplaceTagExec$.MODULE$.curried();
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier ident() {
        return this.ident;
    }

    public String tag() {
        return this.tag;
    }

    public TagOptions tagOptions() {
        return this.tagOptions;
    }

    public boolean create() {
        return this.create;
    }

    public boolean replace() {
        return this.replace;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private Seq<Attribute> output$lzycompute() {
        CreateOrReplaceTagExec createOrReplaceTagExec = this;
        synchronized (createOrReplaceTagExec) {
            if (!this.bitmap$0) {
                this.output = Nil$.MODULE$;
                this.bitmap$0 = true;
            }
        }
        return this.output;
    }

    public Seq<Attribute> output() {
        if (!this.bitmap$0) {
            return this.output$lzycompute();
        }
        return this.output;
    }

    public Seq<InternalRow> run() {
        ManageSnapshots manageSnapshot;
        Table table = this.catalog().loadTable(this.ident());
        if (table instanceof SparkTable) {
            ManageSnapshots manageSnapshots;
            boolean refExists;
            SparkTable sparkTable = (SparkTable)table;
            Long snapshotId = (Long)this.tagOptions().snapshotId().orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)sparkTable.table().currentSnapshot()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.snapshotId()))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1)).orNull(Predef$.MODULE$.$conforms());
            Preconditions.checkArgument((snapshotId != null ? 1 : 0) != 0, (String)"Cannot complete create or replace tag operation on %s, main has no snapshot", (Object[])new Object[]{this.ident()});
            manageSnapshot = sparkTable.table().manageSnapshots();
            boolean bl = refExists = sparkTable.table().refs().get(this.tag()) != null;
            if (this.create() && this.replace() && !refExists) {
                manageSnapshots = manageSnapshot.createTag(this.tag(), Predef$.MODULE$.Long2long(snapshotId));
            } else if (this.replace()) {
                manageSnapshots = manageSnapshot.replaceTag(this.tag(), Predef$.MODULE$.Long2long(snapshotId));
            } else {
                if (refExists && this.ifNotExists()) {
                    return Nil$.MODULE$;
                }
                manageSnapshots = manageSnapshot.createTag(this.tag(), Predef$.MODULE$.Long2long(snapshotId));
            }
        } else {
            throw new UnsupportedOperationException(new StringBuilder(40).append("Cannot create tag to non-Iceberg table: ").append(table).toString());
        }
        Object object = this.tagOptions().snapshotRefRetain().nonEmpty() ? manageSnapshot.setMaxRefAgeMs(this.tag(), BoxesRunTime.unboxToLong((Object)this.tagOptions().snapshotRefRetain().get())) : BoxedUnit.UNIT;
        manageSnapshot.commit();
        return Nil$.MODULE$;
    }

    public String simpleString(int maxFields) {
        return new StringBuilder(24).append("Create tag: ").append(this.tag()).append(" for table: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.ident()).quoted()).toString();
    }

    public CreateOrReplaceTagExec copy(TableCatalog catalog, Identifier ident, String tag, TagOptions tagOptions, boolean create, boolean replace, boolean ifNotExists) {
        return new CreateOrReplaceTagExec(catalog, ident, tag, tagOptions, create, replace, ifNotExists);
    }

    public TableCatalog copy$default$1() {
        return this.catalog();
    }

    public Identifier copy$default$2() {
        return this.ident();
    }

    public String copy$default$3() {
        return this.tag();
    }

    public TagOptions copy$default$4() {
        return this.tagOptions();
    }

    public boolean copy$default$5() {
        return this.create();
    }

    public boolean copy$default$6() {
        return this.replace();
    }

    public boolean copy$default$7() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateOrReplaceTagExec";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.catalog();
            }
            case 1: {
                return this.ident();
            }
            case 2: {
                return this.tag();
            }
            case 3: {
                return this.tagOptions();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.create());
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.replace());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateOrReplaceTagExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateOrReplaceTagExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateOrReplaceTagExec createOrReplaceTagExec = (CreateOrReplaceTagExec)((Object)x$1);
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = createOrReplaceTagExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.ident();
        Identifier identifier2 = createOrReplaceTagExec.ident();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        String string = this.tag();
        String string2 = createOrReplaceTagExec.tag();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        TagOptions tagOptions = this.tagOptions();
        TagOptions tagOptions2 = createOrReplaceTagExec.tagOptions();
        if (tagOptions == null) {
            if (tagOptions2 != null) {
                return false;
            }
        } else if (!((Object)tagOptions).equals(tagOptions2)) return false;
        if (this.create() != createOrReplaceTagExec.create()) return false;
        if (this.replace() != createOrReplaceTagExec.replace()) return false;
        if (this.ifNotExists() != createOrReplaceTagExec.ifNotExists()) return false;
        if (!createOrReplaceTagExec.canEqual((Object)this)) return false;
        return true;
    }

    public CreateOrReplaceTagExec(TableCatalog catalog, Identifier ident, String tag, TagOptions tagOptions, boolean create, boolean replace, boolean ifNotExists) {
        this.catalog = catalog;
        this.ident = ident;
        this.tag = tag;
        this.tagOptions = tagOptions;
        this.create = create;
        this.replace = replace;
        this.ifNotExists = ifNotExists;
        LeafLike.$init$((LeafLike)this);
    }
}

