/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.CommandResultExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import scala.PartialFunction;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkPlanUtil {
    private static final AdaptiveSparkPlanHelper SPARK_HELPER = new AdaptiveSparkPlanHelper(){};

    private SparkPlanUtil() {
    }

    public static List<SparkPlan> collectLeaves(SparkPlan plan) {
        return SparkPlanUtil.toJavaList(SPARK_HELPER.collectLeaves(SparkPlanUtil.actualPlan(plan)));
    }

    public static List<SparkPlan> collectBatchScans(SparkPlan plan) {
        List<SparkPlan> leaves = SparkPlanUtil.collectLeaves(plan);
        return leaves.stream().filter(scan -> scan instanceof BatchScanExec).collect(Collectors.toList());
    }

    private static SparkPlan actualPlan(SparkPlan plan) {
        if (plan instanceof CommandResultExec) {
            return ((CommandResultExec)plan).commandPhysicalPlan();
        }
        return plan;
    }

    public static List<Expression> collectExprs(SparkPlan sparkPlan, final Predicate<Expression> predicate) {
        scala.collection.immutable.Seq seq = SPARK_HELPER.collect(sparkPlan, (PartialFunction)new PartialFunction<SparkPlan, List<Expression>>(){

            public List<Expression> apply(SparkPlan plan) {
                ArrayList exprs = Lists.newArrayList();
                for (Expression expr : SparkPlanUtil.toJavaList(plan.expressions())) {
                    exprs.addAll(SparkPlanUtil.collectExprs(expr, (Predicate<Expression>)predicate));
                }
                return exprs;
            }

            public boolean isDefinedAt(SparkPlan plan) {
                return true;
            }
        });
        return SparkPlanUtil.toJavaList(seq).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<Expression> collectExprs(Expression expression, final Predicate<Expression> predicate) {
        scala.collection.immutable.Seq seq = expression.collect((PartialFunction)new PartialFunction<Expression, Expression>(){

            public Expression apply(Expression expr) {
                return expr;
            }

            public boolean isDefinedAt(Expression expr) {
                return predicate.test(expr);
            }
        });
        return SparkPlanUtil.toJavaList(seq);
    }

    private static <T> List<T> toJavaList(Seq<T> seq) {
        return (List)JavaConverters.seqAsJavaListConverter(seq).asJava();
    }
}

