/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.parser.extensions.IcebergParseException;
import org.apache.spark.sql.catalyst.plans.logical.CallArgument;
import org.apache.spark.sql.catalyst.plans.logical.CallStatement;
import org.apache.spark.sql.catalyst.plans.logical.NamedArgument;
import org.apache.spark.sql.catalyst.plans.logical.PositionalArgument;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestCallStatementParser {
    private static SparkSession spark = null;
    private static ParserInterface parser = null;

    @BeforeAll
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").config("spark.sql.extensions", IcebergSparkSessionExtensions.class.getName()).config("spark.extra.prop", "value").getOrCreate();
        parser = spark.sessionState().sqlParser();
    }

    @AfterAll
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        parser = null;
        currentSpark.stop();
    }

    @Test
    public void testDelegateUnsupportedProcedure() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parser.parsePlan("CALL cat.d.t()")).isInstanceOf(ParseException.class)).satisfies(new ThrowingConsumer[]{exception -> {
            ParseException parseException = (ParseException)exception;
            Assertions.assertThat((String)parseException.getErrorClass()).isEqualTo("PARSE_SYNTAX_ERROR");
            Assertions.assertThat((String)((String)parseException.getMessageParameters().get("error"))).isEqualTo("'CALL'");
        }});
    }

    @Test
    public void testCallWithBackticks() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.`system`.`rollback_to_snapshot`()");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"cat", "system", "rollback_to_snapshot"});
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(0);
    }

    @Test
    public void testCallWithPositionalArgs() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL c.system.rollback_to_snapshot(1, '2', 3L, true, 1.0D, 9.0e1, 900e-1BD)");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"c", "system", "rollback_to_snapshot"});
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(7);
        this.checkArg(call, 0, 1, DataTypes.IntegerType);
        this.checkArg(call, 1, "2", DataTypes.StringType);
        this.checkArg(call, 2, 3L, DataTypes.LongType);
        this.checkArg(call, 3, true, DataTypes.BooleanType);
        this.checkArg(call, 4, 1.0, DataTypes.DoubleType);
        this.checkArg(call, 5, 90.0, DataTypes.DoubleType);
        this.checkArg(call, 6, new BigDecimal("900e-1"), (DataType)DataTypes.createDecimalType((int)3, (int)1));
    }

    @Test
    public void testCallWithNamedArgs() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.rollback_to_snapshot(c1 => 1, c2 => '2', c3 => true)");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"cat", "system", "rollback_to_snapshot"});
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(3);
        this.checkArg(call, 0, "c1", 1, DataTypes.IntegerType);
        this.checkArg(call, 1, "c2", "2", DataTypes.StringType);
        this.checkArg(call, 2, "c3", true, DataTypes.BooleanType);
    }

    @Test
    public void testCallWithMixedArgs() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.rollback_to_snapshot(c1 => 1, '2')");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"cat", "system", "rollback_to_snapshot"});
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(2);
        this.checkArg(call, 0, "c1", 1, DataTypes.IntegerType);
        this.checkArg(call, 1, "2", DataTypes.StringType);
    }

    @Test
    public void testCallWithTimestampArg() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.rollback_to_snapshot(TIMESTAMP '2017-02-03T10:37:30.00Z')");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"cat", "system", "rollback_to_snapshot"});
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(1);
        this.checkArg(call, 0, Timestamp.from(Instant.parse("2017-02-03T10:37:30.00Z")), DataTypes.TimestampType);
    }

    @Test
    public void testCallWithVarSubstitution() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"cat", "system", "rollback_to_snapshot"});
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(1);
        this.checkArg(call, 0, "value", DataTypes.StringType);
    }

    @Test
    public void testCallParseError() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parser.parsePlan("CALL cat.system.rollback_to_snapshot kebab")).isInstanceOf(IcebergParseException.class)).hasMessageContaining("missing '(' at 'kebab'");
    }

    @Test
    public void testCallStripsComments() throws ParseException {
        ArrayList callStatementsWithComments = Lists.newArrayList((Object[])new String[]{"/* bracketed comment */  CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')", "/**/  CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')", "-- single line comment \n CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')", "-- multiple \n-- single line \n-- comments \n CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')", "/* select * from multiline_comment \n where x like '%sql%'; */ CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')", "/* {\"app\": \"dbt\", \"dbt_version\": \"1.0.1\", \"profile_name\": \"profile1\", \"target_name\": \"dev\", \"node_id\": \"model.profile1.stg_users\"} \n*/ CALL cat.system.rollback_to_snapshot('${spark.extra.prop}')", "/* Some multi-line comment \n*/ CALL /* inline comment */ cat.system.rollback_to_snapshot('${spark.extra.prop}') -- ending comment", "CALL -- a line ending comment\ncat.system.rollback_to_snapshot('${spark.extra.prop}')"});
        for (String sqlText : callStatementsWithComments) {
            CallStatement call = (CallStatement)parser.parsePlan(sqlText);
            Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).containsExactly((Object[])new String[]{"cat", "system", "rollback_to_snapshot"});
            Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.args())).hasSize(1);
            this.checkArg(call, 0, "value", DataTypes.StringType);
        }
    }

    private void checkArg(CallStatement call, int index, Object expectedValue, DataType expectedType) {
        this.checkArg(call, index, null, expectedValue, expectedType);
    }

    private void checkArg(CallStatement call, int index, String expectedName, Object expectedValue, DataType expectedType) {
        CallArgument arg;
        if (expectedName != null) {
            arg = this.checkCast(call.args().apply(index), NamedArgument.class);
            Assertions.assertThat((String)arg.name()).isEqualTo(expectedName);
        } else {
            arg = (CallArgument)call.args().apply(index);
            this.checkCast(arg, PositionalArgument.class);
        }
        Literal expectedExpr = this.toSparkLiteral(expectedValue, expectedType);
        Expression actualExpr = ((CallArgument)call.args().apply(index)).expr();
        ((ObjectAssert)Assertions.assertThat((Object)actualExpr.dataType()).as("Arg types must match", new Object[0])).isEqualTo((Object)expectedExpr.dataType());
        ((ObjectAssert)Assertions.assertThat((Object)actualExpr).as("Arg must match", new Object[0])).isEqualTo((Object)expectedExpr);
    }

    private Literal toSparkLiteral(Object value, DataType dataType) {
        return Literal$.MODULE$.create(value, dataType);
    }

    private <T> T checkCast(Object value, Class<T> expectedClass) {
        Assertions.assertThat((Object)value).isInstanceOf(expectedClass);
        return expectedClass.cast(value);
    }
}

