/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestComputeTableStatsProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testProcedureOnEmptyTable() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        List result = this.sql("CALL %s.system.compute_table_stats('%s')", new Object[]{this.catalogName, this.tableIdent});
        Assertions.assertThat((List)result).isEmpty();
    }

    @TestTemplate
    public void testProcedureWithNamedArgs() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')", new Object[]{this.tableName});
        List output = this.sql("CALL %s.system.compute_table_stats(table => '%s', columns => array('id'))", new Object[]{this.catalogName, this.tableIdent});
        Assertions.assertThat((Object[])((Object[])output.get(0))).isNotEmpty();
        Object obj = ((Object[])output.get(0))[0];
        Assertions.assertThat((String)obj.toString()).endsWith((CharSequence)".stats");
        this.verifyTableStats(this.tableName);
    }

    @TestTemplate
    public void testProcedureWithPositionalArgs() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Snapshot snapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.compute_table_stats('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, snapshot.snapshotId()});
        Assertions.assertThat((Object[])((Object[])output.get(0))).isNotEmpty();
        Object obj = ((Object[])output.get(0))[0];
        Assertions.assertThat((String)obj.toString()).endsWith((CharSequence)".stats");
        this.verifyTableStats(this.tableName);
    }

    @TestTemplate
    public void testProcedureWithInvalidColumns() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.compute_table_stats(table => '%s', columns => array('id1'))", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Can't find column id1");
    }

    @TestTemplate
    public void testProcedureWithInvalidSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.compute_table_stats(table => '%s', snapshot_id => %dL)", new Object[]{this.catalogName, this.tableIdent, 1234L})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Snapshot not found");
    }

    @TestTemplate
    public void testProcedureWithInvalidTable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.compute_table_stats(table => '%s', snapshot_id => %dL)", new Object[]{this.catalogName, TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"default"}), (String)"abcd"), 1234L})).isInstanceOf(RuntimeException.class)).hasMessageContaining("Couldn't load table");
    }

    void verifyTableStats(String tableName) throws NoSuchTableException, ParseException {
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)tableName);
        StatisticsFile statisticsFile = (StatisticsFile)table.statisticsFiles().get(0);
        BlobMetadata blobMetadata = (BlobMetadata)statisticsFile.blobMetadata().get(0);
        Assertions.assertThat((Map)blobMetadata.properties()).containsKey((Object)"ndv");
    }
}

