/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.Employee;
import org.apache.iceberg.spark.extensions.SparkRowLevelOperationsTestBase;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromTableWithFilters;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RowLevelWrite;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.OptimizeMetadataOnlyDeleteFromTable;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestDelete
extends SparkRowLevelOperationsTestBase {
    @BeforeAll
    public static void setupSparkConf() {
        spark.conf().set("spark.sql.shuffle.partitions", "4");
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS deleted_id", new Object[0]);
        this.sql("DROP TABLE IF EXISTS deleted_dep", new Object[0]);
        this.sql("DROP TABLE IF EXISTS parquet_table", new Object[0]);
    }

    @TestTemplate
    public void testDeleteWithVectorizedReads() throws NoSuchTableException {
        Assumptions.assumeThat((boolean)this.supportsVectorization()).isTrue();
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hr"));
        this.append(this.tableName, new Employee(3, "hardware"), new Employee(4, "hardware"));
        this.createBranchIfNeeded();
        SparkPlan plan = this.executeAndKeepPlan("DELETE FROM %s WHERE id = 2", new Object[]{this.commitTarget()});
        this.assertAllBatchScansVectorized(plan);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{3, "hardware"}), (Object)this.row(new Object[]{4, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id ASC", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testCoalesceDelete() throws Exception {
        this.createAndInitUnpartitionedTable();
        Employee[] employees = new Employee[100];
        for (int index = 0; index < 100; ++index) {
            employees[index] = new Employee(index, "hr");
        }
        this.append(this.tableName, employees);
        this.append(this.tableName, employees);
        this.append(this.tableName, employees);
        this.append(this.tableName, employees);
        ImmutableMap tableProps = ImmutableMap.of((Object)"read.split.open-file-cost", (Object)String.valueOf(Integer.MAX_VALUE), (Object)"write.delete.distribution-mode", (Object)DistributionMode.RANGE.modeName(), (Object)"write.delete.granularity", (Object)DeleteGranularity.PARTITION.toString());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)tableProps)});
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"200", (Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"true", (Object)SQLConf.COALESCE_PARTITIONS_ENABLED().key(), (Object)"true", (Object)SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), (Object)"100", (Object)"spark.sql.iceberg.advisory-partition-size", (Object)String.valueOf(0x10000000)), () -> {
            SparkPlan plan = this.executeAndKeepPlan("DELETE FROM %s WHERE mod(id, 2) = 0", new Object[]{this.commitTarget()});
            Assertions.assertThat((String)plan.toString()).contains(new CharSequence[]{"REBALANCE_PARTITIONS_BY_COL"});
        });
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateProperty(snapshot, "added-data-files", "1");
        } else if (this.mode(table) == RowLevelOperationMode.MERGE_ON_READ && this.formatVersion >= 3) {
            this.validateProperty(snapshot, "added-delete-files", "4");
            this.validateProperty(snapshot, "added-dvs", "4");
        } else {
            this.validateProperty(snapshot, "added-delete-files", "1");
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT COUNT(*) FROM %s", new Object[]{this.commitTarget()})).as("Row count must match", new Object[0])).isEqualTo((Object)200L);
    }

    @TestTemplate
    public void testSkewDelete() throws Exception {
        this.createAndInitPartitionedTable();
        Employee[] employees = new Employee[100];
        for (int index = 0; index < 100; ++index) {
            employees[index] = new Employee(index, "hr");
        }
        this.append(this.tableName, employees);
        this.append(this.tableName, employees);
        this.append(this.tableName, employees);
        this.append(this.tableName, employees);
        ImmutableMap tableProps = ImmutableMap.of((Object)"read.split.open-file-cost", (Object)String.valueOf(Integer.MAX_VALUE), (Object)"write.delete.distribution-mode", (Object)DistributionMode.HASH.modeName());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)tableProps)});
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.SHUFFLE_PARTITIONS().key(), (Object)"2", (Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"true", (Object)SQLConf.ADAPTIVE_OPTIMIZE_SKEWS_IN_REBALANCE_PARTITIONS_ENABLED().key(), (Object)"true", (Object)SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), (Object)"256MB", (Object)"spark.sql.iceberg.advisory-partition-size", (Object)"100"), () -> {
            SparkPlan plan = this.executeAndKeepPlan("DELETE FROM %s WHERE mod(id, 2) = 0", new Object[]{this.commitTarget()});
            Assertions.assertThat((String)plan.toString()).contains(new CharSequence[]{"REBALANCE_PARTITIONS_BY_COL"});
        });
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateProperty(snapshot, "added-data-files", "4");
        } else {
            this.validateProperty(snapshot, "added-delete-files", "4");
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT COUNT(*) FROM %s", new Object[]{this.commitTarget()})).as("Row count must match", new Object[0])).isEqualTo((Object)200L);
    }

    @TestTemplate
    public void testDeleteWithoutScanningTable() throws Exception {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(3, "hr"));
        this.createBranchIfNeeded();
        this.append(new Employee(1, "hardware"), new Employee(2, "hardware"));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        List manifestLocations = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch).allManifests(table.io()).stream().map(ManifestFile::path).collect(Collectors.toList());
        this.withUnavailableLocations(manifestLocations, () -> {
            LogicalPlan parsed = this.parsePlan("DELETE FROM %s WHERE dep = 'hr'", this.commitTarget());
            LogicalPlan analyzed = spark.sessionState().analyzer().execute(parsed);
            Assertions.assertThat((Object)analyzed).isInstanceOf(RowLevelWrite.class);
            LogicalPlan optimized = OptimizeMetadataOnlyDeleteFromTable.apply((LogicalPlan)analyzed);
            Assertions.assertThat((Object)optimized).isInstanceOf(DeleteFromTableWithFilters.class);
        });
        this.sql("DELETE FROM %s WHERE dep = 'hr'", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteFileThenMetadataDelete() throws Exception {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.fileFormat).as("Avro does not support metadata delete", new Object[0])).isNotEqualTo((Object)FileFormat.AVRO);
        this.createAndInitUnpartitionedTable();
        this.createBranchIfNeeded();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.commitTarget()});
        this.sql("DELETE FROM %s AS t WHERE t.id IS NULL", new Object[]{this.commitTarget()});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List dataFilesBefore = TestHelpers.dataFiles((Table)table, (String)this.branch);
        this.sql("DELETE FROM %s AS t WHERE t.id = 1", new Object[]{this.commitTarget()});
        List dataFilesAfter = TestHelpers.dataFiles((Table)table, (String)this.branch);
        ((ListAssert)Assertions.assertThat((List)dataFilesAfter).as("Data file should have been removed", new Object[0])).hasSizeLessThan(dataFilesBefore.size());
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithPartitionedTable() throws Exception {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(3, "hr"));
        this.append(this.tableName, new Employee(1, "hardware"), new Employee(2, "hardware"));
        this.sql("DELETE FROM %s WHERE id = 1", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        List rowLevelDeletePartitions = spark.sql("SELECT * FROM " + this.tableName + ".partitions ").collectAsList();
        ((ListAssert)Assertions.assertThat((List)rowLevelDeletePartitions).as("row level delete does not reduce number of partition", new Object[0])).hasSize(2);
        this.sql("DELETE FROM %s WHERE dep = 'hr'", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        List actualPartitions = spark.sql("SELECT * FROM " + this.tableName + ".partitions ").collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualPartitions).as("partition aligned delete results in 1 partition", new Object[0])).hasSize(1);
    }

    @TestTemplate
    public void testDeleteWithFalseCondition() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s WHERE id = 1 AND id > 20", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteFromEmptyTable() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Custom branch does not exist for empty table", new Object[0])).isNotEqualTo((Object)"test");
        this.createAndInitUnpartitionedTable();
        this.sql("DELETE FROM %s WHERE id IN (1)", new Object[]{this.commitTarget()});
        this.sql("DELETE FROM %s WHERE dep = 'hr'", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteFromNonExistingCustomBranch() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Test only applicable to custom branch", new Object[0])).isEqualTo("test");
        this.createAndInitUnpartitionedTable();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DELETE FROM %s WHERE id IN (1)", new Object[]{this.commitTarget()})).isInstanceOf(ValidationException.class)).hasMessage("Cannot use branch (does not exist): test");
    }

    @TestTemplate
    public void testExplain() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("EXPLAIN DELETE FROM %s WHERE id <=> 1", new Object[]{this.commitTarget()});
        this.sql("EXPLAIN DELETE FROM %s WHERE true", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 1 snapshot", new Object[0])).hasSize(1);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.commitTarget()}));
    }

    @TestTemplate
    public void testDeleteWithAlias() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s AS t WHERE t.id IS NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithDynamicFileFiltering() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(3, "hr"));
        this.createBranchIfNeeded();
        this.append(new Employee(1, "hardware"), new Employee(2, "hardware"));
        this.sql("DELETE FROM %s WHERE id = 2", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteNonExistingRecords() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s AS t WHERE t.id > 10", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.fileFormat.equals((Object)FileFormat.ORC) || this.fileFormat.equals((Object)FileFormat.PARQUET)) {
            this.validateDelete(currentSnapshot, "0", null);
        } else if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "0", null, null);
        } else {
            this.validateMergeOnRead(currentSnapshot, "0", null, null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void deleteSingleRecordProducesDeleteOperation() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "eng"), new Employee(2, "eng"), new Employee(3, "eng"));
        this.sql("DELETE FROM %s WHERE id = 2", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(2);
        Snapshot currentSnapshot = table.currentSnapshot();
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", null);
            String property = this.formatVersion >= 3 ? "added-dvs" : "added-position-delete-files";
            this.validateProperty(currentSnapshot, property, "1");
        }
        Assertions.assertThat((List)this.sql("SELECT * FROM %s", new Object[]{this.tableName})).containsExactlyInAnyOrder((Object[])new Object[][]{this.row(new Object[]{1, "eng"}), this.row(new Object[]{3, "eng"})});
    }

    @TestTemplate
    public void testDeleteWithoutCondition() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("INSERT INTO TABLE %s VALUES (2, 'hardware')", new Object[]{this.commitTarget()});
        this.sql("INSERT INTO TABLE %s VALUES (null, 'hr')", new Object[]{this.commitTarget()});
        this.sql("DELETE FROM %s", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 4 snapshots", new Object[0])).hasSize(4);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        this.validateDelete(currentSnapshot, "2", "3");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.commitTarget()}));
    }

    @TestTemplate
    public void testDeleteUsingMetadataWithComplexCondition() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO %s VALUES (1, 'dep1')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("INSERT INTO %s VALUES (2, 'dep2')", new Object[]{this.commitTarget()});
        this.sql("INSERT INTO %s VALUES (null, 'dep3')", new Object[]{this.commitTarget()});
        this.sql("DELETE FROM %s WHERE dep > 'dep2' OR dep = CAST(4 AS STRING) OR dep = 'dep2'", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 4 snapshots", new Object[0])).hasSize(4);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        this.validateDelete(currentSnapshot, "2", "2");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "dep1"})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithArbitraryPartitionPredicates() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("INSERT INTO TABLE %s VALUES (2, 'hardware')", new Object[]{this.commitTarget()});
        this.sql("INSERT INTO TABLE %s VALUES (null, 'hr')", new Object[]{this.commitTarget()});
        this.sql("DELETE FROM %s WHERE id = 10 OR dep LIKE '%%ware'", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 4 snapshots", new Object[0])).hasSize(4);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        Assertions.assertThat((String)currentSnapshot.operation()).isEqualTo("delete");
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", null);
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithNonDeterministicCondition() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DELETE FROM %s WHERE id = 1 AND rand() > 0.5", new Object[]{this.commitTarget()})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The operator expects a deterministic expression");
    }

    @TestTemplate
    public void testDeleteWithFoldableConditions() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s WHERE false", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE 50 <> 50", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE 1 > null", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE 21 = 21", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 2 snapshots", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testDeleteWithNullConditions() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (0, null), (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s WHERE dep = null", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, null}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE dep = 'software'", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, null}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE dep <=> NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        this.validateDelete(currentSnapshot, "1", "1");
    }

    @TestTemplate
    public void testDeleteWithInAndNotInConditions() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s WHERE id IN (1, null)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE id NOT IN (null, 1)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE id NOT IN (1, 10)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithMultipleRowGroupsParquet() throws NoSuchTableException {
        Assumptions.assumeThat((Comparable)this.fileFormat).isEqualTo((Object)FileFormat.PARQUET);
        this.createAndInitPartitionedTable();
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "write.parquet.row-group-size-bytes", 100});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "read.split.target-size", 100});
        ArrayList ids = Lists.newArrayListWithCapacity((int)200);
        for (int id = 1; id <= 200; ++id) {
            ids.add(id);
        }
        Dataset df = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"hr"));
        df.coalesce(1).writeTo(this.tableName).append();
        this.createBranchIfNeeded();
        Assertions.assertThat((long)spark.table(this.commitTarget()).count()).isEqualTo(200L);
        this.sql("DELETE FROM %s WHERE id IN (200, 201)", new Object[]{this.commitTarget()});
        Assertions.assertThat((long)spark.table(this.commitTarget()).count()).isEqualTo(199L);
    }

    @TestTemplate
    public void testDeleteWithConditionOnNestedColumn() {
        this.createAndInitNestedColumnsTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\"))", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 2, \"c2\", \"v2\"))", new Object[]{this.commitTarget()});
        this.sql("DELETE FROM %s WHERE complex.c1 = id + 2", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2})), this.sql("SELECT id FROM %s", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE t.complex.c1 = id", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT id FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithInSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.createOrReplaceView("deleted_id", Arrays.asList(0, 1, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id) AND dep IN (SELECT * from deleted_dep)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.append(new Employee(1, "hr"), new Employee(-1, "hr"));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE id IS NULL OR id IN (SELECT value + 2 FROM deleted_id)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
        this.append(new Employee(null, "hr"), new Employee(2, "hr"));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE id IN (SELECT value + 2 FROM deleted_id) AND dep = 'hr'", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithMultiColumnInSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createBranchIfNeeded();
        List<Employee> deletedEmployees = Arrays.asList(new Employee(null, "hr"), new Employee(1, "hr"));
        this.createOrReplaceView("deleted_employee", deletedEmployees, Encoders.bean(Employee.class));
        this.sql("DELETE FROM %s WHERE (id, dep) IN (SELECT id, dep FROM deleted_employee)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithNotInSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createBranchIfNeeded();
        this.createOrReplaceView("deleted_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s WHERE id NOT IN (SELECT * FROM deleted_id)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s WHERE id NOT IN (SELECT * FROM deleted_id) OR dep IN ('software', 'hr')", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL) AND EXISTS (SELECT 1 FROM FROM deleted_dep WHERE t.dep = deleted_dep.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL) OR EXISTS (SELECT 1 FROM FROM deleted_dep WHERE t.dep = deleted_dep.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteOnNonIcebergTableNotSupported() {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        this.sql("CREATE TABLE parquet_table (c1 INT, c2 INT) USING parquet", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DELETE FROM parquet_table WHERE c1 = -100", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageContaining("does not support DELETE");
    }

    @TestTemplate
    public void testDeleteWithExistSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createBranchIfNeeded();
        this.createOrReplaceView("deleted_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value) OR t.id IS NULL", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id di WHERE t.id = di.value) AND EXISTS (SELECT 1 FROM deleted_dep dd WHERE t.dep = dd.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithNotExistsSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createBranchIfNeeded();
        this.createOrReplaceView("deleted_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s t WHERE NOT EXISTS (SELECT 1 FROM deleted_id di WHERE t.id = di.value + 2) AND NOT EXISTS (SELECT 1 FROM deleted_dep dd WHERE t.dep = dd.value)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        this.sql("DELETE FROM %s t WHERE NOT EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)", new Object[]{this.commitTarget()});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        String subquery = "SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2";
        this.sql("DELETE FROM %s t WHERE NOT EXISTS (%s) OR t.id = 1", new Object[]{this.commitTarget(), subquery});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteWithScalarSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createBranchIfNeeded();
        this.createOrReplaceView("deleted_id", Arrays.asList(1, 100, null), Encoders.INT());
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"false"), () -> {
            this.sql("DELETE FROM %s t WHERE id <= (SELECT min(value) FROM deleted_id)", new Object[]{this.commitTarget()});
            this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.selectTarget()}));
        });
    }

    @TestTemplate
    public void testDeleteThatRequiresGroupingBeforeWrite() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.createBranchIfNeeded();
        this.append(new Employee(0, "ops"), new Employee(1, "ops"), new Employee(2, "ops"));
        this.append(new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.append(new Employee(0, "ops"), new Employee(1, "ops"), new Employee(2, "ops"));
        this.createOrReplaceView("deleted_id", Arrays.asList(1, 100), Encoders.INT());
        String originalNumOfShufflePartitions = spark.conf().get("spark.sql.shuffle.partitions");
        try {
            spark.conf().set("spark.sql.shuffle.partitions", "1");
            this.sql("DELETE FROM %s t WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.commitTarget()});
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.commitTarget()).count()).as("Should have expected num of rows", new Object[0])).isEqualTo(8L);
        }
        finally {
            spark.conf().set("spark.sql.shuffle.partitions", originalNumOfShufflePartitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testDeleteWithSerializableIsolation() throws InterruptedException {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualToIgnoringCase((CharSequence)"testhadoop");
        Assumptions.assumeThat((boolean)this.cachingCatalogEnabled()).isTrue();
        this.createAndInitUnpartitionedTable();
        this.createOrReplaceView("deleted_id", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.delete.isolation-level", "serializable"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> deleteFuture = executorService.submit(() -> {
            int numOperations = 0;
            while (numOperations < Integer.MAX_VALUE) {
                int currentNumOperations = numOperations++;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> barrier.get() >= currentNumOperations * 2);
                this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.commitTarget()});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)SnapshotUtil.schemaFor((Table)table, (String)this.branch));
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                int currentNumOperations = numOperations;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> !shouldAppend.get() || barrier.get() >= currentNumOperations * 2);
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                }
                barrier.incrementAndGet();
            }
        });
        try {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(deleteFuture::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(ValidationException.class)).hasMessageContaining("Found conflicting files that can contain");
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public synchronized void testDeleteWithSnapshotIsolation() throws InterruptedException, ExecutionException {
        Assumptions.assumeThat((String)this.catalogName).isNotEqualToIgnoringCase((CharSequence)"testhadoop");
        Assumptions.assumeThat((boolean)this.cachingCatalogEnabled()).isTrue();
        this.createAndInitUnpartitionedTable();
        this.createOrReplaceView("deleted_id", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s'='%s', '%s'='%s', '%s'='%s', '%s'='%s')", new Object[]{this.tableName, "write.delete.isolation-level", "snapshot", "commit.retry.min-wait-ms", "10", "commit.retry.max-wait-ms", "1000", "commit.retry.num-retries", "7"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> deleteFuture = executorService.submit(() -> {
            int numOperations = 0;
            while (numOperations < 20) {
                int currentNumOperations = numOperations++;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> barrier.get() >= currentNumOperations * 2);
                this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.commitTarget()});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)SnapshotUtil.schemaFor((Table)table, (String)this.branch));
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < 20; ++numOperations) {
                int currentNumOperations = numOperations;
                Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(() -> !shouldAppend.get() || barrier.get() >= currentNumOperations * 2);
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    AppendFiles appendFiles = table.newFastAppend().appendFile(dataFile);
                    if (this.branch != null) {
                        appendFiles.toBranch(this.branch);
                    }
                    appendFiles.commit();
                }
                barrier.incrementAndGet();
            }
        });
        try {
            deleteFuture.get();
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testDeleteRefreshesRelationCache() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(3, "hr"));
        this.createBranchIfNeeded();
        this.append(new Employee(1, "hardware"), new Employee(2, "hardware"));
        Dataset query = spark.sql("SELECT * FROM " + this.commitTarget() + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have correct data", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM tmp ORDER BY id, dep", new Object[0]));
        this.sql("DELETE FROM %s WHERE id = 1", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 3 snapshots", new Object[0])).hasSize(3);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "2", "2", "2");
        } else {
            this.validateMergeOnRead(currentSnapshot, "2", "2", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.commitTarget()}));
        this.assertEquals("Should refresh the relation cache", (List)ImmutableList.of(), this.sql("SELECT * FROM tmp ORDER BY id, dep", new Object[0]));
        spark.sql("UNCACHE TABLE tmp");
    }

    @TestTemplate
    public void testDeleteWithMultipleSpecs() {
        this.createAndInitTable("id INT, dep STRING, category STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.createBranchIfNeeded();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.commitTarget(), "{ \"id\": 2, \"dep\": \"hr\", \"category\": \"c1\" }\n{ \"id\": 3, \"dep\": \"hr\", \"category\": \"c1\" }");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD category", new Object[]{this.tableName});
        this.append(this.commitTarget(), "{ \"id\": 5, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD category", new Object[]{this.tableName});
        this.append(this.commitTarget(), "{ \"id\": 7, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.sql("DELETE FROM %s WHERE id IN (1, 3, 5, 7)", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should have 5 snapshots", new Object[0])).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "3", "4", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "3", "4", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hr", "c1"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testDeleteToWapBranch() throws NoSuchTableException {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("WAP branch only works for table identifier without branch", new Object[0])).isNull();
        this.createAndInitPartitionedTable();
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        this.append(new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> {
            this.sql("DELETE FROM %s t WHERE id=0", new Object[]{this.tableName});
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName).count()).as("Should have expected num of rows when reading table", new Object[0])).isEqualTo(2L);
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName + ".branch_wap").count()).as("Should have expected num of rows when reading WAP branch", new Object[0])).isEqualTo(2L);
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName + ".branch_main").count()).as("Should not modify main branch", new Object[0])).isEqualTo(3L);
        });
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> {
            this.sql("DELETE FROM %s t WHERE id=1", new Object[]{this.tableName});
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName).count()).as("Should have expected num of rows when reading table with multiple writes", new Object[0])).isEqualTo(1L);
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName + ".branch_wap").count()).as("Should have expected num of rows when reading WAP branch with multiple writes", new Object[0])).isEqualTo(1L);
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName + ".branch_main").count()).as("Should not modify main branch with multiple writes", new Object[0])).isEqualTo(3L);
        });
    }

    @TestTemplate
    public void testDeleteToWapBranchWithTableBranchIdentifier() throws NoSuchTableException {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Test must have branch name part in table identifier", new Object[0])).isNotNull();
        this.createAndInitPartitionedTable();
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        this.append(this.tableName, new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)"wap"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DELETE FROM %s t WHERE id=0", new Object[]{this.commitTarget()})).isInstanceOf(ValidationException.class)).hasMessage(String.format("Cannot write to both branch and WAP branch, but got branch [%s] and WAP branch [wap]", this.branch)));
    }

    @TestTemplate
    public void testDeleteToCustomWapBranchWithoutWhereClause() throws NoSuchTableException {
        ((AbstractStringAssert)((AbstractStringAssert)Assumptions.assumeThat((String)this.branch).as("Run only if custom WAP branch is not main", new Object[0])).isNotNull()).isNotEqualTo((Object)"main");
        this.createAndInitPartitionedTable();
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' = 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        this.append(this.tableName, new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)this.branch), () -> {
            this.sql("DELETE FROM %s t WHERE id=1", new Object[]{this.tableName});
            Assertions.assertThat((long)spark.table(this.tableName).count()).isEqualTo(2L);
            Assertions.assertThat((long)spark.table(this.tableName + ".branch_" + this.branch).count()).isEqualTo(2L);
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName + ".branch_main").count()).as("Should not modify main branch", new Object[0])).isEqualTo(3L);
        });
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.wap.branch", (Object)this.branch), () -> {
            this.sql("DELETE FROM %s t", new Object[]{this.tableName});
            Assertions.assertThat((long)spark.table(this.tableName).count()).isEqualTo(0L);
            Assertions.assertThat((long)spark.table(this.tableName + ".branch_" + this.branch).count()).isEqualTo(0L);
            ((AbstractLongAssert)Assertions.assertThat((long)spark.table(this.tableName + ".branch_main").count()).as("Should not modify main branch", new Object[0])).isEqualTo(3L);
        });
    }

    @TestTemplate
    public void testDeleteWithFilterOnNestedColumn() {
        this.createAndInitNestedColumnsTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\"))", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 2, \"c2\", \"v2\"))", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE complex.c1 > 3", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1}), (Object)this.row(new Object[]{2})), this.sql("SELECT id FROM %s order by id", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE complex.c1 = 3", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2})), this.sql("SELECT id FROM %s", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE t.complex.c1 = 2", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT id FROM %s", new Object[]{this.tableName}));
    }

    protected void createAndInitPartitionedTable() {
        this.sql("CREATE TABLE %s (id INT, dep STRING) USING iceberg PARTITIONED BY (dep)", new Object[]{this.tableName});
        this.initTable();
    }

    protected void createAndInitUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id INT, dep STRING) USING iceberg", new Object[]{this.tableName});
        this.initTable();
    }

    protected void createAndInitNestedColumnsTable() {
        this.sql("CREATE TABLE %s (id INT, complex STRUCT<c1:INT,c2:STRING>) USING iceberg", new Object[]{this.tableName});
        this.initTable();
    }

    protected void append(Employee ... employees) throws NoSuchTableException {
        this.append(this.commitTarget(), employees);
    }

    protected void append(String target, Employee ... employees) throws NoSuchTableException {
        List<Employee> input = Arrays.asList(employees);
        Dataset inputDF = spark.createDataFrame(input, Employee.class);
        inputDF.coalesce(1).writeTo(target).append();
    }

    private RowLevelOperationMode mode(Table table) {
        String modeName = table.properties().getOrDefault("write.delete.mode", TableProperties.DELETE_MODE_DEFAULT);
        return RowLevelOperationMode.fromName((String)modeName);
    }

    private LogicalPlan parsePlan(String query, Object ... args) {
        try {
            return spark.sessionState().sqlParser().parsePlan(String.format(query, args));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

