/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.extensions.ProcedureUtil;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestExpireSnapshotsProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testExpireSnapshotsInEmptyTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        List output = this.sql("CALL %s.system.expire_snapshots('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Should not delete any files", (List)ImmutableList.of((Object)this.row(new Object[]{0L, 0L, 0L, 0L, 0L, 0L})), output);
    }

    @TestTemplate
    public void testExpireSnapshotsUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        Timestamp secondSnapshotTimestamp = Timestamp.from(Instant.ofEpochMilli(secondSnapshot.timestampMillis()));
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 2 snapshots", new Object[0])).hasSize(2);
        List output1 = this.sql("CALL %s.system.expire_snapshots('%s', TIMESTAMP '%s')", new Object[]{this.catalogName, this.tableIdent, secondSnapshotTimestamp});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0L, 0L, 0L, 0L, 1L, 0L})), output1);
        table.refresh();
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should expire one snapshot", new Object[0])).hasSize(1);
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (4, 'd')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{3L, "c"}), (Object)this.row(new Object[]{4L, "d"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        this.waitUntilAfter(table.currentSnapshot().timestampMillis());
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 3 snapshots", new Object[0])).hasSize(3);
        List output = this.sql("CALL %s.system.expire_snapshots('%s', TIMESTAMP '%s', 2)", new Object[]{this.catalogName, this.tableIdent, currentTimestamp});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{2L, 0L, 0L, 2L, 1L, 0L})), output);
    }

    @TestTemplate
    public void testExpireSnapshotUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 2 snapshots", new Object[0])).hasSize(2);
        this.waitUntilAfter(table.currentSnapshot().timestampMillis());
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        List output = this.sql("CALL %s.system.expire_snapshots(older_than => TIMESTAMP '%s',table => '%s')", new Object[]{this.catalogName, currentTimestamp, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0L, 0L, 0L, 0L, 1L, 0L})), output);
    }

    @TestTemplate
    public void testExpireSnapshotsGCDisabled() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'false')", new Object[]{this.tableName, "gc.enabled"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots('%s')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Cannot expire snapshots: GC is disabled");
    }

    @TestTemplate
    public void testInvalidExpireSnapshotsCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots('n', table => 't')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.expire_snapshots('n', 't')", new Object[]{this.catalogName})).isInstanceOf(ParseException.class)).satisfies(new ThrowingConsumer[]{exception -> {
            ParseException parseException = (ParseException)((Object)exception);
            Assertions.assertThat((String)parseException.getErrorClass()).isEqualTo("PARSE_SYNTAX_ERROR");
            Assertions.assertThat((String)((String)parseException.getMessageParameters().get("error"))).isEqualTo("'CALL'");
        }});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots()", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots('n', 2.2)", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Wrong arg type for older_than: cannot cast DecimalType(2,1) to TimestampType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots('')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
    }

    @TestTemplate
    public void testResolvingTableInAnotherCatalog() throws IOException {
        String anotherCatalog = "another_" + this.catalogName;
        spark.conf().set("spark.sql.catalog." + anotherCatalog, SparkCatalog.class.getName());
        spark.conf().set("spark.sql.catalog." + anotherCatalog + ".type", "hadoop");
        spark.conf().set("spark.sql.catalog." + anotherCatalog + ".warehouse", Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toURI().toString());
        this.sql("CREATE TABLE %s.%s (id bigint NOT NULL, data string) USING iceberg", new Object[]{anotherCatalog, this.tableIdent});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots('%s')", new Object[]{this.catalogName, anotherCatalog + "." + this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot run procedure in catalog");
    }

    @TestTemplate
    public void testConcurrentExpireSnapshots() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (4, 'd')", new Object[]{this.tableName});
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        List output = this.sql("CALL %s.system.expire_snapshots(older_than => TIMESTAMP '%s',table => '%s',max_concurrent_deletes => %s)", new Object[]{this.catalogName, currentTimestamp, this.tableIdent, 4});
        this.assertEquals("Expiring snapshots concurrently should succeed", (List)ImmutableList.of((Object)this.row(new Object[]{0L, 0L, 0L, 0L, 3L, 0L})), output);
    }

    @TestTemplate
    public void testConcurrentExpireSnapshotsWithInvalidInput() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots(table => '%s', max_concurrent_deletes => %s)", new Object[]{this.catalogName, this.tableIdent, 0})).isInstanceOf(IllegalArgumentException.class)).hasMessage("max_concurrent_deletes should have value > 0, value: 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots(table => '%s', max_concurrent_deletes => %s)", new Object[]{this.catalogName, this.tableIdent, -1})).isInstanceOf(IllegalArgumentException.class)).hasMessage("max_concurrent_deletes should have value > 0, value: -1");
    }

    @TestTemplate
    public void testExpireDeleteFiles() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "b"), new SimpleRecord(Integer.valueOf(3), "c"), new SimpleRecord(Integer.valueOf(4), "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ListAssert)Assertions.assertThat((List)TestHelpers.deleteManifests((Table)table)).as("Should have 1 delete manifest", new Object[0])).hasSize(1);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)TestHelpers.deleteFiles((Table)table)).as("Should have 1 delete file", new Object[0])).hasSize(1);
        Path deleteManifestPath = new Path(((ManifestFile)TestHelpers.deleteManifests((Table)table).iterator().next()).path());
        DeleteFile deleteFile = (DeleteFile)TestHelpers.deleteFiles((Table)table).iterator().next();
        Path deleteFilePath = new Path(deleteFile.location());
        this.sql("CALL %s.system.rewrite_data_files(table => '%s',options => map('delete-file-threshold','1','use-starting-sequence-number', 'false'))", new Object[]{this.catalogName, this.tableIdent});
        table.refresh();
        table.newRowDelta().removeDeletes(deleteFile).commit();
        this.sql("INSERT INTO TABLE %s VALUES (6, 'f')", new Object[]{this.tableName});
        table.refresh();
        ((ListAssert)Assertions.assertThat((List)TestHelpers.deleteManifests((Table)table)).as("Should have no delete manifests", new Object[0])).hasSize(0);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)TestHelpers.deleteFiles((Table)table)).as("Should have no delete files", new Object[0])).hasSize(0);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(deleteManifestPath)).as("Delete manifest should still exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(deleteFilePath)).as("Delete file should still exist", new Object[0])).isTrue();
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        List output = this.sql("CALL %s.system.expire_snapshots(older_than => TIMESTAMP '%s',table => '%s')", new Object[]{this.catalogName, currentTimestamp, this.tableIdent});
        this.assertEquals("Should deleted 1 data and pos delete file and 4 manifests and lists (one for each txn)", (List)ImmutableList.of((Object)this.row(new Object[]{1L, 1L, 0L, 4L, 4L, 0L})), output);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(deleteManifestPath)).as("Delete manifest should be removed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)localFs.exists(deleteFilePath)).as("Delete file should be removed", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testExpireSnapshotWithStreamResultsEnabled() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 2 snapshots", new Object[0])).hasSize(2);
        this.waitUntilAfter(table.currentSnapshot().timestampMillis());
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        List output = this.sql("CALL %s.system.expire_snapshots(older_than => TIMESTAMP '%s',table => '%s',stream_results => true)", new Object[]{this.catalogName, currentTimestamp, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0L, 0L, 0L, 0L, 1L, 0L})), output);
    }

    @TestTemplate
    public void testExpireSnapshotsWithSnapshotId() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 2 snapshots", new Object[0])).hasSize(2);
        long firstSnapshotId = table.currentSnapshot().parentId();
        this.sql("CALL %s.system.expire_snapshots(table => '%s',snapshot_ids => ARRAY(%d))", new Object[]{this.catalogName, this.tableIdent, firstSnapshotId});
        table.refresh();
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 1 snapshots", new Object[0])).hasSize(1);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Snapshot ID should not be present", new Object[0])).filteredOn(snapshot -> snapshot.snapshotId() == firstSnapshotId)).hasSize(0);
    }

    @TestTemplate
    public void testExpireSnapshotShouldFailForCurrentSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 2 snapshots", new Object[0])).hasSize(2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.expire_snapshots(table => '%s',snapshot_ids => ARRAY(%d, %d))", new Object[]{this.catalogName, this.tableIdent, table.currentSnapshot().snapshotId(), table.currentSnapshot().parentId()})).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot expire");
    }

    @TestTemplate
    public void testExpireSnapshotsProcedureWorksWithSqlComments() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 2 snapshots", new Object[0])).hasSize(2);
        this.waitUntilAfter(table.currentSnapshot().timestampMillis());
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        String callStatement = "/* CALL statement is used to expire snapshots */\n-- And we have single line comments as well \n/* And comments that span *multiple* \n lines */ CALL /* this is the actual CALL */ %s.system.expire_snapshots(   older_than => TIMESTAMP '%s',   table => '%s')";
        List output = this.sql(callStatement, new Object[]{this.catalogName, currentTimestamp, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0L, 0L, 0L, 0L, 1L, 0L})), output);
        table.refresh();
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should be 1 snapshot remaining", new Object[0])).hasSize(1);
    }

    @TestTemplate
    public void testExpireSnapshotsWithStatisticFiles() throws Exception {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (10, 'abc')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String statsFileLocation1 = ProcedureUtil.statsFileLocation(table.location());
        StatisticsFile statisticsFile1 = TestExpireSnapshotsProcedure.writeStatsFile(table.currentSnapshot().snapshotId(), table.currentSnapshot().sequenceNumber(), statsFileLocation1, table.io());
        table.updateStatistics().setStatistics(statisticsFile1.snapshotId(), statisticsFile1).commit();
        this.sql("INSERT INTO %s SELECT 20, 'def'", new Object[]{this.tableName});
        table.refresh();
        String statsFileLocation2 = ProcedureUtil.statsFileLocation(table.location());
        StatisticsFile statisticsFile2 = TestExpireSnapshotsProcedure.writeStatsFile(table.currentSnapshot().snapshotId(), table.currentSnapshot().sequenceNumber(), statsFileLocation2, table.io());
        table.updateStatistics().setStatistics(statisticsFile2.snapshotId(), statisticsFile2).commit();
        this.waitUntilAfter(table.currentSnapshot().timestampMillis());
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        List output = this.sql("CALL %s.system.expire_snapshots(older_than => TIMESTAMP '%s',table => '%s')", new Object[]{this.catalogName, currentTimestamp, this.tableIdent});
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[5]).as("should be 1 deleted statistics file", new Object[0])).isEqualTo((Object)1L);
        table.refresh();
        ((ListAssert)Assertions.assertThat((List)table.statisticsFiles()).as("Statistics file entry in TableMetadata should be present only for the snapshot %s", new Object[]{statisticsFile2.snapshotId()})).extracting(StatisticsFile::snapshotId).containsExactly((Object[])new Long[]{statisticsFile2.snapshotId()});
        ((AbstractFileAssert)Assertions.assertThat((File)new File(statsFileLocation1)).as("Statistics file should not exist for snapshot %s", new Object[]{statisticsFile1.snapshotId()})).doesNotExist();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(statsFileLocation2)).as("Statistics file should exist for snapshot %s", new Object[]{statisticsFile2.snapshotId()})).exists();
    }

    @TestTemplate
    public void testExpireSnapshotsWithPartitionStatisticFiles() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (10, 'abc')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String partitionStatsFileLocation1 = ProcedureUtil.statsFileLocation(table.location());
        PartitionStatisticsFile partitionStatisticsFile1 = ProcedureUtil.writePartitionStatsFile(table.currentSnapshot().snapshotId(), partitionStatsFileLocation1, table.io());
        table.updatePartitionStatistics().setPartitionStatistics(partitionStatisticsFile1).commit();
        this.sql("INSERT INTO %s SELECT 20, 'def'", new Object[]{this.tableName});
        table.refresh();
        String partitionStatsFileLocation2 = ProcedureUtil.statsFileLocation(table.location());
        PartitionStatisticsFile partitionStatisticsFile2 = ProcedureUtil.writePartitionStatsFile(table.currentSnapshot().snapshotId(), partitionStatsFileLocation2, table.io());
        table.updatePartitionStatistics().setPartitionStatistics(partitionStatisticsFile2).commit();
        this.waitUntilAfter(table.currentSnapshot().timestampMillis());
        Timestamp currentTimestamp = Timestamp.from(Instant.ofEpochMilli(System.currentTimeMillis()));
        List output = this.sql("CALL %s.system.expire_snapshots(older_than => TIMESTAMP '%s',table => '%s')", new Object[]{this.catalogName, currentTimestamp, this.tableIdent});
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[5]).as("should be 1 deleted partition statistics file", new Object[0])).isEqualTo((Object)1L);
        table.refresh();
        ((ListAssert)Assertions.assertThat((List)table.partitionStatisticsFiles()).as("partition statistics file entry in TableMetadata should be present only for the snapshot %s", new Object[]{partitionStatisticsFile2.snapshotId()})).extracting(PartitionStatisticsFile::snapshotId).containsExactly((Object[])new Long[]{partitionStatisticsFile2.snapshotId()});
        ((AbstractFileAssert)Assertions.assertThat((File)new File(partitionStatsFileLocation1)).as("partition statistics file should not exist for snapshot %s", new Object[]{partitionStatisticsFile1.snapshotId()})).doesNotExist();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(partitionStatsFileLocation2)).as("partition statistics file should exist for snapshot %s", new Object[]{partitionStatisticsFile2.snapshotId()})).exists();
    }

    private static StatisticsFile writeStatsFile(long snapshotId, long snapshotSequenceNumber, String statsLocation, FileIO fileIO) throws IOException {
        try (PuffinWriter puffinWriter = Puffin.write((OutputFile)fileIO.newOutputFile(statsLocation)).build();){
            puffinWriter.add(new Blob("some-blob-type", (List)ImmutableList.of((Object)1), snapshotId, snapshotSequenceNumber, ByteBuffer.wrap("blob content".getBytes(StandardCharsets.UTF_8))));
            puffinWriter.finish();
            GenericStatisticsFile genericStatisticsFile = new GenericStatisticsFile(snapshotId, statsLocation, puffinWriter.fileSize(), puffinWriter.footerSize(), (List)puffinWriter.writtenBlobsMetadata().stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList()));
            return genericStatisticsFile;
        }
    }
}

