/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestFastForwardBranchProcedure
extends ExtensionsTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testFastForwardBranchUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.refresh();
        Snapshot currSnapshot = table.currentSnapshot();
        long sourceRef = currSnapshot.snapshotId();
        String newBranch = "testBranch";
        String tableNameWithBranch = String.format("%s.branch_%s", this.tableName, newBranch);
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, newBranch});
        this.sql("INSERT INTO TABLE %s VALUES(3,'c')", new Object[]{tableNameWithBranch});
        table.refresh();
        long updatedRef = table.snapshot(newBranch).snapshotId();
        this.assertEquals("Main branch should not have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
        this.assertEquals("Test branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{tableNameWithBranch}));
        List output = this.sql("CALL %s.system.fast_forward('%s', '%s', '%s')", new Object[]{this.catalogName, this.tableIdent, "main", newBranch});
        Assertions.assertThat(Arrays.stream((Object[])output.get(0)).collect(Collectors.toList()).get(0)).isEqualTo((Object)"main");
        Assertions.assertThat(Arrays.stream((Object[])output.get(0)).collect(Collectors.toList()).get(1)).isEqualTo((Object)sourceRef);
        Assertions.assertThat(Arrays.stream((Object[])output.get(0)).collect(Collectors.toList()).get(2)).isEqualTo((Object)updatedRef);
        this.assertEquals("Main branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testFastForwardBranchUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        String newBranch = "testBranch";
        String tableNameWithBranch = String.format("%s.branch_%s", this.tableName, newBranch);
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, newBranch});
        this.sql("INSERT INTO TABLE %s VALUES(3,'c')", new Object[]{tableNameWithBranch});
        this.assertEquals("Main branch should not have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
        this.assertEquals("Test branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{tableNameWithBranch}));
        List output = this.sql("CALL %s.system.fast_forward(table => '%s', branch => '%s', to => '%s')", new Object[]{this.catalogName, this.tableIdent, "main", newBranch});
        this.assertEquals("Main branch should now have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testFastForwardWhenTargetIsNotAncestorFails() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        String newBranch = "testBranch";
        String tableNameWithBranch = String.format("%s.branch_%s", this.tableName, newBranch);
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, newBranch});
        this.sql("INSERT INTO TABLE %s VALUES(3,'c')", new Object[]{tableNameWithBranch});
        this.assertEquals("Main branch should not have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
        this.assertEquals("Test branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{tableNameWithBranch}));
        this.sql("INSERT INTO TABLE %s VALUES (4, 'd')", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward(table => '%s', branch => '%s', to => '%s')", new Object[]{this.catalogName, this.tableIdent, "main", newBranch})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot fast-forward: main is not an ancestor of testBranch");
    }

    @TestTemplate
    public void testInvalidFastForwardBranchCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward('test_table', branch => 'main', to => 'newBranch')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.fast_forward('test_table', 'main', 'newBranch')", new Object[]{this.catalogName})).isInstanceOf(ParseException.class)).satisfies(new ThrowingConsumer[]{exception -> {
            ParseException parseException = (ParseException)((Object)exception);
            Assertions.assertThat((String)parseException.getErrorClass()).isEqualTo("PARSE_SYNTAX_ERROR");
            Assertions.assertThat((String)((String)parseException.getMessageParameters().get("error"))).isEqualTo("'CALL'");
        }});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward('test_table', 'main')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [to]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward('', 'main', 'newBranch')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
    }

    @TestTemplate
    public void testFastForwardNonExistingToRefFails() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward(table => '%s', branch => '%s', to => '%s')", new Object[]{this.catalogName, this.tableIdent, "main", "non_existing_branch"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Ref does not exist: non_existing_branch");
    }

    @TestTemplate
    public void testFastForwardNonMain() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.refresh();
        String branch1 = "branch1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, branch1});
        String tableNameWithBranch1 = String.format("%s.branch_%s", this.tableName, branch1);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{tableNameWithBranch1});
        table.refresh();
        Snapshot branch1Snapshot = table.snapshot(branch1);
        String branch2 = "branch2";
        this.sql("ALTER TABLE %s CREATE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branch2, branch1Snapshot.snapshotId()});
        String tableNameWithBranch2 = String.format("%s.branch_%s", this.tableName, branch2);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c')", new Object[]{tableNameWithBranch2});
        table.refresh();
        Snapshot branch2Snapshot = table.snapshot(branch2);
        Assertions.assertThat((List)this.sql("CALL %s.system.fast_forward('%s', '%s', '%s')", new Object[]{this.catalogName, this.tableIdent, branch1, branch2})).containsExactly((Object[])new Object[][]{this.row(new Object[]{branch1, branch1Snapshot.snapshotId(), branch2Snapshot.snapshotId()})});
    }

    @TestTemplate
    public void testFastForwardNonExistingFromMainCreatesBranch() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        String branch1 = "branch1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, branch1});
        String branchIdentifier = String.format("%s.branch_%s", this.tableName, branch1);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{branchIdentifier});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{branchIdentifier});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.refresh();
        Snapshot branch1Snapshot = table.snapshot(branch1);
        Assertions.assertThat((List)this.sql("CALL %s.system.fast_forward('%s', '%s', '%s')", new Object[]{this.catalogName, this.tableIdent, "main", branch1})).containsExactly((Object[])new Object[][]{this.row(new Object[]{"main", null, branch1Snapshot.snapshotId()})});
        String branch2 = "branch2";
        Assertions.assertThat((List)this.sql("CALL %s.system.fast_forward('%s', '%s', '%s')", new Object[]{this.catalogName, this.tableIdent, branch2, branch1})).containsExactly((Object[])new Object[][]{this.row(new Object[]{branch2, null, branch1Snapshot.snapshotId()})});
    }
}

