/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.TestMerge;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.Encoders;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;

public class TestMergeOnReadMerge
extends TestMerge {
    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"write.merge.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName());
    }

    @TestTemplate
    public void testMergeDeleteFileGranularity() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        this.checkMergeDeleteGranularity(DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testMergeDeletePartitionGranularity() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        this.checkMergeDeleteGranularity(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testMergeWithDVAndHistoricalPositionDeletes() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        this.createTableWithDeleteGranularity("id INT, dep STRING", "PARTITIONED BY (dep)", DeleteGranularity.PARTITION);
        this.createBranchIfNeeded();
        this.createOrReplaceView("source", IntStream.rangeClosed(1, 9).boxed().collect(Collectors.toList()), Encoders.INT());
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"hr\" }");
        this.append(this.commitTarget(), "{ \"id\": 4, \"dep\": \"hr\" }\n{ \"id\": 5, \"dep\": \"hr\" }\n{ \"id\": 6, \"dep\": \"hr\" }");
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value and (id = 1 or id = 4) WHEN MATCHED THEN  DELETE WHEN NOT MATCHED THEN  INSERT (id, dep) VALUES (-1, 'other')", new Object[]{this.commitTarget()});
        ImmutableMap fileGranularityProps = ImmutableMap.of((Object)"write.delete.granularity", (Object)DeleteGranularity.FILE.toString());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)fileGranularityProps)});
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value and id = 5 WHEN MATCHED THEN  UPDATE SET id = id + 2 WHEN NOT MATCHED THEN  INSERT (id, dep) VALUES (-1, 'other')", new Object[]{this.commitTarget()});
        ImmutableMap updateFormatProperties = ImmutableMap.of((Object)"format-version", (Object)"3");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)updateFormatProperties)});
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value and id = 6 WHEN MATCHED THEN  UPDATE SET id = id + 1 WHEN NOT MATCHED THEN  INSERT (id, dep) VALUES (-1, 'other')", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Set deleteFiles = TestHelpers.deleteFiles((Table)table, (Snapshot)SnapshotUtil.latestSnapshot((Table)table, (String)this.branch));
        List dvs = deleteFiles.stream().filter(ContentFileUtil::isDV).collect(Collectors.toList());
        Assertions.assertThat(dvs).hasSize(1);
        Assertions.assertThat(dvs).allMatch(dv -> dv.recordCount() == 3L);
        Assertions.assertThat(dvs).allMatch(dv -> FileFormat.fromFileName((CharSequence)dv.location()) == FileFormat.PUFFIN);
    }

    private void checkMergeDeleteGranularity(DeleteGranularity deleteGranularity) {
        this.createTableWithDeleteGranularity("id INT, dep STRING", "PARTITIONED BY (dep)", deleteGranularity);
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"hr\" }\n{ \"id\": 4, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"it\" }\n{ \"id\": 2, \"dep\": \"it\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"it\" }\n{ \"id\": 4, \"dep\": \"it\" }");
        this.createBranchIfNeeded();
        this.createOrReplaceView("source", ImmutableList.of((Object)1, (Object)3, (Object)5), Encoders.INT());
        this.sql("MERGE INTO %s AS t USING source AS s ON t.id == s.value WHEN MATCHED THEN  DELETE WHEN NOT MATCHED THEN  INSERT (id, dep) VALUES (-1, 'other')", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = deleteGranularity == DeleteGranularity.FILE ? "4" : "2";
        this.validateMergeOnRead(currentSnapshot, "3", expectedDeleteFilesCount, "1");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "other"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{4, "hr"}), (Object)this.row(new Object[]{4, "it"})), this.sql("SELECT * FROM %s ORDER BY id ASC, dep ASC", new Object[]{this.selectTarget()}));
    }
}

