/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.TestUpdate;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMergeOnReadUpdate
extends TestUpdate {
    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"write.update.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName());
    }

    @TestTemplate
    public void testUpdateFileGranularity() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        this.checkUpdateFileGranularity(DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testUpdatePartitionGranularity() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        this.checkUpdateFileGranularity(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testPositionDeletesAreMaintainedDuringUpdate() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        Assumptions.assumeThat((String)this.distributionMode).isNotEqualToIgnoringCase((CharSequence)"range");
        this.checkUpdateFileGranularity(DeleteGranularity.FILE);
        this.sql("UPDATE %s SET id = id + 1 WHERE id = 4", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = "2";
        this.validateMergeOnRead(currentSnapshot, "2", expectedDeleteFilesCount, "2");
        Assertions.assertThat((Iterable)currentSnapshot.removedDeleteFiles(table.io())).hasSize(2);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{5, "hr"}), (Object)this.row(new Object[]{0, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{5, "it"})), this.sql("SELECT * FROM %s ORDER BY dep ASC, id ASC", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUnpartitionedPositionDeletesAreMaintainedDuringUpdate() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        Assumptions.assumeThat((String)this.distributionMode).isNotEqualToIgnoringCase((CharSequence)"range");
        this.initTable("", DeleteGranularity.FILE);
        this.sql("UPDATE %s SET id = id - 1 WHERE id = 1 OR id = 3", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = "4";
        this.validateMergeOnRead(currentSnapshot, "1", expectedDeleteFilesCount, "1");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{4, "hr"}), (Object)this.row(new Object[]{0, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{4, "it"})), this.sql("SELECT * FROM %s ORDER BY dep ASC, id ASC", new Object[]{this.selectTarget()}));
        this.sql("UPDATE %s SET id = id + 1 WHERE id = 4", new Object[]{this.commitTarget()});
        table.refresh();
        currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        expectedDeleteFilesCount = "2";
        this.validateMergeOnRead(currentSnapshot, "1", expectedDeleteFilesCount, "1");
        Assertions.assertThat((Iterable)currentSnapshot.removedDeleteFiles(table.io())).hasSize(2);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{5, "hr"}), (Object)this.row(new Object[]{0, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{5, "it"})), this.sql("SELECT * FROM %s ORDER BY dep ASC, id ASC", new Object[]{this.selectTarget()}));
    }

    private void checkUpdateFileGranularity(DeleteGranularity deleteGranularity) {
        this.initTable("PARTITIONED BY (dep)", deleteGranularity);
        this.sql("UPDATE %s SET id = id - 1 WHERE id = 1 OR id = 3", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = deleteGranularity == DeleteGranularity.FILE ? "4" : "2";
        this.validateMergeOnRead(currentSnapshot, "2", expectedDeleteFilesCount, "2");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{4, "hr"}), (Object)this.row(new Object[]{0, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{2, "it"}), (Object)this.row(new Object[]{4, "it"})), this.sql("SELECT * FROM %s ORDER BY dep ASC, id ASC", new Object[]{this.selectTarget()}));
    }

    @TestTemplate
    public void testUpdateWithDVAndHistoricalPositionDeletes() {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        this.createTableWithDeleteGranularity("id INT, dep STRING", "PARTITIONED BY (dep)", DeleteGranularity.PARTITION);
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }\n{ \"id\": 3, \"dep\": \"hr\" }");
        this.append(this.commitTarget(), "{ \"id\": 4, \"dep\": \"hr\" }\n{ \"id\": 5, \"dep\": \"hr\" }\n{ \"id\": 6, \"dep\": \"hr\" }");
        this.sql("UPDATE %s SET id = id - 1 WHERE id = 1 or id = 4", new Object[]{this.commitTarget()});
        ImmutableMap fileGranularityProps = ImmutableMap.of((Object)"write.delete.granularity", (Object)DeleteGranularity.FILE.toString());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)fileGranularityProps)});
        this.sql("UPDATE %s SET id = id + 2 WHERE id = 5", new Object[]{this.commitTarget()});
        ImmutableMap updateFormatProperties = ImmutableMap.of((Object)"format-version", (Object)"3");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (%s)", new Object[]{this.tableName, this.tablePropsAsString((Map)updateFormatProperties)});
        this.sql("UPDATE %s SET id = id + 1 where id = 6", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Set deleteFiles = TestHelpers.deleteFiles((Table)table, (Snapshot)SnapshotUtil.latestSnapshot((Table)table, (String)this.branch));
        List dvs = deleteFiles.stream().filter(ContentFileUtil::isDV).collect(Collectors.toList());
        Assertions.assertThat(dvs).hasSize(1);
        Assertions.assertThat((long)((DeleteFile)dvs.get(0)).recordCount()).isEqualTo(3L);
        Assertions.assertThat(dvs).allMatch(dv -> FileFormat.fromFileName((CharSequence)dv.location()) == FileFormat.PUFFIN);
    }

    private void initTable(String partitionedBy, DeleteGranularity deleteGranularity) {
        this.createTableWithDeleteGranularity("id INT, dep STRING", partitionedBy, deleteGranularity);
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\" }\n{ \"id\": 2, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"hr\" }\n{ \"id\": 4, \"dep\": \"hr\" }");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"it\" }\n{ \"id\": 2, \"dep\": \"it\" }");
        this.append(this.tableName, "{ \"id\": 3, \"dep\": \"it\" }\n{ \"id\": 4, \"dep\": \"it\" }");
        this.createBranchIfNeeded();
    }
}

