/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableUtil;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestRegisterTableProcedure
extends ExtensionsTestBase {
    private String targetName;

    @BeforeEach
    public void setTargetName() {
        this.targetName = this.tableName("register_table");
    }

    @AfterEach
    public void dropTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.targetName});
    }

    @TestTemplate
    public void testRegisterTable() throws NoSuchTableException, ParseException {
        long numRows = 1000L;
        this.sql("CREATE TABLE %s (id int, data string) using ICEBERG", new Object[]{this.tableName});
        spark.range(0L, numRows).withColumn("data", functions.col((String)"id").cast(DataTypes.StringType)).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        long originalFileCount = (Long)this.scalarSql("SELECT COUNT(*) from %s.files", new Object[]{this.tableName});
        long currentSnapshotId = table.currentSnapshot().snapshotId();
        String metadataJson = TableUtil.metadataFileLocation((Table)table);
        List result = this.sql("CALL %s.system.register_table('%s', '%s')", new Object[]{this.catalogName, this.targetName, metadataJson});
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[0]).as("Current Snapshot is not correct", new Object[0])).isEqualTo((Object)currentSnapshotId);
        List original = this.sql("SELECT * FROM %s", new Object[]{this.tableName});
        List registered = this.sql("SELECT * FROM %s", new Object[]{this.targetName});
        this.assertEquals("Registered table rows should match original table rows", original, registered);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[1]).as("Should have the right row count in the procedure result", new Object[0])).isEqualTo((Object)numRows);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[2]).as("Should have the right datafile count in the procedure result", new Object[0])).isEqualTo((Object)originalFileCount);
    }
}

