/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestReplaceBranch
extends ExtensionsTestBase {
    private static final String[] TIME_UNITS = new String[]{"DAYS", "HOURS", "MINUTES"};

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties()}};
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testReplaceBranchFailsForTag() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        String tagName = "tag1";
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag(tagName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, tagName, second})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Ref tag1 is a tag not a branch");
    }

    @TestTemplate
    public void testReplaceBranch() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        long expectedMaxRefAgeMs = 1000L;
        int expectedMinSnapshotsToKeep = 2;
        long expectedMaxSnapshotAgeMs = 1000L;
        table.manageSnapshots().createBranch(branchName, first).setMaxRefAgeMs(branchName, expectedMaxRefAgeMs).setMinSnapshotsToKeep(branchName, expectedMinSnapshotsToKeep).setMaxSnapshotAgeMs(branchName, expectedMaxSnapshotAgeMs).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, second});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assertions.assertThat((Object)ref).isNotNull();
        Assertions.assertThat((long)ref.snapshotId()).isEqualTo(second);
        Assertions.assertThat((int)ref.minSnapshotsToKeep()).isEqualTo(expectedMinSnapshotsToKeep);
        Assertions.assertThat((long)ref.maxSnapshotAgeMs()).isEqualTo(expectedMaxSnapshotAgeMs);
        Assertions.assertThat((long)ref.maxRefAgeMs()).isEqualTo(expectedMaxRefAgeMs);
    }

    @TestTemplate
    public void testReplaceBranchDoesNotExist() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, "someBranch", table.currentSnapshot().snapshotId()})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Branch does not exist: someBranch");
    }

    @TestTemplate
    public void testReplaceBranchWithRetain() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        table.manageSnapshots().createBranch(branchName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        long maxRefAge = 10L;
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d RETAIN %d %s", new Object[]{this.tableName, branchName, second, maxRefAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
            Assertions.assertThat((Object)ref).isNotNull();
            Assertions.assertThat((long)ref.snapshotId()).isEqualTo(second);
            Assertions.assertThat((Integer)ref.minSnapshotsToKeep()).isNull();
            Assertions.assertThat((Long)ref.maxSnapshotAgeMs()).isNull();
            Assertions.assertThat((long)ref.maxRefAgeMs()).isEqualTo(TimeUnit.valueOf(timeUnit).toMillis(maxRefAge));
        }
    }

    @TestTemplate
    public void testReplaceBranchWithSnapshotRetention() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        String branchName = "b1";
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        Long maxRefAgeMs = ((SnapshotRef)table.refs().get(branchName)).maxRefAgeMs();
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d WITH SNAPSHOT RETENTION %d SNAPSHOTS %d %s", new Object[]{this.tableName, branchName, second, minSnapshotsToKeep, maxSnapshotAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
            Assertions.assertThat((Object)ref).isNotNull();
            Assertions.assertThat((long)ref.snapshotId()).isEqualTo(second);
            Assertions.assertThat((Integer)ref.minSnapshotsToKeep()).isEqualTo((Object)minSnapshotsToKeep);
            Assertions.assertThat((long)ref.maxSnapshotAgeMs()).isEqualTo(TimeUnit.valueOf(timeUnit).toMillis(maxSnapshotAge));
            Assertions.assertThat((Long)ref.maxRefAgeMs()).isEqualTo((Object)maxRefAgeMs);
        }
    }

    @TestTemplate
    public void testReplaceBranchWithRetainAndSnapshotRetention() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        table.manageSnapshots().createBranch(branchName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        long maxRefAge = 10L;
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d RETAIN %d %s WITH SNAPSHOT RETENTION %d SNAPSHOTS %d %s", new Object[]{this.tableName, branchName, second, maxRefAge, timeUnit, minSnapshotsToKeep, maxSnapshotAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
            Assertions.assertThat((Object)ref).isNotNull();
            Assertions.assertThat((long)ref.snapshotId()).isEqualTo(second);
            Assertions.assertThat((Integer)ref.minSnapshotsToKeep()).isEqualTo((Object)minSnapshotsToKeep);
            Assertions.assertThat((long)ref.maxSnapshotAgeMs()).isEqualTo(TimeUnit.valueOf(timeUnit).toMillis(maxSnapshotAge));
            Assertions.assertThat((long)ref.maxRefAgeMs()).isEqualTo(TimeUnit.valueOf(timeUnit).toMillis(maxRefAge));
        }
    }

    @TestTemplate
    public void testCreateOrReplace() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, second).commit();
        this.sql("ALTER TABLE %s CREATE OR REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, first});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assertions.assertThat((Object)ref).isNotNull();
        Assertions.assertThat((long)ref.snapshotId()).isEqualTo(first);
    }
}

