/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.nio.file.Path;
import java.util.List;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.RewriteTablePathUtil;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableUtil;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.io.TempDir;

public class TestRewriteTablePathProcedure
extends ExtensionsTestBase {
    @TempDir
    private Path staging;
    @TempDir
    private Path targetTableDir;

    @BeforeEach
    public void setupTableLocation() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @TestTemplate
    public void testRewriteTablePathWithPositionalArgument() {
        String location = this.targetTableDir.toFile().toURI().toString();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String metadataJson = TableUtil.metadataFileLocation((Table)table);
        List result = this.sql("CALL %s.system.rewrite_table_path('%s', '%s', '%s')", new Object[]{this.catalogName, this.tableIdent, table.location(), location});
        Assertions.assertThat((List)result).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[0]).as("Should return correct latest version", new Object[0])).isEqualTo((Object)RewriteTablePathUtil.fileName((String)metadataJson));
        ((AbstractStringAssert)((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[1]).as("Should return file_list_location", new Object[0])).asString().startsWith((CharSequence)table.location())).endsWith((CharSequence)"file-list");
        this.checkFileListLocationCount((String)((Object[])result.get(0))[1], 1L);
    }

    @TestTemplate
    public void testRewriteTablePathWithNamedArgument() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String v0Metadata = RewriteTablePathUtil.fileName((String)TableUtil.metadataFileLocation((Table)table));
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        String v1Metadata = RewriteTablePathUtil.fileName((String)((HasTableOperations)table).operations().refresh().metadataFileLocation());
        String targetLocation = this.targetTableDir.toFile().toURI().toString();
        String stagingLocation = this.staging.toFile().toURI().toString();
        String expectedFileListLocation = stagingLocation + "file-list";
        List result = this.sql("CALL %s.system.rewrite_table_path(table => '%s', target_prefix => '%s', source_prefix => '%s', end_version => '%s', start_version => '%s', staging_location => '%s')", new Object[]{this.catalogName, this.tableIdent, targetLocation, table.location(), v1Metadata, v0Metadata, stagingLocation});
        Assertions.assertThat((List)result).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[0]).as("Should return correct latest version", new Object[0])).isEqualTo((Object)v1Metadata);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])result.get(0))[1]).as("Should return correct file_list_location", new Object[0])).isEqualTo((Object)expectedFileListLocation);
        this.checkFileListLocationCount((String)((Object[])result.get(0))[1], 4L);
    }

    @TestTemplate
    public void testProcedureWithInvalidInput() {
        String targetLocation = this.targetTableDir.toFile().toURI().toString();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_table_path('%s')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Missing required parameters: [source_prefix,target_prefix]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_table_path('%s','%s')", new Object[]{this.catalogName, this.tableIdent, targetLocation})).isInstanceOf(AnalysisException.class)).hasMessageContaining("Missing required parameters: [target_prefix]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_table_path('%s', '%s','%s')", new Object[]{this.catalogName, "notExists", targetLocation, targetLocation})).isInstanceOf(RuntimeException.class)).hasMessageContaining("Couldn't load table");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String v0Metadata = RewriteTablePathUtil.fileName((String)TableUtil.metadataFileLocation((Table)table));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_table_path(table => '%s', source_prefix => '%s', target_prefix => '%s', start_version => '%s')", new Object[]{this.catalogName, this.tableIdent, table.location(), targetLocation, "v20.metadata.json"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot find provided version file %s in metadata log.", new Object[]{"v20.metadata.json"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_table_path(table => '%s', source_prefix => '%s', target_prefix => '%s', start_version => '%s',end_version => '%s')", new Object[]{this.catalogName, this.tableIdent, table.location(), targetLocation, v0Metadata, "v11.metadata.json"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot find provided version file %s in metadata log.", new Object[]{"v11.metadata.json"});
    }

    private void checkFileListLocationCount(String fileListLocation, long expectedFileCount) {
        long fileCount = spark.read().format("text").load(fileListLocation).count();
        Assertions.assertThat((long)fileCount).isEqualTo(expectedFileCount);
    }
}

