/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.ExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSnapshotTableProcedure
extends ExtensionsTestBase {
    private static final String SOURCE_NAME = "spark_catalog.default.source";

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s PURGE", new Object[]{SOURCE_NAME});
    }

    @TestTemplate
    public void testSnapshot() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        Object result = this.scalarSql("CALL %s.system.snapshot('%s', '%s')", new Object[]{this.catalogName, SOURCE_NAME, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        String tableLocation = createdTable.location();
        ((AbstractStringAssert)Assertions.assertThat((String)tableLocation).as("Table should not have the original location", new Object[0])).isNotEqualTo((Object)location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testSnapshotWithProperties() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        Object result = this.scalarSql("CALL %s.system.snapshot(source_table => '%s', table => '%s', properties => map('foo','bar'))", new Object[]{this.catalogName, SOURCE_NAME, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        String tableLocation = createdTable.location();
        ((AbstractStringAssert)Assertions.assertThat((String)tableLocation).as("Table should not have the original location", new Object[0])).isNotEqualTo((Object)location);
        Map props = createdTable.properties();
        ((MapAssert)Assertions.assertThat((Map)props).as("Should have extra property set", new Object[0])).containsEntry((Object)"foo", (Object)"bar");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testSnapshotWithAlternateLocation() throws IOException {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("No Snapshoting with Alternate locations with Hadoop Catalogs", new Object[0])).doesNotContain(new CharSequence[]{"hadoop"});
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        String snapshotLocation = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        Object[] result = (Object[])this.sql("CALL %s.system.snapshot(source_table => '%s', table => '%s', location => '%s')", new Object[]{this.catalogName, SOURCE_NAME, this.tableName, snapshotLocation}).get(0);
        ((ObjectAssert)Assertions.assertThat((Object)result[0]).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        String storageLocation = this.validationCatalog.loadTable(this.tableIdent).location();
        ((AbstractStringAssert)Assertions.assertThat((String)storageLocation).as("Snapshot should be made at specified location", new Object[0])).isEqualTo(snapshotLocation);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testDropTable() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        Object result = this.scalarSql("CALL %s.system.snapshot('%s', '%s')", new Object[]{this.catalogName, SOURCE_NAME, this.tableName});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        this.sql("DROP TABLE %s", new Object[]{this.tableName});
        this.assertEquals("Source table should be intact", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{SOURCE_NAME}));
    }

    @TestTemplate
    public void testSnapshotWithConflictingProps() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        Object result = this.scalarSql("CALL %s.system.snapshot(source_table => '%s',table => '%s',properties => map('%s', 'true', 'snapshot', 'false'))", new Object[]{this.catalogName, SOURCE_NAME, this.tableName, "gc.enabled"});
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Should have added one file", new Object[0])).isEqualTo((Object)1L);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Map props = table.properties();
        ((MapAssert)Assertions.assertThat((Map)props).as("Should override user value", new Object[0])).containsEntry((Object)"snapshot", (Object)"true");
        ((MapAssert)Assertions.assertThat((Map)props).as("Should override user value", new Object[0])).containsEntry((Object)"gc.enabled", (Object)"false");
    }

    @TestTemplate
    public void testInvalidSnapshotsCases() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.snapshot('foo')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.snapshot('n', 't', map('foo', 'bar'))", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Wrong arg type for location");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.snapshot('%s', 'fable', 'loc', map(2, 1, 1))", new Object[]{this.catalogName, SOURCE_NAME})).isInstanceOf(AnalysisException.class)).hasMessageContaining("The `map` requires 2n (n > 0) parameters but the actual number is 3");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.snapshot('', 'dest')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument source_table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.snapshot('src', '')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
    }

    @TestTemplate
    public void testSnapshotWithParallelism() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{SOURCE_NAME});
        List result = this.sql("CALL %s.system.snapshot(source_table => '%s', table => '%s', parallelism => %d)", new Object[]{this.catalogName, SOURCE_NAME, this.tableName, 2});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{2L})), result);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{2L, "b"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @TestTemplate
    public void testSnapshotWithInvalidParallelism() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{SOURCE_NAME});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{SOURCE_NAME});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.snapshot(source_table => '%s', table => '%s', parallelism => %d)", new Object[]{this.catalogName, SOURCE_NAME, this.tableName, -1})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parallelism should be larger than 0");
    }

    @TestTemplate
    public void testSnapshotPartitionedWithParallelism() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet PARTITIONED BY (id) LOCATION '%s'", new Object[]{SOURCE_NAME, location});
        this.sql("INSERT INTO TABLE %s (id, data) VALUES (1, 'a'), (2, 'b')", new Object[]{SOURCE_NAME});
        List result = this.sql("CALL %s.system.snapshot(source_table => '%s', table => '%s', parallelism => %d)", new Object[]{this.catalogName, SOURCE_NAME, this.tableName, 2});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{2L})), result);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{"a", 1L}), (Object)this.row(new Object[]{"b", 2L})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }
}

