/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.BranchOptions;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.CreateOrReplaceBranchExec$;
import org.apache.spark.sql.execution.datasources.v2.LeafV2CommandExec;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u0015+\u0001fB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t9\u0002\u0011\t\u0012)A\u0005+\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005c\u0001\tE\t\u0015!\u0003`\u0011!\u0019\u0007A!f\u0001\n\u0003!\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011B3\t\u00119\u0004!Q3A\u0005\u0002=D\u0001B\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\tw\u0002\u0011)\u001a!C\u0001y\"I\u0011\u0011\u0001\u0001\u0003\u0012\u0003\u0006I! \u0005\n\u0003\u0007\u0001!Q3A\u0005\u0002qD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B?\t\u0013\u0005\u001d\u0001A!f\u0001\n\u0003a\b\"CA\u0005\u0001\tE\t\u0015!\u0003~\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bA!\"a\b\u0001\u0011\u000b\u0007I\u0011IA\u0011\u0011\u001d\t)\u0004\u0001C)\u0003oAq!a\u0011\u0001\t\u0003\n)\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003w\u0002\u0011\u0013!C\u0001\u0003{B\u0011\"!!\u0001#\u0003%\t!a!\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005%\u0005\"CAG\u0001E\u0005I\u0011AAH\u0011%\t\u0019\nAI\u0001\n\u0003\ty\tC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0010\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0014\u0005\n\u0003S\u0003\u0011\u0011!C\u0001\u0003WC\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005m\u0006!!A\u0005B\u0005u\u0006\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\t\t\u000eAA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\u001eI\u0011Q\u001c\u0016\u0002\u0002#\u0005\u0011q\u001c\u0004\tS)\n\t\u0011#\u0001\u0002b\"9\u00111B\u0012\u0005\u0002\u0005e\b\"CA~G\u0005\u0005IQIA\u007f\u0011%\typIA\u0001\n\u0003\u0013\t\u0001C\u0005\u0003\u0012\r\n\t\u0011\"!\u0003\u0014!I!QE\u0012\u0002\u0002\u0013%!q\u0005\u0002\u001a\u0007J,\u0017\r^3PeJ+\u0007\u000f\\1dK\n\u0013\u0018M\\2i\u000bb,7M\u0003\u0002,Y\u0005\u0011aO\r\u0006\u0003[9\n1\u0002Z1uCN|WO]2fg*\u0011q\u0006M\u0001\nKb,7-\u001e;j_:T!!\r\u001a\u0002\u0007M\fHN\u0003\u00024i\u0005)1\u000f]1sW*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001e?\u0003\u001e\u0003\"a\u000f\u001f\u000e\u0003)J!!\u0010\u0016\u0003\u001bY\u00134i\\7nC:$W\t_3d!\tYt(\u0003\u0002AU\t\tB*Z1g-J\u001au.\\7b]\u0012,\u00050Z2\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\n\u0015\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001\u0014\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015BA(D\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0015*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005=\u001b\u0015aB2bi\u0006dwnZ\u000b\u0002+B\u0011aKW\u0007\u0002/*\u00111\u000b\u0017\u0006\u00033B\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005m;&\u0001\u0004+bE2,7)\u0019;bY><\u0017\u0001C2bi\u0006dwn\u001a\u0011\u0002\u000b%$WM\u001c;\u0016\u0003}\u0003\"A\u00161\n\u0005\u0005<&AC%eK:$\u0018NZ5fe\u00061\u0011\u000eZ3oi\u0002\naA\u0019:b]\u000eDW#A3\u0011\u0005\u0019TgBA4i!\tQ5)\u0003\u0002j\u0007\u00061\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI7)A\u0004ce\u0006t7\r\u001b\u0011\u0002\u001b\t\u0014\u0018M\\2i\u001fB$\u0018n\u001c8t+\u0005\u0001\bCA9y\u001b\u0005\u0011(BA:u\u0003\u001dawnZ5dC2T!!\u001e<\u0002\u000bAd\u0017M\\:\u000b\u0005]\u0004\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0014(!\u0004\"sC:\u001c\u0007n\u00149uS>t7/\u0001\bce\u0006t7\r[(qi&|gn\u001d\u0011\u0002\r\r\u0014X-\u0019;f+\u0005i\bC\u0001\"\u007f\u0013\ty8IA\u0004C_>dW-\u00198\u0002\u000f\r\u0014X-\u0019;fA\u00059!/\u001a9mC\u000e,\u0017\u0001\u0003:fa2\f7-\u001a\u0011\u0002\u0017%4gj\u001c;Fq&\u001cHo]\u0001\rS\u001atu\u000e^#ySN$8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0001CA\u001e\u0001\u0011\u0015\u0019v\u00021\u0001V\u0011\u0015iv\u00021\u0001`\u0011\u0015\u0019w\u00021\u0001f\u0011\u0015qw\u00021\u0001q\u0011\u0015Yx\u00021\u0001~\u0011\u0019\t\u0019a\u0004a\u0001{\"1\u0011qA\bA\u0002u\faa\\;uaV$XCAA\u0012!\u0015A\u0015QEA\u0015\u0013\r\t9C\u0015\u0002\u0004'\u0016\f\b\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=b/A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\u001a\u0003[\u0011\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u0007I,h\u000e\u0006\u0002\u0002:A)\u0001*!\n\u0002<A!\u0011QHA \u001b\u00051\u0018bAA!m\nY\u0011J\u001c;fe:\fGNU8x\u00031\u0019\u0018.\u001c9mKN#(/\u001b8h)\r)\u0017q\t\u0005\b\u0003\u0013\u0012\u0002\u0019AA&\u0003%i\u0017\r\u001f$jK2$7\u000fE\u0002C\u0003\u001bJ1!a\u0014D\u0005\rIe\u000e^\u0001\u0005G>\u0004\u0018\u0010\u0006\t\u0002\u0010\u0005U\u0013qKA-\u00037\ni&a\u0018\u0002b!91k\u0005I\u0001\u0002\u0004)\u0006bB/\u0014!\u0003\u0005\ra\u0018\u0005\bGN\u0001\n\u00111\u0001f\u0011\u001dq7\u0003%AA\u0002ADqa_\n\u0011\u0002\u0003\u0007Q\u0010\u0003\u0005\u0002\u0004M\u0001\n\u00111\u0001~\u0011!\t9a\u0005I\u0001\u0002\u0004i\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003OR3!VA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u007fR3aXA5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\"+\u0007\u0015\fI'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005-%f\u00019\u0002j\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAAIU\ri\u0018\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bA\u0001\\1oO*\u0011\u0011QU\u0001\u0005U\u00064\u0018-C\u0002l\u0003?\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0013\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011WA\\!\r\u0011\u00151W\u0005\u0004\u0003k\u001b%aA!os\"I\u0011\u0011X\u000f\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0006CBAa\u0003\u000f\f\t,\u0004\u0002\u0002D*\u0019\u0011QY\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0006\r'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!`Ah\u0011%\tIlHA\u0001\u0002\u0004\t\t,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAN\u0003+D\u0011\"!/!\u0003\u0003\u0005\r!a\u0013\u0002\r\u0015\fX/\u00197t)\ri\u00181\u001c\u0005\n\u0003s\u000b\u0013\u0011!a\u0001\u0003c\u000b\u0011d\u0011:fCR,wJ\u001d*fa2\f7-\u001a\"sC:\u001c\u0007.\u0012=fGB\u00111hI\n\u0006G\u0005\r\u0018q\u001e\t\u000e\u0003K\fY/V0favlX0a\u0004\u000e\u0005\u0005\u001d(bAAu\u0007\u00069!/\u001e8uS6,\u0017\u0002BAw\u0003O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c88!\u0011\t\t0a>\u000e\u0005\u0005M(\u0002BA{\u0003G\u000b!![8\n\u0007E\u000b\u0019\u0010\u0006\u0002\u0002`\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001c\u0006)\u0011\r\u001d9msR\u0001\u0012q\u0002B\u0002\u0005\u000b\u00119A!\u0003\u0003\f\t5!q\u0002\u0005\u0006'\u001a\u0002\r!\u0016\u0005\u0006;\u001a\u0002\ra\u0018\u0005\u0006G\u001a\u0002\r!\u001a\u0005\u0006]\u001a\u0002\r\u0001\u001d\u0005\u0006w\u001a\u0002\r! \u0005\u0007\u0003\u00071\u0003\u0019A?\t\r\u0005\u001da\u00051\u0001~\u0003\u001d)h.\u00199qYf$BA!\u0006\u0003\"A)!Ia\u0006\u0003\u001c%\u0019!\u0011D\"\u0003\r=\u0003H/[8o!)\u0011%QD+`KBlX0`\u0005\u0004\u0005?\u0019%A\u0002+va2,w\u0007C\u0005\u0003$\u001d\n\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t%\u0002\u0003BAO\u0005WIAA!\f\u0002 \n1qJ\u00196fGR\u0004")
public class CreateOrReplaceBranchExec
extends V2CommandExec
implements LeafV2CommandExec {
    private Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier ident;
    private final String branch;
    private final BranchOptions branchOptions;
    private final boolean create;
    private final boolean replace;
    private final boolean ifNotExists;
    private volatile boolean bitmap$0;

    public static Option<Tuple7<TableCatalog, Identifier, String, BranchOptions, Object, Object, Object>> unapply(CreateOrReplaceBranchExec x$0) {
        return CreateOrReplaceBranchExec$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple7<TableCatalog, Identifier, String, BranchOptions, Object, Object, Object>, CreateOrReplaceBranchExec> tupled() {
        return CreateOrReplaceBranchExec$.MODULE$.tupled();
    }

    public static Function1<TableCatalog, Function1<Identifier, Function1<String, Function1<BranchOptions, Function1<Object, Function1<Object, Function1<Object, CreateOrReplaceBranchExec>>>>>>> curried() {
        return CreateOrReplaceBranchExec$.MODULE$.curried();
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier ident() {
        return this.ident;
    }

    public String branch() {
        return this.branch;
    }

    public BranchOptions branchOptions() {
        return this.branchOptions;
    }

    public boolean create() {
        return this.create;
    }

    public boolean replace() {
        return this.replace;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private Seq<Attribute> output$lzycompute() {
        CreateOrReplaceBranchExec createOrReplaceBranchExec = this;
        synchronized (createOrReplaceBranchExec) {
            if (!this.bitmap$0) {
                this.output = Nil$.MODULE$;
                this.bitmap$0 = true;
            }
        }
        return this.output;
    }

    public Seq<Attribute> output() {
        if (!this.bitmap$0) {
            return this.output$lzycompute();
        }
        return this.output;
    }

    public Seq<InternalRow> run() {
        ManageSnapshots manageSnapshots;
        Table table = this.catalog().loadTable(this.ident());
        if (table instanceof SparkTable) {
            BoxedUnit boxedUnit;
            boolean refExists;
            SparkTable sparkTable = (SparkTable)table;
            Long snapshotId = (Long)this.branchOptions().snapshotId().orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)sparkTable.table().currentSnapshot()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.snapshotId()))).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            manageSnapshots = sparkTable.table().manageSnapshots();
            boolean bl = refExists = sparkTable.table().refs().get(this.branch()) != null;
            if (this.create() && this.replace() && !refExists) {
                this.safeCreateBranch$1(snapshotId, manageSnapshots);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.replace()) {
                Preconditions.checkArgument((snapshotId != null ? 1 : 0) != 0, (String)"Cannot complete replace branch operation on %s, main has no snapshot", (Object)this.ident());
                boxedUnit = manageSnapshots.replaceBranch(this.branch(), Predef$.MODULE$.Long2long(snapshotId));
            } else {
                if (refExists && this.ifNotExists()) {
                    return Nil$.MODULE$;
                }
                this.safeCreateBranch$1(snapshotId, manageSnapshots);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new UnsupportedOperationException("Cannot create or replace branch on non-Iceberg table: " + table);
        }
        Object object = this.branchOptions().numSnapshots().nonEmpty() ? manageSnapshots.setMinSnapshotsToKeep(this.branch(), (int)BoxesRunTime.unboxToLong((Object)this.branchOptions().numSnapshots().get())) : BoxedUnit.UNIT;
        Object object2 = this.branchOptions().snapshotRetain().nonEmpty() ? manageSnapshots.setMaxSnapshotAgeMs(this.branch(), BoxesRunTime.unboxToLong((Object)this.branchOptions().snapshotRetain().get())) : BoxedUnit.UNIT;
        Object object3 = this.branchOptions().snapshotRefRetain().nonEmpty() ? manageSnapshots.setMaxRefAgeMs(this.branch(), BoxesRunTime.unboxToLong((Object)this.branchOptions().snapshotRefRetain().get())) : BoxedUnit.UNIT;
        manageSnapshots.commit();
        return Nil$.MODULE$;
    }

    public String simpleString(int maxFields) {
        return "CreateOrReplace branch: " + this.branch() + " for table: " + CatalogV2Implicits$.MODULE$.IdentifierHelper(this.ident()).quoted();
    }

    public CreateOrReplaceBranchExec copy(TableCatalog catalog, Identifier ident, String branch, BranchOptions branchOptions, boolean create, boolean replace, boolean ifNotExists) {
        return new CreateOrReplaceBranchExec(catalog, ident, branch, branchOptions, create, replace, ifNotExists);
    }

    public TableCatalog copy$default$1() {
        return this.catalog();
    }

    public Identifier copy$default$2() {
        return this.ident();
    }

    public String copy$default$3() {
        return this.branch();
    }

    public BranchOptions copy$default$4() {
        return this.branchOptions();
    }

    public boolean copy$default$5() {
        return this.create();
    }

    public boolean copy$default$6() {
        return this.replace();
    }

    public boolean copy$default$7() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateOrReplaceBranchExec";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.catalog();
            }
            case 1: {
                return this.ident();
            }
            case 2: {
                return this.branch();
            }
            case 3: {
                return this.branchOptions();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.create());
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.replace());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateOrReplaceBranchExec;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "catalog";
            }
            case 1: {
                return "ident";
            }
            case 2: {
                return "branch";
            }
            case 3: {
                return "branchOptions";
            }
            case 4: {
                return "create";
            }
            case 5: {
                return "replace";
            }
            case 6: {
                return "ifNotExists";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateOrReplaceBranchExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateOrReplaceBranchExec createOrReplaceBranchExec = (CreateOrReplaceBranchExec)((Object)x$1);
        if (this.create() != createOrReplaceBranchExec.create()) return false;
        if (this.replace() != createOrReplaceBranchExec.replace()) return false;
        if (this.ifNotExists() != createOrReplaceBranchExec.ifNotExists()) return false;
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = createOrReplaceBranchExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.ident();
        Identifier identifier2 = createOrReplaceBranchExec.ident();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        String string = this.branch();
        String string2 = createOrReplaceBranchExec.branch();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        BranchOptions branchOptions = this.branchOptions();
        BranchOptions branchOptions2 = createOrReplaceBranchExec.branchOptions();
        if (branchOptions == null) {
            if (branchOptions2 != null) {
                return false;
            }
        } else if (!((Object)branchOptions).equals(branchOptions2)) return false;
        if (!createOrReplaceBranchExec.canEqual((Object)this)) return false;
        return true;
    }

    private final void safeCreateBranch$1(Long snapshotId$1, ManageSnapshots manageSnapshots$1) {
        if (snapshotId$1 == null) {
            manageSnapshots$1.createBranch(this.branch());
            return;
        }
        manageSnapshots$1.createBranch(this.branch(), Predef$.MODULE$.Long2long(snapshotId$1));
    }

    public CreateOrReplaceBranchExec(TableCatalog catalog, Identifier ident, String branch, BranchOptions branchOptions, boolean create, boolean replace, boolean ifNotExists) {
        this.catalog = catalog;
        this.ident = ident;
        this.branch = branch;
        this.branchOptions = branchOptions;
        this.create = create;
        this.replace = replace;
        this.ifNotExists = ifNotExists;
        LeafLike.$init$((LeafLike)this);
    }
}

