/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.TagOptions;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.CreateOrReplaceTagExec$;
import org.apache.spark.sql.execution.datasources.v2.LeafV2CommandExec;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u0015+\u0001fB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t9\u0002\u0011\t\u0012)A\u0005+\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005c\u0001\tE\t\u0015!\u0003`\u0011!\u0019\u0007A!f\u0001\n\u0003!\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011B3\t\u00119\u0004!Q3A\u0005\u0002=D\u0001B\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\tw\u0002\u0011)\u001a!C\u0001y\"I\u0011\u0011\u0001\u0001\u0003\u0012\u0003\u0006I! \u0005\n\u0003\u0007\u0001!Q3A\u0005\u0002qD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B?\t\u0013\u0005\u001d\u0001A!f\u0001\n\u0003a\b\"CA\u0005\u0001\tE\t\u0015!\u0003~\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bA!\"a\b\u0001\u0011\u000b\u0007I\u0011IA\u0011\u0011\u001d\t)\u0004\u0001C)\u0003oAq!a\u0011\u0001\t\u0003\n)\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003w\u0002\u0011\u0013!C\u0001\u0003{B\u0011\"!!\u0001#\u0003%\t!a!\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005%\u0005\"CAG\u0001E\u0005I\u0011AAH\u0011%\t\u0019\nAI\u0001\n\u0003\ty\tC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0010\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0014\u0005\n\u0003S\u0003\u0011\u0011!C\u0001\u0003WC\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005m\u0006!!A\u0005B\u0005u\u0006\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\t\t\u000eAA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\u001eI\u0011Q\u001c\u0016\u0002\u0002#\u0005\u0011q\u001c\u0004\tS)\n\t\u0011#\u0001\u0002b\"9\u00111B\u0012\u0005\u0002\u0005e\b\"CA~G\u0005\u0005IQIA\u007f\u0011%\typIA\u0001\n\u0003\u0013\t\u0001C\u0005\u0003\u0012\r\n\t\u0011\"!\u0003\u0014!I!QE\u0012\u0002\u0002\u0013%!q\u0005\u0002\u0017\u0007J,\u0017\r^3PeJ+\u0007\u000f\\1dKR\u000bw-\u0012=fG*\u00111\u0006L\u0001\u0003mJR!!\f\u0018\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003_A\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Qd(Q$\u0011\u0005mbT\"\u0001\u0016\n\u0005uR#!\u0004,3\u0007>lW.\u00198e\u000bb,7\r\u0005\u0002<\u007f%\u0011\u0001I\u000b\u0002\u0012\u0019\u0016\fgM\u0016\u001aD_6l\u0017M\u001c3Fq\u0016\u001c\u0007C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0011Bs!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051C\u0014A\u0002\u001fs_>$h(C\u0001E\u0013\ty5)A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&\u0001D*fe&\fG.\u001b>bE2,'BA(D\u0003\u001d\u0019\u0017\r^1m_\u001e,\u0012!\u0016\t\u0003-jk\u0011a\u0016\u0006\u0003'bS!!\u0017\u0019\u0002\u0013\r|gN\\3di>\u0014\u0018BA.X\u00051!\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013!B5eK:$X#A0\u0011\u0005Y\u0003\u0017BA1X\u0005)IE-\u001a8uS\u001aLWM]\u0001\u0007S\u0012,g\u000e\u001e\u0011\u0002\u0007Q\fw-F\u0001f!\t1'N\u0004\u0002hQB\u0011!jQ\u0005\u0003S\u000e\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011nQ\u0001\u0005i\u0006<\u0007%\u0001\u0006uC\u001e|\u0005\u000f^5p]N,\u0012\u0001\u001d\t\u0003cbl\u0011A\u001d\u0006\u0003gR\fq\u0001\\8hS\u000e\fGN\u0003\u0002vm\u0006)\u0001\u000f\\1og*\u0011q\u000fM\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011P\u001d\u0002\u000b)\u0006<w\n\u001d;j_:\u001c\u0018a\u0003;bO>\u0003H/[8og\u0002\naa\u0019:fCR,W#A?\u0011\u0005\ts\u0018BA@D\u0005\u001d\u0011un\u001c7fC:\fqa\u0019:fCR,\u0007%A\u0004sKBd\u0017mY3\u0002\u0011I,\u0007\u000f\\1dK\u0002\n1\"\u001b4O_R,\u00050[:ug\u0006a\u0011N\u001a(pi\u0016C\u0018n\u001d;tA\u00051A(\u001b8jiz\"\u0002#a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0011\u0005m\u0002\u0001\"B*\u0010\u0001\u0004)\u0006\"B/\u0010\u0001\u0004y\u0006\"B2\u0010\u0001\u0004)\u0007\"\u00028\u0010\u0001\u0004\u0001\b\"B>\u0010\u0001\u0004i\bBBA\u0002\u001f\u0001\u0007Q\u0010\u0003\u0004\u0002\b=\u0001\r!`\u0001\u0007_V$\b/\u001e;\u0016\u0005\u0005\r\u0002#\u0002%\u0002&\u0005%\u0012bAA\u0014%\n\u00191+Z9\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\fw\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005M\u0012Q\u0006\u0002\n\u0003R$(/\u001b2vi\u0016\f1A];o)\t\tI\u0004E\u0003I\u0003K\tY\u0004\u0005\u0003\u0002>\u0005}R\"\u0001<\n\u0007\u0005\u0005cOA\u0006J]R,'O\\1m%><\u0018\u0001D:j[BdWm\u0015;sS:<GcA3\u0002H!9\u0011\u0011\n\nA\u0002\u0005-\u0013!C7bq\u001aKW\r\u001c3t!\r\u0011\u0015QJ\u0005\u0004\u0003\u001f\u001a%aA%oi\u0006!1m\u001c9z)A\ty!!\u0016\u0002X\u0005e\u00131LA/\u0003?\n\t\u0007C\u0004T'A\u0005\t\u0019A+\t\u000fu\u001b\u0002\u0013!a\u0001?\"91m\u0005I\u0001\u0002\u0004)\u0007b\u00028\u0014!\u0003\u0005\r\u0001\u001d\u0005\bwN\u0001\n\u00111\u0001~\u0011!\t\u0019a\u0005I\u0001\u0002\u0004i\b\u0002CA\u0004'A\u0005\t\u0019A?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\r\u0016\u0004+\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U4)\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0010\u0016\u0004?\u0006%\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000bS3!ZA5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a#+\u0007A\fI'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005E%fA?\u0002j\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014AD2paf$C-\u001a4bk2$HeN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005Y\u0006twM\u0003\u0002\u0002&\u0006!!.\u0019<b\u0013\rY\u0017qT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0017\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00022\u0006]\u0006c\u0001\"\u00024&\u0019\u0011QW\"\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002:v\t\t\u00111\u0001\u0002L\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a0\u0011\r\u0005\u0005\u0017qYAY\u001b\t\t\u0019MC\u0002\u0002F\u000e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI-a1\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004{\u0006=\u0007\"CA]?\u0005\u0005\t\u0019AAY\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u0015Q\u001b\u0005\n\u0003s\u0003\u0013\u0011!a\u0001\u0003\u0017\na!Z9vC2\u001cHcA?\u0002\\\"I\u0011\u0011X\u0011\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0017\u0007J,\u0017\r^3PeJ+\u0007\u000f\\1dKR\u000bw-\u0012=fGB\u00111hI\n\u0006G\u0005\r\u0018q\u001e\t\u000e\u0003K\fY/V0favlX0a\u0004\u000e\u0005\u0005\u001d(bAAu\u0007\u00069!/\u001e8uS6,\u0017\u0002BAw\u0003O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c88!\u0011\t\t0a>\u000e\u0005\u0005M(\u0002BA{\u0003G\u000b!![8\n\u0007E\u000b\u0019\u0010\u0006\u0002\u0002`\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001c\u0006)\u0011\r\u001d9msR\u0001\u0012q\u0002B\u0002\u0005\u000b\u00119A!\u0003\u0003\f\t5!q\u0002\u0005\u0006'\u001a\u0002\r!\u0016\u0005\u0006;\u001a\u0002\ra\u0018\u0005\u0006G\u001a\u0002\r!\u001a\u0005\u0006]\u001a\u0002\r\u0001\u001d\u0005\u0006w\u001a\u0002\r! \u0005\u0007\u0003\u00071\u0003\u0019A?\t\r\u0005\u001da\u00051\u0001~\u0003\u001d)h.\u00199qYf$BA!\u0006\u0003\"A)!Ia\u0006\u0003\u001c%\u0019!\u0011D\"\u0003\r=\u0003H/[8o!)\u0011%QD+`KBlX0`\u0005\u0004\u0005?\u0019%A\u0002+va2,w\u0007C\u0005\u0003$\u001d\n\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t%\u0002\u0003BAO\u0005WIAA!\f\u0002 \n1qJ\u00196fGR\u0004")
public class CreateOrReplaceTagExec
extends V2CommandExec
implements LeafV2CommandExec {
    private Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier ident;
    private final String tag;
    private final TagOptions tagOptions;
    private final boolean create;
    private final boolean replace;
    private final boolean ifNotExists;
    private volatile boolean bitmap$0;

    public static Option<Tuple7<TableCatalog, Identifier, String, TagOptions, Object, Object, Object>> unapply(CreateOrReplaceTagExec x$0) {
        return CreateOrReplaceTagExec$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple7<TableCatalog, Identifier, String, TagOptions, Object, Object, Object>, CreateOrReplaceTagExec> tupled() {
        return CreateOrReplaceTagExec$.MODULE$.tupled();
    }

    public static Function1<TableCatalog, Function1<Identifier, Function1<String, Function1<TagOptions, Function1<Object, Function1<Object, Function1<Object, CreateOrReplaceTagExec>>>>>>> curried() {
        return CreateOrReplaceTagExec$.MODULE$.curried();
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier ident() {
        return this.ident;
    }

    public String tag() {
        return this.tag;
    }

    public TagOptions tagOptions() {
        return this.tagOptions;
    }

    public boolean create() {
        return this.create;
    }

    public boolean replace() {
        return this.replace;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private Seq<Attribute> output$lzycompute() {
        CreateOrReplaceTagExec createOrReplaceTagExec = this;
        synchronized (createOrReplaceTagExec) {
            if (!this.bitmap$0) {
                this.output = Nil$.MODULE$;
                this.bitmap$0 = true;
            }
        }
        return this.output;
    }

    public Seq<Attribute> output() {
        if (!this.bitmap$0) {
            return this.output$lzycompute();
        }
        return this.output;
    }

    public Seq<InternalRow> run() {
        ManageSnapshots manageSnapshot;
        Table table = this.catalog().loadTable(this.ident());
        if (table instanceof SparkTable) {
            ManageSnapshots manageSnapshots;
            boolean refExists;
            SparkTable sparkTable = (SparkTable)table;
            Long snapshotId = (Long)this.tagOptions().snapshotId().orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)sparkTable.table().currentSnapshot()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.snapshotId()))).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Preconditions.checkArgument((snapshotId != null ? 1 : 0) != 0, (String)"Cannot complete create or replace tag operation on %s, main has no snapshot", (Object)this.ident());
            manageSnapshot = sparkTable.table().manageSnapshots();
            boolean bl = refExists = sparkTable.table().refs().get(this.tag()) != null;
            if (this.create() && this.replace() && !refExists) {
                manageSnapshots = manageSnapshot.createTag(this.tag(), Predef$.MODULE$.Long2long(snapshotId));
            } else if (this.replace()) {
                manageSnapshots = manageSnapshot.replaceTag(this.tag(), Predef$.MODULE$.Long2long(snapshotId));
            } else {
                if (refExists && this.ifNotExists()) {
                    return Nil$.MODULE$;
                }
                manageSnapshots = manageSnapshot.createTag(this.tag(), Predef$.MODULE$.Long2long(snapshotId));
            }
        } else {
            throw new UnsupportedOperationException("Cannot create tag to non-Iceberg table: " + table);
        }
        Object object = this.tagOptions().snapshotRefRetain().nonEmpty() ? manageSnapshot.setMaxRefAgeMs(this.tag(), BoxesRunTime.unboxToLong((Object)this.tagOptions().snapshotRefRetain().get())) : BoxedUnit.UNIT;
        manageSnapshot.commit();
        return Nil$.MODULE$;
    }

    public String simpleString(int maxFields) {
        return "Create tag: " + this.tag() + " for table: " + CatalogV2Implicits$.MODULE$.IdentifierHelper(this.ident()).quoted();
    }

    public CreateOrReplaceTagExec copy(TableCatalog catalog, Identifier ident, String tag, TagOptions tagOptions, boolean create, boolean replace, boolean ifNotExists) {
        return new CreateOrReplaceTagExec(catalog, ident, tag, tagOptions, create, replace, ifNotExists);
    }

    public TableCatalog copy$default$1() {
        return this.catalog();
    }

    public Identifier copy$default$2() {
        return this.ident();
    }

    public String copy$default$3() {
        return this.tag();
    }

    public TagOptions copy$default$4() {
        return this.tagOptions();
    }

    public boolean copy$default$5() {
        return this.create();
    }

    public boolean copy$default$6() {
        return this.replace();
    }

    public boolean copy$default$7() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateOrReplaceTagExec";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.catalog();
            }
            case 1: {
                return this.ident();
            }
            case 2: {
                return this.tag();
            }
            case 3: {
                return this.tagOptions();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.create());
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.replace());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateOrReplaceTagExec;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "catalog";
            }
            case 1: {
                return "ident";
            }
            case 2: {
                return "tag";
            }
            case 3: {
                return "tagOptions";
            }
            case 4: {
                return "create";
            }
            case 5: {
                return "replace";
            }
            case 6: {
                return "ifNotExists";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateOrReplaceTagExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateOrReplaceTagExec createOrReplaceTagExec = (CreateOrReplaceTagExec)((Object)x$1);
        if (this.create() != createOrReplaceTagExec.create()) return false;
        if (this.replace() != createOrReplaceTagExec.replace()) return false;
        if (this.ifNotExists() != createOrReplaceTagExec.ifNotExists()) return false;
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = createOrReplaceTagExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.ident();
        Identifier identifier2 = createOrReplaceTagExec.ident();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        String string = this.tag();
        String string2 = createOrReplaceTagExec.tag();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        TagOptions tagOptions = this.tagOptions();
        TagOptions tagOptions2 = createOrReplaceTagExec.tagOptions();
        if (tagOptions == null) {
            if (tagOptions2 != null) {
                return false;
            }
        } else if (!((Object)tagOptions).equals(tagOptions2)) return false;
        if (!createOrReplaceTagExec.canEqual((Object)this)) return false;
        return true;
    }

    public CreateOrReplaceTagExec(TableCatalog catalog, Identifier ident, String tag, TagOptions tagOptions, boolean create, boolean replace, boolean ifNotExists) {
        this.catalog = catalog;
        this.ident = ident;
        this.tag = tag;
        this.tagOptions = tagOptions;
        this.create = create;
        this.replace = replace;
        this.ifNotExists = ifNotExists;
        LeafLike.$init$((LeafLike)this);
    }
}

