/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.DropIdentifierFieldsExec$;
import org.apache.spark.sql.execution.datasources.v2.LeafV2CommandExec;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\u000f\u001f\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0013\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002\u00033\u0001\u0005#\u0005\u000b\u0011B-\t\u000b\u0015\u0004A\u0011\u00014\t\u0011-\u0004\u0001R1A\u0005B1DQA\u001e\u0001\u0005R]DQ! \u0001\u0005ByD\u0011\"!\u0003\u0001\u0003\u0003%\t!a\u0003\t\u0013\u0005M\u0001!%A\u0005\u0002\u0005U\u0001\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011%\t\t\u0004AI\u0001\n\u0003\t\u0019\u0004C\u0005\u00028\u0001\t\t\u0011\"\u0011\u0002:!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00111\n\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001fB\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\t\u0013\u0005-\u0004!!A\u0005\u0002\u00055\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u0011%\ti\bAA\u0001\n\u0003\nyhB\u0005\u0002\u0004z\t\t\u0011#\u0001\u0002\u0006\u001aAQDHA\u0001\u0012\u0003\t9\t\u0003\u0004f/\u0011\u0005\u0011q\u0014\u0005\n\u0003C;\u0012\u0011!C#\u0003GC\u0011\"!*\u0018\u0003\u0003%\t)a*\t\u0013\u0005=v#!A\u0005\u0002\u0006E\u0006\"CAb/\u0005\u0005I\u0011BAc\u0005a!%o\u001c9JI\u0016tG/\u001b4jKJ4\u0015.\u001a7eg\u0016CXm\u0019\u0006\u0003?\u0001\n!A\u001e\u001a\u000b\u0005\u0005\u0012\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!a\t\u0013\u0002\u0013\u0015DXmY;uS>t'BA\u0013'\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO\u000e\u00011#\u0002\u0001/eUZ\u0004CA\u00181\u001b\u0005q\u0012BA\u0019\u001f\u000551&gQ8n[\u0006tG-\u0012=fGB\u0011qfM\u0005\u0003iy\u0011\u0011\u0003T3bMZ\u00134i\\7nC:$W\t_3d!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0010#\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!-\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002Do\u00059\u0001/Y2lC\u001e,\u0017BA#G\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019u'A\u0004dCR\fGn\\4\u0016\u0003%\u0003\"A\u0013(\u000e\u0003-S!a\u0012'\u000b\u00055#\u0013!C2p]:,7\r^8s\u0013\ty5J\u0001\u0007UC\ndWmQ1uC2|w-\u0001\u0005dCR\fGn\\4!\u0003\u0015IG-\u001a8u+\u0005\u0019\u0006C\u0001&U\u0013\t)6J\u0001\u0006JI\u0016tG/\u001b4jKJ\fa!\u001b3f]R\u0004\u0013A\u00024jK2$7/F\u0001Z!\ra$\fX\u0005\u00037\u001a\u00131aU3r!\ti\u0016M\u0004\u0002_?B\u0011ahN\u0005\u0003A^\na\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001mN\u0001\bM&,G\u000eZ:!\u0003\u0019a\u0014N\\5u}Q!q\r[5k!\ty\u0003\u0001C\u0003H\u000f\u0001\u0007\u0011\nC\u0003R\u000f\u0001\u00071\u000bC\u0003X\u000f\u0001\u0007\u0011,\u0001\u0004pkR\u0004X\u000f^\u000b\u0002[B\u0019AH\u00178\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018aC3yaJ,7o]5p]NT!a\u001d\u0013\u0002\u0011\r\fG/\u00197zgRL!!\u001e9\u0003\u0013\u0005#HO]5ckR,\u0017a\u0001:v]R\t\u0001\u0010E\u0002=5f\u0004\"A_>\u000e\u0003IL!\u0001 :\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\rg&l\u0007\u000f\\3TiJLgn\u001a\u000b\u00039~Dq!!\u0001\u000b\u0001\u0004\t\u0019!A\u0005nCb4\u0015.\u001a7egB\u0019a'!\u0002\n\u0007\u0005\u001dqGA\u0002J]R\fAaY8qsR9q-!\u0004\u0002\u0010\u0005E\u0001bB$\f!\u0003\u0005\r!\u0013\u0005\b#.\u0001\n\u00111\u0001T\u0011\u001d96\u0002%AA\u0002e\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0018)\u001a\u0011*!\u0007,\u0005\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\n8\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\tyBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00020)\u001a1+!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0007\u0016\u00043\u0006e\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00027b]\u001eT!!!\u0012\u0002\t)\fg/Y\u0005\u0004E\u0006}\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0002\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0015\u0002XA\u0019a'a\u0015\n\u0007\u0005UsGA\u0002B]fD\u0011\"!\u0017\u0012\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0006\u0005\u0004\u0002b\u0005\u001d\u0014\u0011K\u0007\u0003\u0003GR1!!\u001a8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\n\u0019G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA8\u0003k\u00022ANA9\u0013\r\t\u0019h\u000e\u0002\b\u0005>|G.Z1o\u0011%\tIfEA\u0001\u0002\u0004\t\t&\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u001e\u0003wB\u0011\"!\u0017\u0015\u0003\u0003\u0005\r!a\u0001\u0002\r\u0015\fX/\u00197t)\u0011\ty'!!\t\u0013\u0005eS#!AA\u0002\u0005E\u0013\u0001\u0007#s_BLE-\u001a8uS\u001aLWM\u001d$jK2$7/\u0012=fGB\u0011qfF\n\u0006/\u0005%\u0015Q\u0013\t\t\u0003\u0017\u000b\t*S*ZO6\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f;\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003'\u000biIA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000b\u0019%\u0001\u0002j_&\u0019Q)!'\u0015\u0005\u0005\u0015\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0012!B1qa2LHcB4\u0002*\u0006-\u0016Q\u0016\u0005\u0006\u000fj\u0001\r!\u0013\u0005\u0006#j\u0001\ra\u0015\u0005\u0006/j\u0001\r!W\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019,a0\u0011\u000bY\n),!/\n\u0007\u0005]vG\u0001\u0004PaRLwN\u001c\t\u0007m\u0005m\u0016jU-\n\u0007\u0005uvG\u0001\u0004UkBdWm\r\u0005\t\u0003\u0003\\\u0012\u0011!a\u0001O\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u001d\u0007\u0003BA\u001f\u0003\u0013LA!a3\u0002@\t1qJ\u00196fGR\u0004")
public class DropIdentifierFieldsExec
extends V2CommandExec
implements LeafV2CommandExec {
    private Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier ident;
    private final Seq<String> fields;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableCatalog, Identifier, Seq<String>>> unapply(DropIdentifierFieldsExec x$0) {
        return DropIdentifierFieldsExec$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableCatalog, Identifier, Seq<String>>, DropIdentifierFieldsExec> tupled() {
        return DropIdentifierFieldsExec$.MODULE$.tupled();
    }

    public static Function1<TableCatalog, Function1<Identifier, Function1<Seq<String>, DropIdentifierFieldsExec>>> curried() {
        return DropIdentifierFieldsExec$.MODULE$.curried();
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier ident() {
        return this.ident;
    }

    public Seq<String> fields() {
        return this.fields;
    }

    private Seq<Attribute> output$lzycompute() {
        DropIdentifierFieldsExec dropIdentifierFieldsExec = this;
        synchronized (dropIdentifierFieldsExec) {
            if (!this.bitmap$0) {
                this.output = Nil$.MODULE$;
                this.bitmap$0 = true;
            }
        }
        return this.output;
    }

    public Seq<Attribute> output() {
        if (!this.bitmap$0) {
            return this.output$lzycompute();
        }
        return this.output;
    }

    public Seq<InternalRow> run() {
        Table table = this.catalog().loadTable(this.ident());
        if (!(table instanceof SparkTable)) {
            throw new UnsupportedOperationException("Cannot drop identifier fields in non-Iceberg table: " + table);
        }
        SparkTable sparkTable = (SparkTable)table;
        Schema schema = sparkTable.table().schema();
        HashSet identifierFieldNames = Sets.newHashSet((Iterable)schema.identifierFieldNames());
        this.fields().foreach((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DropIdentifierFieldsExec.$anonfun$run$1(schema, identifierFieldNames, name)));
        sparkTable.table().updateSchema().setIdentifierFields((Collection)identifierFieldNames).commit();
        return Nil$.MODULE$;
    }

    public String simpleString(int maxFields) {
        return "DropIdentifierFields " + this.catalog().name() + "." + CatalogV2Implicits$.MODULE$.IdentifierHelper(this.ident()).quoted() + " (" + CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(this.fields()).quoted() + ")";
    }

    public DropIdentifierFieldsExec copy(TableCatalog catalog, Identifier ident, Seq<String> fields) {
        return new DropIdentifierFieldsExec(catalog, ident, fields);
    }

    public TableCatalog copy$default$1() {
        return this.catalog();
    }

    public Identifier copy$default$2() {
        return this.ident();
    }

    public Seq<String> copy$default$3() {
        return this.fields();
    }

    public String productPrefix() {
        return "DropIdentifierFieldsExec";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.catalog();
            }
            case 1: {
                return this.ident();
            }
            case 2: {
                return this.fields();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropIdentifierFieldsExec;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "catalog";
            }
            case 1: {
                return "ident";
            }
            case 2: {
                return "fields";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropIdentifierFieldsExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropIdentifierFieldsExec dropIdentifierFieldsExec = (DropIdentifierFieldsExec)((Object)x$1);
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = dropIdentifierFieldsExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.ident();
        Identifier identifier2 = dropIdentifierFieldsExec.ident();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        Seq<String> seq = this.fields();
        Seq<String> seq2 = dropIdentifierFieldsExec.fields();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!dropIdentifierFieldsExec.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$run$1(Schema schema$1, HashSet identifierFieldNames$1, String name) {
        Preconditions.checkArgument((schema$1.findField(name) != null ? 1 : 0) != 0, (String)"Cannot complete drop identifier fields operation: field %s not found", (Object)name);
        Preconditions.checkArgument((boolean)identifierFieldNames$1.contains(name), (String)"Cannot complete drop identifier fields operation: %s is not an identifier field", (Object)name);
        return identifierFieldNames$1.remove(name);
    }

    public DropIdentifierFieldsExec(TableCatalog catalog, Identifier ident, Seq<String> fields) {
        this.catalog = catalog;
        this.ident = ident;
        this.fields = fields;
        LeafLike.$init$((LeafLike)this);
    }
}

