/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;

abstract class BaseMetadataTable
implements Table {
    private PartitionSpec spec = PartitionSpec.unpartitioned();

    BaseMetadataTable() {
    }

    abstract Table table();

    abstract String metadataTableName();

    @Override
    public FileIO io() {
        return this.table().io();
    }

    @Override
    public EncryptionManager encryption() {
        return this.table().encryption();
    }

    @Override
    public LocationProvider locationProvider() {
        return this.table().locationProvider();
    }

    @Override
    public void refresh() {
        this.table().refresh();
    }

    @Override
    public PartitionSpec spec() {
        return this.spec;
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return ImmutableMap.of(this.spec.specId(), this.spec);
    }

    @Override
    public Map<String, String> properties() {
        return ImmutableMap.of();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.table().currentSnapshot();
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.table().snapshots();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.table().snapshot(snapshotId);
    }

    @Override
    public List<HistoryEntry> history() {
        return this.table().history();
    }

    @Override
    public UpdateSchema updateSchema() {
        throw new UnsupportedOperationException("Cannot update the schema of a metadata table");
    }

    @Override
    public UpdateProperties updateProperties() {
        throw new UnsupportedOperationException("Cannot update the properties of a metadata table");
    }

    @Override
    public UpdateLocation updateLocation() {
        throw new UnsupportedOperationException("Cannot update the location of a metadata table");
    }

    @Override
    public AppendFiles newAppend() {
        throw new UnsupportedOperationException("Cannot append to a metadata table");
    }

    @Override
    public RewriteFiles newRewrite() {
        throw new UnsupportedOperationException("Cannot rewrite in a metadata table");
    }

    @Override
    public RewriteManifests rewriteManifests() {
        throw new UnsupportedOperationException("Cannot rewrite manifests in a metadata table");
    }

    @Override
    public OverwriteFiles newOverwrite() {
        throw new UnsupportedOperationException("Cannot overwrite in a metadata table");
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        throw new UnsupportedOperationException("Cannot replace partitions in a metadata table");
    }

    @Override
    public DeleteFiles newDelete() {
        throw new UnsupportedOperationException("Cannot delete from a metadata table");
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        throw new UnsupportedOperationException("Cannot expire snapshots from a metadata table");
    }

    @Override
    public Rollback rollback() {
        throw new UnsupportedOperationException("Cannot roll back a metadata table");
    }

    @Override
    public Transaction newTransaction() {
        throw new UnsupportedOperationException("Cannot create transactions for a metadata table");
    }

    public String toString() {
        return this.table().toString() + "." + this.metadataTableName();
    }
}

