/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;

public class BaseReplacePartitions
extends MergingSnapshotProducer<ReplacePartitions>
implements ReplacePartitions {
    BaseReplacePartitions(TableOperations ops) {
        super(ops);
    }

    @Override
    protected ReplacePartitions self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    @Override
    public ReplacePartitions addFile(DataFile file) {
        this.dropPartition(file.partition());
        this.add(file);
        return this;
    }

    @Override
    public ReplacePartitions validateAppendOnly() {
        this.failAnyDelete();
        return this;
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        if (this.writeSpec().fields().size() <= 0) {
            this.deleteByRowFilter(Expressions.alwaysTrue());
        }
        try {
            return super.apply(base);
        }
        catch (MergingSnapshotProducer.DeleteException e) {
            throw new ValidationException("Cannot commit file that conflicts with existing partition: %s", e.partition());
        }
    }
}

