/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;

class BaseRewriteFiles
extends MergingSnapshotProducer<RewriteFiles>
implements RewriteFiles {
    BaseRewriteFiles(TableOperations ops) {
        super(ops);
        this.failMissingDeletePaths();
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    @Override
    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        Preconditions.checkArgument(filesToDelete != null && !filesToDelete.isEmpty(), "Files to delete cannot be null or empty");
        Preconditions.checkArgument(filesToAdd != null && !filesToAdd.isEmpty(), "Files to add can not be null or empty");
        for (DataFile toDelete : filesToDelete) {
            this.delete(toDelete);
        }
        for (DataFile toAdd : filesToAdd) {
            this.add(toAdd);
        }
        return this;
    }
}

