/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.shaded.com.google.common.base.Objects;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;

class BaseSnapshot
implements Snapshot {
    private final TableOperations ops;
    private final long snapshotId;
    private final Long parentId;
    private final long timestampMillis;
    private final InputFile manifestList;
    private final String operation;
    private final Map<String, String> summary;
    private List<ManifestFile> manifests = null;
    private List<DataFile> cachedAdds = null;
    private List<DataFile> cachedDeletes = null;

    BaseSnapshot(TableOperations ops, long snapshotId, String ... manifestFiles) {
        this(ops, snapshotId, null, System.currentTimeMillis(), null, null, Lists.transform(Arrays.asList(manifestFiles), path -> new GenericManifestFile(ops.io().newInputFile((String)path), 0)));
    }

    BaseSnapshot(TableOperations ops, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, InputFile manifestList) {
        this.ops = ops;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.manifestList = manifestList;
    }

    BaseSnapshot(TableOperations ops, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, List<ManifestFile> manifests) {
        this(ops, snapshotId, parentId, timestampMillis, operation, summary, (InputFile)null);
        this.manifests = manifests;
    }

    @Override
    public long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Long parentId() {
        return this.parentId;
    }

    @Override
    public long timestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Map<String, String> summary() {
        return this.summary;
    }

    @Override
    public List<ManifestFile> manifests() {
        if (this.manifests == null) {
            try (AvroIterable files = Avro.read(this.manifestList).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).project(ManifestFile.schema()).reuseContainers(false).build();){
                this.manifests = Lists.newLinkedList(files);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Cannot read snapshot file: %s", this.manifestList.location());
            }
        }
        return this.manifests;
    }

    public List<DataFile> addedFiles() {
        if (this.cachedAdds == null) {
            this.cacheChanges();
        }
        return this.cachedAdds;
    }

    public List<DataFile> deletedFiles() {
        if (this.cachedDeletes == null) {
            this.cacheChanges();
        }
        return this.cachedDeletes;
    }

    @Override
    public String manifestListLocation() {
        return this.manifestList != null ? this.manifestList.location() : null;
    }

    private void cacheChanges() {
        ImmutableList.Builder adds = ImmutableList.builder();
        ImmutableList.Builder deletes = ImmutableList.builder();
        Iterable<ManifestFile> changedManifests = Iterables.filter(this.manifests(), manifest -> Objects.equal(manifest.snapshotId(), this.snapshotId));
        try (CloseableIterable<ManifestEntry> entries = new ManifestGroup(this.ops, changedManifests).ignoreExisting().select(ManifestReader.CHANGE_WITH_STATS_COLUMNS).entries();){
            block11: for (ManifestEntry entry : entries) {
                switch (entry.status()) {
                    case ADDED: {
                        adds.add(entry.file().copy());
                        continue block11;
                    }
                    case DELETED: {
                        deletes.add(entry.file().copyWithoutStats());
                        continue block11;
                    }
                }
                throw new IllegalStateException("Unexpected entry status, not added or deleted: " + entry);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close entries while caching changes", new Object[0]);
        }
        this.cachedAdds = adds.build();
        this.cachedDeletes = deletes.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.snapshotId).add("timestamp_ms", this.timestampMillis).add("operation", this.operation).add("summary", this.summary).add("manifests", this.manifests()).toString();
    }
}

