/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;

public class DataFilesTable
extends BaseMetadataTable {
    private final TableOperations ops;
    private final Table table;

    public DataFilesTable(TableOperations ops, Table table) {
        this.ops = ops;
        this.table = table;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    String metadataTableName() {
        return "files";
    }

    @Override
    public TableScan newScan() {
        return new FilesTableScan(this.ops, this.table, this.schema());
    }

    @Override
    public Schema schema() {
        Schema schema = new Schema(DataFile.getType(this.table.spec().partitionType()).fields());
        if (this.table.spec().fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    @Override
    public String location() {
        return this.table.currentSnapshot().manifestListLocation();
    }

    private static class ManifestReadTask
    implements DataTask {
        private final FileIO io;
        private final FileScanTask manifestTask;
        private final Schema schema;

        private ManifestReadTask(FileIO io, FileScanTask manifestTask, Schema schema) {
            this.io = io;
            this.manifestTask = manifestTask;
            this.schema = schema;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            return CloseableIterable.transform(ManifestReader.read(this.io.newInputFile(this.manifestTask.file().path().toString())).project(this.schema), file -> (GenericDataFile)file);
        }

        @Override
        public DataFile file() {
            return this.manifestTask.file();
        }

        @Override
        public PartitionSpec spec() {
            return this.manifestTask.spec();
        }

        @Override
        public long start() {
            return 0L;
        }

        @Override
        public long length() {
            return this.manifestTask.length();
        }

        @Override
        public Expression residual() {
            return this.manifestTask.residual();
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }

    public static class FilesTableScan
    extends BaseTableScan {
        private static final long TARGET_SPLIT_SIZE = 0x2000000L;
        private final Schema fileSchema;

        FilesTableScan(TableOperations ops, Table table, Schema fileSchema) {
            super(ops, table, fileSchema);
            this.fileSchema = fileSchema;
        }

        private FilesTableScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, Schema fileSchema, ImmutableMap<String, String> options) {
            super(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, options);
            this.fileSchema = fileSchema;
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, ImmutableMap<String, String> options) {
            return new FilesTableScan(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, this.fileSchema, options);
        }

        @Override
        protected long targetSplitSize(TableOperations ops) {
            return 0x2000000L;
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean caseSensitive, boolean colStats) {
            AvroIterable manifests = Avro.read(ops.io().newInputFile(snapshot.manifestListLocation())).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).project(ManifestFile.schema()).reuseContainers(false).build();
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            return CloseableIterable.transform(manifests, manifest -> new ManifestReadTask(ops.io(), new BaseFileScanTask(DataFiles.fromManifest(manifest), schemaString, specString, ResidualEvaluator.unpartitioned(rowFilter)), this.fileSchema));
        }
    }
}

