/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableScan
extends BaseTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(DataTableScan.class);
    private static final List<String> SCAN_COLUMNS = ImmutableList.of("snapshot_id", "file_path", "file_ordinal", "file_format", "block_size_in_bytes", "file_size_in_bytes", "record_count", "partition", "key_metadata");
    private static final List<String> SCAN_WITH_STATS_COLUMNS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(SCAN_COLUMNS)).add(new String[]{"value_counts", "null_value_counts", "lower_bounds", "upper_bounds", "column_sizes"})).build();
    private static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    public DataTableScan(TableOperations ops, Table table) {
        super(ops, table, table.schema());
    }

    protected DataTableScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, ImmutableMap<String, String> options) {
        super(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, options);
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, ImmutableMap<String, String> options) {
        return new DataTableScan(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, options);
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean caseSensitive, boolean colStats) {
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = ops.current().spec((int)specId);
            return ManifestEvaluator.forRowFilter(rowFilter, spec, caseSensitive);
        });
        Iterable<ManifestFile> nonEmptyManifests = Iterables.filter(snapshot.manifests(), manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles());
        Iterable<ManifestFile> matchingManifests = Iterables.filter(nonEmptyManifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        Iterable readers = Iterables.transform(matchingManifests, manifest -> {
            ManifestReader reader = ManifestReader.read(ops.io().newInputFile(manifest.path()), ops.current()::spec);
            PartitionSpec spec = ops.current().spec(manifest.partitionSpecId());
            String schemaString = SchemaParser.toJson(spec.schema());
            String specString = PartitionSpecParser.toJson(spec);
            ResidualEvaluator residuals = ResidualEvaluator.of(spec, rowFilter, caseSensitive);
            return CloseableIterable.transform(reader.filterRows(rowFilter).caseSensitive(caseSensitive).select(colStats ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS), file -> new BaseFileScanTask((DataFile)file, schemaString, specString, residuals));
        });
        if (PLAN_SCANS_WITH_WORKER_POOL && snapshot.manifests().size() > 1) {
            return new ParallelIterable<FileScanTask>(readers, ThreadPools.getWorkerPool());
        }
        return CloseableIterable.concat(readers);
    }

    @Override
    protected long targetSplitSize(TableOperations ops) {
        return ops.current().propertyAsLong("read.split.target-size", 0x8000000L);
    }
}

