/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;

class FastAppend
extends SnapshotProducer<AppendFiles>
implements AppendFiles {
    private final TableOperations ops;
    private final PartitionSpec spec;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
    private final List<DataFile> newFiles = Lists.newArrayList();
    private final List<ManifestFile> appendManifests = Lists.newArrayList();
    private ManifestFile newManifest = null;
    private final AtomicInteger manifestCount = new AtomicInteger(0);
    private boolean hasNewFiles = false;

    FastAppend(TableOperations ops) {
        super(ops);
        this.ops = ops;
        this.spec = ops.current().spec();
    }

    @Override
    protected AppendFiles self() {
        return this;
    }

    @Override
    public AppendFiles set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this;
    }

    @Override
    protected String operation() {
        return "append";
    }

    @Override
    protected Map<String, String> summary() {
        return this.summaryBuilder.build();
    }

    @Override
    public FastAppend appendFile(DataFile file) {
        this.hasNewFiles = true;
        this.newFiles.add(file);
        this.summaryBuilder.addedFile(this.spec, file);
        return this;
    }

    @Override
    public FastAppend appendManifest(ManifestFile manifest) {
        try (ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);){
            OutputFile newManifestPath = this.manifestPath(this.manifestCount.getAndIncrement());
            this.appendManifests.add(ManifestWriter.copyAppendManifest(reader, newManifestPath, this.snapshotId(), this.summaryBuilder));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest: %s", manifest);
        }
        return this;
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        ArrayList<ManifestFile> newManifests = Lists.newArrayList();
        try {
            ManifestFile manifest = this.writeManifest();
            if (manifest != null) {
                newManifests.add(manifest);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write manifest", new Object[0]);
        }
        newManifests.addAll(this.appendManifests);
        if (base.currentSnapshot() != null) {
            newManifests.addAll(base.currentSnapshot().manifests());
        }
        return newManifests;
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        if (this.newManifest != null && !committed.contains(this.newManifest)) {
            this.deleteFile(this.newManifest.path());
        }
        for (ManifestFile manifest : this.appendManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
    }

    private ManifestFile writeManifest() throws IOException {
        if (this.hasNewFiles && this.newManifest != null) {
            this.deleteFile(this.newManifest.path());
            this.newManifest = null;
        }
        if (this.newManifest == null && this.newFiles.size() > 0) {
            OutputFile out = this.manifestPath(this.manifestCount.getAndIncrement());
            try (ManifestWriter writer = new ManifestWriter(this.spec, out, this.snapshotId());){
                writer.addAll(this.newFiles);
            }
            this.newManifest = writer.toManifestFile();
            this.hasNewFiles = false;
        }
        return this.newManifest;
    }
}

