/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Filterable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Iterators;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;

public class FilteredManifest
implements Filterable<FilteredManifest> {
    private static final Set<String> STATS_COLUMNS = Sets.newHashSet("value_counts", "null_value_counts", "lower_bounds", "upper_bounds");
    private final ManifestReader reader;
    private final Expression partFilter;
    private final Expression rowFilter;
    private final Schema fileSchema;
    private final Collection<String> columns;
    private final boolean caseSensitive;
    private Evaluator lazyEvaluator = null;
    private InclusiveMetricsEvaluator lazyMetricsEvaluator = null;

    FilteredManifest(ManifestReader reader, Expression partFilter, Expression rowFilter, Schema fileSchema, Collection<String> columns, boolean caseSensitive) {
        Preconditions.checkNotNull(reader, "ManifestReader cannot be null");
        this.reader = reader;
        this.partFilter = partFilter;
        this.rowFilter = rowFilter;
        this.fileSchema = fileSchema;
        this.columns = columns;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public FilteredManifest select(Collection<String> selectedColumns) {
        return new FilteredManifest(this.reader, this.partFilter, this.rowFilter, this.fileSchema, selectedColumns, this.caseSensitive);
    }

    @Override
    public FilteredManifest project(Schema fileProjection) {
        return new FilteredManifest(this.reader, this.partFilter, this.rowFilter, fileProjection, this.columns, this.caseSensitive);
    }

    @Override
    public FilteredManifest filterPartitions(Expression expr) {
        return new FilteredManifest(this.reader, Expressions.and(this.partFilter, expr), this.rowFilter, this.fileSchema, this.columns, this.caseSensitive);
    }

    @Override
    public FilteredManifest filterRows(Expression expr) {
        return new FilteredManifest(this.reader, this.partFilter, Expressions.and(this.rowFilter, expr), this.fileSchema, this.columns, this.caseSensitive);
    }

    @Override
    public FilteredManifest caseSensitive(boolean isCaseSensitive) {
        return new FilteredManifest(this.reader, this.partFilter, this.rowFilter, this.fileSchema, this.columns, isCaseSensitive);
    }

    CloseableIterable<ManifestEntry> allEntries() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            return CloseableIterable.filter(this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), entry -> entry != null && evaluator.eval(entry.file().partition()) && metricsEvaluator.eval(entry.file()));
        }
        return this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive));
    }

    CloseableIterable<ManifestEntry> liveEntries() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            return CloseableIterable.filter(this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), entry -> entry != null && entry.status() != ManifestEntry.Status.DELETED && evaluator.eval(entry.file().partition()) && metricsEvaluator.eval(entry.file()));
        }
        return CloseableIterable.filter(this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), entry -> entry != null && entry.status() != ManifestEntry.Status.DELETED);
    }

    @Override
    public Iterator<DataFile> iterator() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            ArrayList<String> projectColumns = Lists.newArrayList(this.columns);
            projectColumns.addAll(STATS_COLUMNS);
            boolean dropStats = Sets.intersection(Sets.newHashSet(this.columns), STATS_COLUMNS).isEmpty();
            return Iterators.transform(Iterators.filter(this.reader.iterator(this.partFilter, FilteredManifest.projection(this.fileSchema, projectColumns, this.caseSensitive)), input -> input != null && evaluator.eval(input.partition()) && metricsEvaluator.eval((DataFile)input)), dropStats ? DataFile::copyWithoutStats : DataFile::copy);
        }
        return Iterators.transform(this.reader.iterator(this.partFilter, FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), DataFile::copy);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static Schema projection(Schema fileSchema, Collection<String> columns, boolean caseSensitive) {
        if (columns != null) {
            if (caseSensitive) {
                return fileSchema.select(columns);
            }
            return fileSchema.caseInsensitiveSelect(columns);
        }
        return fileSchema;
    }

    private Evaluator evaluator() {
        if (this.lazyEvaluator == null) {
            Expression projected = Projections.inclusive(this.reader.spec(), this.caseSensitive).project(this.rowFilter);
            Expression finalPartFilter = Expressions.and(projected, this.partFilter);
            this.lazyEvaluator = finalPartFilter != null ? new Evaluator(this.reader.spec().partitionType(), finalPartFilter, this.caseSensitive) : new Evaluator(this.reader.spec().partitionType(), Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyEvaluator;
    }

    private InclusiveMetricsEvaluator metricsEvaluator() {
        if (this.lazyMetricsEvaluator == null) {
            this.lazyMetricsEvaluator = this.rowFilter != null ? new InclusiveMetricsEvaluator(this.reader.spec().schema(), this.rowFilter, this.caseSensitive) : new InclusiveMetricsEvaluator(this.reader.spec().schema(), Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyMetricsEvaluator;
    }
}

